/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.warmer;

import java.io.IOException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public class WarmerStats
implements Writeable,
ToXContentFragment {
    private long current;
    private long total;
    private long totalTimeInMillis;

    public WarmerStats() {
    }

    public WarmerStats(StreamInput in) throws IOException {
        this.current = in.readVLong();
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
    }

    public WarmerStats(long current, long total, long totalTimeInMillis) {
        this.current = current;
        this.total = total;
        this.totalTimeInMillis = totalTimeInMillis;
    }

    public void add(long current, long total, long totalTimeInMillis) {
        this.current += current;
        this.total += total;
        this.totalTimeInMillis += totalTimeInMillis;
    }

    public void add(WarmerStats warmerStats) {
        if (warmerStats == null) {
            return;
        }
        this.current += warmerStats.current;
        this.total += warmerStats.total;
        this.totalTimeInMillis += warmerStats.totalTimeInMillis;
    }

    public long current() {
        return this.current;
    }

    public long total() {
        return this.total;
    }

    public long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public TimeValue totalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("warmer");
        builder.field("current", this.current);
        builder.field("total", this.total);
        builder.humanReadableField("total_time_in_millis", "total_time", this.totalTime());
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.current);
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
    }

    static final class Fields {
        static final String WARMER = "warmer";
        static final String CURRENT = "current";
        static final String TOTAL = "total";
        static final String TOTAL_TIME = "total_time";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";

        Fields() {
        }
    }
}

