/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.opensearch.OpenSearchException;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.rest.RestRequest;

public interface RestRequestFilter {
    default public RestRequest getFilteredRequest(final RestRequest restRequest) throws IOException {
        final Set<String> fields = this.getFilteredFields();
        if (restRequest.hasContent() && !fields.isEmpty()) {
            return new RestRequest(restRequest){
                private BytesReference filteredBytes;
                {
                    super(restRequest3);
                    this.filteredBytes = null;
                }

                @Override
                public boolean hasContent() {
                    return true;
                }

                @Override
                public BytesReference content() {
                    if (this.filteredBytes == null) {
                        BytesReference content = restRequest.content();
                        Tuple<XContentType, Map<String, Object>> result = XContentHelper.convertToMap(content, true);
                        Map<String, Object> transformedSource = XContentMapValues.filter(result.v2(), null, fields.toArray(Strings.EMPTY_ARRAY));
                        try {
                            XContentBuilder xContentBuilder = XContentBuilder.builder(result.v1().xContent()).map(transformedSource);
                            this.filteredBytes = BytesReference.bytes(xContentBuilder);
                        }
                        catch (IOException e) {
                            throw new OpenSearchException("failed to parse request", (Throwable)e, new Object[0]);
                        }
                    }
                    return this.filteredBytes;
                }
            };
        }
        return restRequest;
    }

    public Set<String> getFilteredFields();
}

