/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.Strings;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestIndexPutAliasAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestIndexPutAliasAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_alias/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_alias/{name}"), new RestHandler.Route(RestRequest.Method.POST, "/_alias/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/_alias/{name}"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_aliases/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_aliases/{name}"), new RestHandler.Route(RestRequest.Method.POST, "/_aliases/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/_aliases/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_alias"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_aliases"), new RestHandler.Route(RestRequest.Method.PUT, "/_alias")));
    }

    @Override
    public String getName() {
        return "index_put_alias_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String alias = request.param("name");
        Map<String, Object> filter = null;
        String routing = null;
        String indexRouting = null;
        String searchRouting = null;
        Boolean writeIndex = null;
        if (request.hasContent()) {
            try (XContentParser parser = request.contentParser();){
                XContentParser.Token token = parser.nextToken();
                if (token == null) {
                    throw new IllegalArgumentException("No index alias is specified");
                }
                String currentFieldName = null;
                while ((token = parser.nextToken()) != null) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if ("index".equals(currentFieldName)) {
                            indices = Strings.splitStringByCommaToArray(parser.text());
                            continue;
                        }
                        if ("alias".equals(currentFieldName)) {
                            alias = parser.text();
                            continue;
                        }
                        if ("routing".equals(currentFieldName)) {
                            routing = parser.textOrNull();
                            continue;
                        }
                        if ("indexRouting".equals(currentFieldName) || "index-routing".equals(currentFieldName) || "index_routing".equals(currentFieldName)) {
                            indexRouting = parser.textOrNull();
                            continue;
                        }
                        if ("searchRouting".equals(currentFieldName) || "search-routing".equals(currentFieldName) || "search_routing".equals(currentFieldName)) {
                            searchRouting = parser.textOrNull();
                            continue;
                        }
                        if (!"is_write_index".equals(currentFieldName)) continue;
                        writeIndex = parser.booleanValue();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT || !"filter".equals(currentFieldName)) continue;
                    filter = parser.mapOrdered();
                }
            }
        }
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.timeout(request.paramAsTime("timeout", indicesAliasesRequest.timeout()));
        indicesAliasesRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", indicesAliasesRequest.clusterManagerNodeTimeout()));
        RestIndexPutAliasAction.parseDeprecatedMasterTimeoutParameter(indicesAliasesRequest, request);
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().indices(indices).alias(alias);
        if (routing != null) {
            aliasAction.routing(routing);
        }
        if (searchRouting != null) {
            aliasAction.searchRouting(searchRouting);
        }
        if (indexRouting != null) {
            aliasAction.indexRouting(indexRouting);
        }
        if (filter != null) {
            aliasAction.filter(filter);
        }
        if (writeIndex != null) {
            aliasAction.writeIndex(writeIndex);
        }
        indicesAliasesRequest.addAliasAction(aliasAction);
        return channel -> client.admin().indices().aliases(indicesAliasesRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

