/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.ParsedMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.terms.RareTerms;

public abstract class ParsedRareTerms
extends ParsedMultiBucketAggregation<ParsedBucket>
implements RareTerms {
    @Override
    public List<? extends RareTerms.Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public RareTerms.Bucket getBucketByKey(String term) {
        for (RareTerms.Bucket bucket : this.getBuckets()) {
            if (!bucket.getKeyAsString().equals(term)) continue;
            return bucket;
        }
        return null;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (RareTerms.Bucket bucket : this.getBuckets()) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    static void declareParsedTermsFields(ObjectParser<? extends ParsedRareTerms, Void> objectParser, CheckedFunction<XContentParser, ParsedBucket, IOException> bucketParser) {
        ParsedRareTerms.declareMultiBucketAggregationFields(objectParser, bucketParser::apply, bucketParser::apply);
    }

    public static abstract class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements RareTerms.Bucket {
        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            this.getAggregations().toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        static <B extends ParsedBucket> B parseRareTermsBucketXContent(XContentParser parser, Supplier<B> bucketSupplier, CheckedBiConsumer<XContentParser, B, IOException> keyConsumer) throws IOException {
            XContentParser.Token token;
            ParsedBucket bucket = (ParsedBucket)bucketSupplier.get();
            ArrayList aggregations = new ArrayList();
            String currentFieldName = parser.currentName();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (Aggregation.CommonFields.KEY_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setKeyAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                        keyConsumer.accept(parser, bucket);
                        continue;
                    }
                    if (!Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) continue;
                    bucket.setDocCount(parser.longValue());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                XContentParserUtils.parseTypedKeysObject(parser, "#", Aggregation.class, aggregations::add);
            }
            bucket.setAggregations(new Aggregations(aggregations));
            return (B)bucket;
        }
    }
}

