/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support.values;

import java.io.IOException;
import java.lang.reflect.Array;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.search.Scorable;
import org.joda.time.ReadableInstant;
import org.opensearch.common.lucene.ScorerAware;
import org.opensearch.index.fielddata.AbstractSortingNumericDocValues;
import org.opensearch.script.AggregationScript;
import org.opensearch.script.JodaCompatibleZonedDateTime;
import org.opensearch.search.aggregations.AggregationExecutionException;

public class ScriptLongValues
extends AbstractSortingNumericDocValues
implements ScorerAware {
    final AggregationScript script;

    public ScriptLongValues(AggregationScript script) {
        this.script = script;
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        this.script.setDocument(target);
        Object value = this.script.execute();
        if (value == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return false;
            }
            this.resize(length);
            for (int i = 0; i < length; ++i) {
                this.values[i] = ScriptLongValues.toLongValue(Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            if (coll.isEmpty()) {
                return false;
            }
            this.resize(coll.size());
            int i = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                this.values[i] = ScriptLongValues.toLongValue(it.next());
                ++i;
            }
            assert (i == this.docValueCount());
        } else {
            this.resize(1);
            this.values[0] = ScriptLongValues.toLongValue(value);
        }
        this.sort();
        return true;
    }

    private static long toLongValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof ReadableInstant) {
            return ((ReadableInstant)o).getMillis();
        }
        if (o instanceof ZonedDateTime) {
            return ((ZonedDateTime)o).toInstant().toEpochMilli();
        }
        if (o instanceof JodaCompatibleZonedDateTime) {
            return ((JodaCompatibleZonedDateTime)o).toInstant().toEpochMilli();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        throw new AggregationExecutionException("Unsupported script value [" + o + "], expected a number, date, or boolean");
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.script.setScorer(scorer);
    }
}

