/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.MultiCollectorManager;
import org.opensearch.search.profile.query.InternalProfileCollectorManager;
import org.opensearch.search.profile.query.ProfileCollectorManager;
import org.opensearch.search.query.QueryCollectorContext;
import org.opensearch.search.query.ReduceableSearchResult;

public abstract class QueryCollectorManagerContext {
    public static CollectorManager<? extends Collector, ReduceableSearchResult> createOpaqueCollectorManager(List<CollectorManager<? extends Collector, ReduceableSearchResult>> managers) throws IOException {
        return new OpaqueQueryCollectorManager(managers);
    }

    public static CollectorManager<? extends Collector, ReduceableSearchResult> createMultiCollectorManager(List<QueryCollectorContext> collectors) throws IOException {
        ArrayList<CollectorManager<? extends Collector, ReduceableSearchResult>> managers = new ArrayList<CollectorManager<? extends Collector, ReduceableSearchResult>>();
        CollectorManager<?, ReduceableSearchResult> manager = null;
        for (QueryCollectorContext ctx : collectors) {
            manager = ctx.createManager(manager);
            managers.add(manager);
        }
        return new QueryCollectorManager(managers);
    }

    public static ProfileCollectorManager<? extends Collector, ReduceableSearchResult> createQueryCollectorManagerWithProfiler(List<QueryCollectorContext> collectors) throws IOException {
        InternalProfileCollectorManager manager = null;
        for (QueryCollectorContext ctx : collectors) {
            manager = ctx.createWithProfiler(manager);
        }
        return manager;
    }

    private static class OpaqueQueryCollectorManager
    extends QueryCollectorManager {
        private OpaqueQueryCollectorManager(Collection<CollectorManager<? extends Collector, ReduceableSearchResult>> managers) {
            super(managers);
        }

        @Override
        protected ReduceableSearchResult reduceWith(ReduceableSearchResult[] results) {
            return result -> {};
        }
    }

    private static class QueryCollectorManager
    implements CollectorManager<Collector, ReduceableSearchResult> {
        private final MultiCollectorManager manager;

        private QueryCollectorManager(Collection<CollectorManager<? extends Collector, ReduceableSearchResult>> managers) {
            this.manager = new MultiCollectorManager(managers.toArray(new CollectorManager[0]));
        }

        @Override
        public Collector newCollector() throws IOException {
            return this.manager.newCollector();
        }

        @Override
        public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
            Object[] results = this.manager.reduce(collectors);
            ReduceableSearchResult[] transformed = new ReduceableSearchResult[results.length];
            for (int i = 0; i < results.length; ++i) {
                assert (results[i] instanceof ReduceableSearchResult);
                transformed[i] = (ReduceableSearchResult)results[i];
            }
            return this.reduceWith(transformed);
        }

        protected ReduceableSearchResult reduceWith(ReduceableSearchResult[] results) {
            return result -> {
                for (ReduceableSearchResult r : results) {
                    r.reduce(result);
                }
            };
        }
    }
}

