/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.suggest.completion.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.common.Strings;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.ParseContext;

public abstract class ContextMapping<T extends ToXContent>
implements ToXContentFragment {
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_NAME = "name";
    protected final Type type;
    protected final String name;

    protected ContextMapping(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public Type type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public abstract Set<String> parseContext(ParseContext var1, XContentParser var2) throws IOException, OpenSearchParseException;

    protected abstract Set<String> parseContext(ParseContext.Document var1);

    protected abstract T fromXContent(XContentParser var1) throws IOException;

    public final List<InternalQueryContext> parseQueryContext(XContentParser parser) throws IOException, OpenSearchParseException {
        ArrayList<T> queryContexts = new ArrayList<T>();
        XContentParser.Token token = parser.nextToken();
        if (token == XContentParser.Token.START_ARRAY) {
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                queryContexts.add(this.fromXContent(parser));
            }
        } else {
            queryContexts.add(this.fromXContent(parser));
        }
        return this.toInternalQueryContexts(queryContexts);
    }

    protected abstract List<InternalQueryContext> toInternalQueryContexts(List<T> var1);

    protected abstract XContentBuilder toInnerXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public void validateReferences(Version indexVersionCreated, Function<String, MappedFieldType> fieldResolver) {
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FIELD_NAME, this.name);
        builder.field(FIELD_TYPE, this.type.name());
        this.toInnerXContent(builder, params);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextMapping that = (ContextMapping)o;
        if (this.type != that.type) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        try {
            return Strings.toString(this.toXContent(JsonXContent.contentBuilder(), ToXContent.EMPTY_PARAMS));
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public static enum Type {
        CATEGORY,
        GEO;


        public static Type fromString(String type) {
            if (type.equalsIgnoreCase("category")) {
                return CATEGORY;
            }
            if (type.equalsIgnoreCase("geo")) {
                return GEO;
            }
            throw new IllegalArgumentException("No context type for [" + type + "]");
        }
    }

    public static class InternalQueryContext {
        public final String context;
        public final int boost;
        public final boolean isPrefix;

        public InternalQueryContext(String context, int boost, boolean isPrefix) {
            this.context = context;
            this.boost = boost;
            this.isPrefix = isPrefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternalQueryContext that = (InternalQueryContext)o;
            if (this.boost != that.boost) {
                return false;
            }
            if (this.isPrefix != that.isPrefix) {
                return false;
            }
            return this.context != null ? this.context.equals(that.context) : that.context == null;
        }

        public int hashCode() {
            int result = this.context != null ? this.context.hashCode() : 0;
            result = 31 * result + this.boost;
            result = 31 * result + (this.isPrefix ? 1 : 0);
            return result;
        }

        public String toString() {
            return "QueryContext{context='" + this.context + "', boost=" + this.boost + ", isPrefix=" + this.isPrefix + "}";
        }
    }
}

