/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.powerbi;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.client.netty.NettyHttpClientFactory;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.uri.UriTemplate;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;

public abstract class AbstractPowerBi
extends Task {
    @NotNull
    @NotEmpty
    @Schema(title="Azure tenant ID.")
    @PluginProperty(dynamic=true)
    private String tenantId;
    @NotNull
    @NotEmpty
    @Schema(title="Azure client ID.")
    @PluginProperty(dynamic=true)
    private String clientId;
    @NotNull
    @NotEmpty
    @Schema(title="Azure client secret.")
    @PluginProperty(dynamic=true)
    private String clientSecret;
    private transient String token;
    private static final Duration HTTP_READ_TIMEOUT = Duration.ofSeconds(60L);
    private static final NettyHttpClientFactory FACTORY = new NettyHttpClientFactory();

    protected HttpClient client(RunContext runContext, String base) throws IllegalVariableEvaluationException, MalformedURLException, URISyntaxException {
        MediaTypeCodecRegistry mediaTypeCodecRegistry = (MediaTypeCodecRegistry)runContext.getApplicationContext().getBean(MediaTypeCodecRegistry.class);
        DefaultHttpClientConfiguration configuration = new DefaultHttpClientConfiguration();
        configuration.setReadTimeout(HTTP_READ_TIMEOUT);
        DefaultHttpClient client = (DefaultHttpClient)FACTORY.createClient(URI.create(base).toURL(), (HttpClientConfiguration)configuration);
        client.setMediaTypeCodecRegistry(mediaTypeCodecRegistry);
        return client;
    }

    private String token(RunContext runContext) throws IllegalVariableEvaluationException, MalformedURLException, URISyntaxException {
        if (this.token != null) {
            return this.token;
        }
        UriTemplate uriTemplate = UriTemplate.of((String)"/{tenantId}/oauth2/token");
        String uri = uriTemplate.expand(Map.of("tenantId", runContext.render(this.tenantId)));
        MutableHttpRequest request = HttpRequest.create((HttpMethod)HttpMethod.POST, (String)uri).contentType((CharSequence)"application/x-www-form-urlencoded").body((Object)("grant_type=client_credentials&client_id=" + runContext.render(this.clientId) + "&client_secret=" + runContext.render(this.clientSecret) + "&resource=https://analysis.windows.net/powerbi/api&scope=https://analysis.windows.net/powerbi/api/.default"));
        try (HttpClient client = this.client(runContext, "https://login.microsoftonline.com");){
            HttpResponse exchange = client.toBlocking().exchange((HttpRequest)request, Argument.mapOf(String.class, String.class));
            Map token = (Map)exchange.body();
            if (token == null || !token.containsKey("access_token")) {
                throw new IllegalStateException("Invalid token request with response " + String.valueOf(token));
            }
            String string = this.token = (String)token.get("access_token");
            return string;
        }
    }

    protected <REQ, RES> HttpResponse<RES> request(RunContext runContext, MutableHttpRequest<REQ> request, Argument<RES> argument) throws HttpClientResponseException {
        HttpResponse httpResponse;
        block9: {
            request = request.bearerAuth((CharSequence)this.token(runContext)).contentType((CharSequence)"application/json");
            HttpClient client = this.client(runContext, "https://api.powerbi.com/");
            try {
                httpResponse = client.toBlocking().exchange((HttpRequest)request, argument);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpClientResponseException e) {
                    throw new HttpClientResponseException("Request failed '" + e.getStatus().getCode() + "' and body '" + e.getResponse().getBody(String.class).orElse("null") + "'", e.getResponse());
                }
                catch (IllegalVariableEvaluationException | MalformedURLException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            client.close();
        }
        return httpResponse;
    }

    @Generated
    protected AbstractPowerBi(AbstractPowerBiBuilder<?, ?> b) {
        super(b);
        this.tenantId = b.tenantId;
        this.clientId = b.clientId;
        this.clientSecret = b.clientSecret;
        this.token = b.token;
    }

    @Generated
    public String toString() {
        return "AbstractPowerBi(super=" + super.toString() + ", tenantId=" + this.getTenantId() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", token=" + this.token + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPowerBi)) {
            return false;
        }
        AbstractPowerBi other = (AbstractPowerBi)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        return !(this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractPowerBi;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        return result;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public AbstractPowerBi() {
    }

    @Generated
    public static abstract class AbstractPowerBiBuilder<C extends AbstractPowerBi, B extends AbstractPowerBiBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String tenantId;
        @Generated
        private String clientId;
        @Generated
        private String clientSecret;
        @Generated
        private String token;

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return (B)this.self();
        }

        @Generated
        public B clientId(String clientId) {
            this.clientId = clientId;
            return (B)this.self();
        }

        @Generated
        public B clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return (B)this.self();
        }

        @Generated
        public B token(String token) {
            this.token = token;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractPowerBi.AbstractPowerBiBuilder(super=" + super.toString() + ", tenantId=" + this.tenantId + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", token=" + this.token + ")";
        }
    }
}

