/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.powerbi;

import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.powerbi.AbstractPowerBi;
import io.kestra.plugin.powerbi.models.Refresh;
import io.kestra.plugin.powerbi.models.Refreshes;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.uri.UriTemplate;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Triggers a refresh for the specified dataset from the specified workspace.", description="An [asynchronous refresh](https://docs.microsoft.com/en-us/power-bi/connect-data/asynchronous-refresh) would be triggered.")
public class RefreshGroupDataset
extends AbstractPowerBi
implements RunnableTask<Output> {
    @Schema(title="The workspace ID.")
    @PluginProperty(dynamic=true)
    private String groupId;
    @Schema(title="The dataset ID.")
    @PluginProperty(dynamic=true)
    private String datasetId;
    @Schema(title="Wait for refresh completion.")
    @PluginProperty
    private Boolean wait;
    @Schema(title="The duration to wait between the polls.")
    @NotNull
    @PluginProperty
    private final Duration pollDuration;
    @Schema(title="The maximum duration to wait until the refresh completes.")
    @NotNull
    @PluginProperty
    private final Duration waitDuration;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        HttpResponse create = this.request(runContext, HttpRequest.create((HttpMethod)HttpMethod.POST, (String)UriTemplate.of((String)"/v1.0/myorg/groups/{groupId}/datasets/{datasetId}/refreshes").expand(Map.of("groupId", runContext.render(this.groupId), "datasetId", runContext.render(this.datasetId)))), Argument.of(Object.class));
        String refreshId = (String)create.getHeaders().get((CharSequence)"RequestId");
        if (refreshId == null) {
            throw new IllegalStateException("Invalid request, missing RequestId headers, body '" + String.valueOf(create.getBody().orElse(null)) + "', header '" + String.valueOf(create.getHeaders()) + "'");
        }
        logger.info("Refresh created with id '{}'", (Object)refreshId);
        if (!this.wait.booleanValue()) {
            return Output.builder().requestId(refreshId).build();
        }
        Refresh result = (Refresh)Await.until((Supplier)Rethrow.throwSupplier(() -> {
            try {
                HttpResponse response = this.request(runContext, HttpRequest.create((HttpMethod)HttpMethod.GET, (String)UriTemplate.of((String)"/v1.0/myorg/groups/{groupId}/datasets/{datasetId}/refreshes").expand(Map.of("groupId", runContext.render(this.groupId), "datasetId", runContext.render(this.datasetId)))), Argument.of(Refreshes.class));
                Optional<Refresh> refresh = response.getBody().stream().flatMap(refreshes -> refreshes.getValue().stream()).filter(r -> r.getRequestId().equals(refreshId)).findFirst();
                if (refresh.isEmpty()) {
                    throw new IllegalStateException("Unable to find refresh '" + refreshId + "'");
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Refresh: {}", (Object)refresh.get());
                }
                if (refresh.get().getStatus().equals("Unknown")) {
                    return null;
                }
                return refresh.get();
            }
            catch (HttpClientResponseException e) {
                throw new Exception(e);
            }
        }), (Duration)this.pollDuration, (Duration)this.waitDuration);
        if (!result.getStatus().toLowerCase(Locale.ROOT).equals("completed")) {
            throw new Exception("Refresh failed with status '" + result.getStatus() + "' with response " + String.valueOf(result));
        }
        return Output.builder().requestId(refreshId).status(result.getStatus()).build();
    }

    @Generated
    private static Boolean $default$wait() {
        return false;
    }

    @Generated
    private static Duration $default$pollDuration() {
        return Duration.ofSeconds(5L);
    }

    @Generated
    private static Duration $default$waitDuration() {
        return Duration.ofMinutes(10L);
    }

    @Generated
    protected RefreshGroupDataset(RefreshGroupDatasetBuilder<?, ?> b) {
        super(b);
        this.groupId = b.groupId;
        this.datasetId = b.datasetId;
        this.wait = b.wait$set ? b.wait$value : RefreshGroupDataset.$default$wait();
        this.pollDuration = b.pollDuration$set ? b.pollDuration$value : RefreshGroupDataset.$default$pollDuration();
        this.waitDuration = b.waitDuration$set ? b.waitDuration$value : RefreshGroupDataset.$default$waitDuration();
    }

    @Generated
    public static RefreshGroupDatasetBuilder<?, ?> builder() {
        return new RefreshGroupDatasetBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "RefreshGroupDataset(super=" + super.toString() + ", groupId=" + this.getGroupId() + ", datasetId=" + this.getDatasetId() + ", wait=" + this.getWait() + ", pollDuration=" + String.valueOf(this.getPollDuration()) + ", waitDuration=" + String.valueOf(this.getWaitDuration()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefreshGroupDataset)) {
            return false;
        }
        RefreshGroupDataset other = (RefreshGroupDataset)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$wait = this.getWait();
        Boolean other$wait = other.getWait();
        if (this$wait == null ? other$wait != null : !((Object)this$wait).equals(other$wait)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$datasetId = this.getDatasetId();
        String other$datasetId = other.getDatasetId();
        if (this$datasetId == null ? other$datasetId != null : !this$datasetId.equals(other$datasetId)) {
            return false;
        }
        Duration this$pollDuration = this.getPollDuration();
        Duration other$pollDuration = other.getPollDuration();
        if (this$pollDuration == null ? other$pollDuration != null : !((Object)this$pollDuration).equals(other$pollDuration)) {
            return false;
        }
        Duration this$waitDuration = this.getWaitDuration();
        Duration other$waitDuration = other.getWaitDuration();
        return !(this$waitDuration == null ? other$waitDuration != null : !((Object)this$waitDuration).equals(other$waitDuration));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RefreshGroupDataset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $wait = this.getWait();
        result = result * 59 + ($wait == null ? 43 : ((Object)$wait).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $datasetId = this.getDatasetId();
        result = result * 59 + ($datasetId == null ? 43 : $datasetId.hashCode());
        Duration $pollDuration = this.getPollDuration();
        result = result * 59 + ($pollDuration == null ? 43 : ((Object)$pollDuration).hashCode());
        Duration $waitDuration = this.getWaitDuration();
        result = result * 59 + ($waitDuration == null ? 43 : ((Object)$waitDuration).hashCode());
        return result;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getDatasetId() {
        return this.datasetId;
    }

    @Generated
    public Boolean getWait() {
        return this.wait;
    }

    @Generated
    public Duration getPollDuration() {
        return this.pollDuration;
    }

    @Generated
    public Duration getWaitDuration() {
        return this.waitDuration;
    }

    @Generated
    public RefreshGroupDataset() {
        this.wait = RefreshGroupDataset.$default$wait();
        this.pollDuration = RefreshGroupDataset.$default$pollDuration();
        this.waitDuration = RefreshGroupDataset.$default$waitDuration();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The request ID.")
        private String requestId;
        @Schema(title="The request status.", description="Only populated if `wait` parameter is set to `true`.")
        private String status;

        @ConstructorProperties(value={"requestId", "status"})
        @Generated
        Output(String requestId, String status) {
            this.requestId = requestId;
            this.status = status;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String requestId;
            @Generated
            private String status;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder requestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public OutputBuilder status(String status) {
                this.status = status;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.requestId, this.status);
            }

            @Generated
            public String toString() {
                return "RefreshGroupDataset.Output.OutputBuilder(requestId=" + this.requestId + ", status=" + this.status + ")";
            }
        }
    }

    @Generated
    public static abstract class RefreshGroupDatasetBuilder<C extends RefreshGroupDataset, B extends RefreshGroupDatasetBuilder<C, B>>
    extends AbstractPowerBi.AbstractPowerBiBuilder<C, B> {
        @Generated
        private String groupId;
        @Generated
        private String datasetId;
        @Generated
        private boolean wait$set;
        @Generated
        private Boolean wait$value;
        @Generated
        private boolean pollDuration$set;
        @Generated
        private Duration pollDuration$value;
        @Generated
        private boolean waitDuration$set;
        @Generated
        private Duration waitDuration$value;

        @Generated
        public B groupId(String groupId) {
            this.groupId = groupId;
            return (B)((Object)this.self());
        }

        @Generated
        public B datasetId(String datasetId) {
            this.datasetId = datasetId;
            return (B)((Object)this.self());
        }

        @Generated
        public B wait(Boolean wait) {
            this.wait$value = wait;
            this.wait$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B pollDuration(Duration pollDuration) {
            this.pollDuration$value = pollDuration;
            this.pollDuration$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B waitDuration(Duration waitDuration) {
            this.waitDuration$value = waitDuration;
            this.waitDuration$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RefreshGroupDataset.RefreshGroupDatasetBuilder(super=" + super.toString() + ", groupId=" + this.groupId + ", datasetId=" + this.datasetId + ", wait$value=" + this.wait$value + ", pollDuration$value=" + String.valueOf(this.pollDuration$value) + ", waitDuration$value=" + String.valueOf(this.waitDuration$value) + ")";
        }
    }

    @Generated
    private static final class RefreshGroupDatasetBuilderImpl
    extends RefreshGroupDatasetBuilder<RefreshGroupDataset, RefreshGroupDatasetBuilderImpl> {
        @Generated
        private RefreshGroupDatasetBuilderImpl() {
        }

        @Override
        @Generated
        protected RefreshGroupDatasetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RefreshGroupDataset build() {
            return new RefreshGroupDataset(this);
        }
    }
}

