/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.models;

import io.kestra.core.models.annotations.PluginProperty;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Introspected
public class DockerOptions {
    @Schema(title="Docker api uri")
    @PluginProperty(dynamic=true)
    private String host;
    @Schema(title="Docker config file", description="Docker configuration file that can set access credentials to private container registries. Usually located in `~/.docker/config.json`")
    @PluginProperty(dynamic=true)
    private String config;
    @Schema(title="Docker image to use")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    protected String image;
    @Schema(title="User within the container")
    @PluginProperty(dynamic=true)
    protected String user;
    @Schema(title="Docker entrypoint to use")
    @PluginProperty(dynamic=true)
    protected List<String> entryPoint;
    @Schema(title="Extra hostname mappings to the container network interface configuration")
    @PluginProperty(dynamic=true)
    protected List<String> extraHosts;
    @Schema(title="Docker network mode to use e.g. `host`, `none`, etc.")
    @PluginProperty(dynamic=true)
    protected String networkMode;
    @Schema(title="List of volumes to mount", description="Must be a valid mount expression as string, example : `/home/user:/app`\n\nVolumes mount are disabled by default for security reasons; you must enable them on server configuration by setting `kestra.tasks.scripts.docker.volume-enabled` to `true`")
    @PluginProperty(dynamic=true)
    protected List<String> volumes;
    @Schema(title="The pull policy for an image", description="Pull policy can be used to prevent pulling of an already existing image `IF_NOT_PRESENT`, or can be set to `ALWAYS` to pull the latest version of the image even if an image with the same tag already exists.")
    @PluginProperty
    protected PullPolicy pullPolicy;
    @Schema(title="A list of device requests to be sent to device drivers")
    @PluginProperty(dynamic=false)
    protected List<DeviceRequest> deviceRequests;
    @Schema(title="Limits the CPU usage to a given maximum threshold value.", description="By default, each container\u2019s access to the host machine\u2019s CPU cycles is unlimited. You can set various constraints to limit a given container\u2019s access to the host machine\u2019s CPU cycles.")
    @PluginProperty(dynamic=false)
    protected Cpu cpu;
    @Schema(title="Limits memory usage to a given maximum threshold value.", description="Docker can enforce hard memory limits, which allow the container to use no more than a given amount of user or system memory, or soft limits, which allow the container to use as much memory as it needs unless certain conditions are met, such as when the kernel detects low memory or contention on the host machine. Some of these options have different effects when used alone or when more than one option is set.")
    @PluginProperty(dynamic=false)
    protected Memory memory;

    @Deprecated
    public void setDockerHost(String host) {
        this.host = host;
    }

    @Deprecated
    public void setDockerConfig(String config) {
        this.config = config;
    }

    @Generated
    private static PullPolicy $default$pullPolicy() {
        return PullPolicy.ALWAYS;
    }

    @Generated
    protected DockerOptions(DockerOptionsBuilder<?, ?> b) {
        this.host = b.host;
        this.config = b.config;
        this.image = b.image;
        this.user = b.user;
        this.entryPoint = b.entryPoint;
        this.extraHosts = b.extraHosts;
        this.networkMode = b.networkMode;
        this.volumes = b.volumes;
        this.pullPolicy = b.pullPolicy$set ? b.pullPolicy$value : DockerOptions.$default$pullPolicy();
        this.deviceRequests = b.deviceRequests;
        this.cpu = b.cpu;
        this.memory = b.memory;
    }

    @Generated
    public static DockerOptionsBuilder<?, ?> builder() {
        return new DockerOptionsBuilderImpl();
    }

    @Generated
    public DockerOptionsBuilder<?, ?> toBuilder() {
        return new DockerOptionsBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public DockerOptions() {
        this.pullPolicy = DockerOptions.$default$pullPolicy();
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getConfig() {
        return this.config;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public List<String> getEntryPoint() {
        return this.entryPoint;
    }

    @Generated
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    @Generated
    public String getNetworkMode() {
        return this.networkMode;
    }

    @Generated
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Generated
    public PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    @Generated
    public List<DeviceRequest> getDeviceRequests() {
        return this.deviceRequests;
    }

    @Generated
    public Cpu getCpu() {
        return this.cpu;
    }

    @Generated
    public Memory getMemory() {
        return this.memory;
    }

    @Introspected
    @Schema(title="The PullPolicy for a container and the tag of the image affect when docker attempts to pull (download) the specified image.")
    public static enum PullPolicy {
        IF_NOT_PRESENT,
        ALWAYS,
        NEVER;

    }

    @Generated
    public static abstract class DockerOptionsBuilder<C extends DockerOptions, B extends DockerOptionsBuilder<C, B>> {
        @Generated
        private String host;
        @Generated
        private String config;
        @Generated
        private String image;
        @Generated
        private String user;
        @Generated
        private List<String> entryPoint;
        @Generated
        private List<String> extraHosts;
        @Generated
        private String networkMode;
        @Generated
        private List<String> volumes;
        @Generated
        private boolean pullPolicy$set;
        @Generated
        private PullPolicy pullPolicy$value;
        @Generated
        private List<DeviceRequest> deviceRequests;
        @Generated
        private Cpu cpu;
        @Generated
        private Memory memory;

        @Generated
        protected B $fillValuesFrom(C instance) {
            DockerOptionsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DockerOptions instance, DockerOptionsBuilder<?, ?> b) {
            b.host(instance.host);
            b.config(instance.config);
            b.image(instance.image);
            b.user(instance.user);
            b.entryPoint(instance.entryPoint);
            b.extraHosts(instance.extraHosts);
            b.networkMode(instance.networkMode);
            b.volumes(instance.volumes);
            b.pullPolicy(instance.pullPolicy);
            b.deviceRequests(instance.deviceRequests);
            b.cpu(instance.cpu);
            b.memory(instance.memory);
        }

        @Generated
        public B host(String host) {
            this.host = host;
            return this.self();
        }

        @Generated
        public B config(String config) {
            this.config = config;
            return this.self();
        }

        @Generated
        public B image(String image) {
            this.image = image;
            return this.self();
        }

        @Generated
        public B user(String user) {
            this.user = user;
            return this.self();
        }

        @Generated
        public B entryPoint(List<String> entryPoint) {
            this.entryPoint = entryPoint;
            return this.self();
        }

        @Generated
        public B extraHosts(List<String> extraHosts) {
            this.extraHosts = extraHosts;
            return this.self();
        }

        @Generated
        public B networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this.self();
        }

        @Generated
        public B volumes(List<String> volumes) {
            this.volumes = volumes;
            return this.self();
        }

        @Generated
        public B pullPolicy(PullPolicy pullPolicy) {
            this.pullPolicy$value = pullPolicy;
            this.pullPolicy$set = true;
            return this.self();
        }

        @Generated
        public B deviceRequests(List<DeviceRequest> deviceRequests) {
            this.deviceRequests = deviceRequests;
            return this.self();
        }

        @Generated
        public B cpu(Cpu cpu) {
            this.cpu = cpu;
            return this.self();
        }

        @Generated
        public B memory(Memory memory) {
            this.memory = memory;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DockerOptions.DockerOptionsBuilder(host=" + this.host + ", config=" + this.config + ", image=" + this.image + ", user=" + this.user + ", entryPoint=" + this.entryPoint + ", extraHosts=" + this.extraHosts + ", networkMode=" + this.networkMode + ", volumes=" + this.volumes + ", pullPolicy$value=" + this.pullPolicy$value + ", deviceRequests=" + this.deviceRequests + ", cpu=" + this.cpu + ", memory=" + this.memory + ")";
        }
    }

    @Introspected
    public static class Cpu {
        @Schema(title="The maximum amount of CPU resources a container can use.", description="For instance, if the host machine has two CPUs and you set `cpus:\"1.5\"`, the container is guaranteed at most one and a half of the CPUs")
        @PluginProperty
        private Long cpus;

        @Generated
        protected Cpu(CpuBuilder<?, ?> b) {
            this.cpus = b.cpus;
        }

        @Generated
        public static CpuBuilder<?, ?> builder() {
            return new CpuBuilderImpl();
        }

        @Generated
        public Cpu() {
        }

        @Generated
        public Long getCpus() {
            return this.cpus;
        }

        @Generated
        public static abstract class CpuBuilder<C extends Cpu, B extends CpuBuilder<C, B>> {
            @Generated
            private Long cpus;

            @Generated
            public B cpus(Long cpus) {
                this.cpus = cpus;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DockerOptions.Cpu.CpuBuilder(cpus=" + this.cpus + ")";
            }
        }

        @Generated
        private static final class CpuBuilderImpl
        extends CpuBuilder<Cpu, CpuBuilderImpl> {
            @Generated
            private CpuBuilderImpl() {
            }

            @Override
            @Generated
            protected CpuBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Cpu build() {
                return new Cpu(this);
            }
        }
    }

    @Introspected
    public static class Memory {
        @Schema(title="The maximum amount of memory resources the container can use.", description="That is, you must set the value to at least 6 megabytes.")
        @PluginProperty(dynamic=true)
        private String memory;
        @Schema(title="The amount of memory this container is allowed to swap to disk", description="If `memory` and `memorySwap` are set to the same value, this prevents containers from using any swap. This is because `memorySwap` is the amount of combined memory and swap that can be used, while `memory` is only the amount of physical memory that can be used.")
        @PluginProperty(dynamic=true)
        private String memorySwap;
        @Schema(title="The amount of memory this container is allowed to swap to disk", description="By default, the host kernel can swap out a percentage of anonymous pages used by a container. You can set `memorySwappiness` to a value between 0 and 100, to tune this percentage.")
        @PluginProperty(dynamic=true)
        private String memorySwappiness;
        @Schema(title="Allows you to specify a soft limit smaller than --memory which is activated when Docker detects contention or low memory on the host machine.", description="If you use `memoryReservation`, it must be set lower than `memory` for it to take precedence. Because it is a soft limit, it does not guarantee that the container doesn\u2019t exceed the limit.")
        @PluginProperty(dynamic=true)
        private String memoryReservation;
        @Schema(title="The maximum amount of kernel memory the container can use.", description="The minimum allowed value is 4m. Because kernel memory cannot be swapped out, a container which is starved of kernel memory may block host machine resources, which can have side effects on the host machine and on other containers. See [--kernel-memory](https://docs.docker.com/config/containers/resource_constraints/#--kernel-memory-details) details.")
        @PluginProperty(dynamic=true)
        private String kernelMemory;
        @Schema(title="By default, if an out-of-memory (OOM) error occurs, the kernel kills processes in a container.", description="To change this behavior, use the `oomKillDisable` option. Only disable the OOM killer on containers where you have also set the `memory` option. If the `memory` flag is not set, the host can run out of memory, and the kernel may need to kill the host system\u2019s processes to free the memory.")
        @PluginProperty(dynamic=false)
        private Boolean oomKillDisable;

        @Generated
        protected Memory(MemoryBuilder<?, ?> b) {
            this.memory = b.memory;
            this.memorySwap = b.memorySwap;
            this.memorySwappiness = b.memorySwappiness;
            this.memoryReservation = b.memoryReservation;
            this.kernelMemory = b.kernelMemory;
            this.oomKillDisable = b.oomKillDisable;
        }

        @Generated
        public static MemoryBuilder<?, ?> builder() {
            return new MemoryBuilderImpl();
        }

        @Generated
        public Memory() {
        }

        @Generated
        public String getMemory() {
            return this.memory;
        }

        @Generated
        public String getMemorySwap() {
            return this.memorySwap;
        }

        @Generated
        public String getMemorySwappiness() {
            return this.memorySwappiness;
        }

        @Generated
        public String getMemoryReservation() {
            return this.memoryReservation;
        }

        @Generated
        public String getKernelMemory() {
            return this.kernelMemory;
        }

        @Generated
        public Boolean getOomKillDisable() {
            return this.oomKillDisable;
        }

        @Generated
        public static abstract class MemoryBuilder<C extends Memory, B extends MemoryBuilder<C, B>> {
            @Generated
            private String memory;
            @Generated
            private String memorySwap;
            @Generated
            private String memorySwappiness;
            @Generated
            private String memoryReservation;
            @Generated
            private String kernelMemory;
            @Generated
            private Boolean oomKillDisable;

            @Generated
            public B memory(String memory) {
                this.memory = memory;
                return this.self();
            }

            @Generated
            public B memorySwap(String memorySwap) {
                this.memorySwap = memorySwap;
                return this.self();
            }

            @Generated
            public B memorySwappiness(String memorySwappiness) {
                this.memorySwappiness = memorySwappiness;
                return this.self();
            }

            @Generated
            public B memoryReservation(String memoryReservation) {
                this.memoryReservation = memoryReservation;
                return this.self();
            }

            @Generated
            public B kernelMemory(String kernelMemory) {
                this.kernelMemory = kernelMemory;
                return this.self();
            }

            @Generated
            public B oomKillDisable(Boolean oomKillDisable) {
                this.oomKillDisable = oomKillDisable;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DockerOptions.Memory.MemoryBuilder(memory=" + this.memory + ", memorySwap=" + this.memorySwap + ", memorySwappiness=" + this.memorySwappiness + ", memoryReservation=" + this.memoryReservation + ", kernelMemory=" + this.kernelMemory + ", oomKillDisable=" + this.oomKillDisable + ")";
            }
        }

        @Generated
        private static final class MemoryBuilderImpl
        extends MemoryBuilder<Memory, MemoryBuilderImpl> {
            @Generated
            private MemoryBuilderImpl() {
            }

            @Override
            @Generated
            protected MemoryBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Memory build() {
                return new Memory(this);
            }
        }
    }

    @Generated
    private static final class DockerOptionsBuilderImpl
    extends DockerOptionsBuilder<DockerOptions, DockerOptionsBuilderImpl> {
        @Generated
        private DockerOptionsBuilderImpl() {
        }

        @Override
        @Generated
        protected DockerOptionsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DockerOptions build() {
            return new DockerOptions(this);
        }
    }

    @Introspected
    @Schema(title="A request for devices to be sent to device drivers")
    public static class DeviceRequest {
        @PluginProperty(dynamic=true)
        private String driver;
        @PluginProperty
        private Integer count;
        @PluginProperty(dynamic=true)
        private List<String> deviceIds;
        @Schema(title="A list of capabilities; an OR list of AND lists of capabilities.")
        @PluginProperty
        private List<List<String>> capabilities;
        @Schema(title="Driver-specific options, specified as key/value pairs.", description="These options are passed directly to the driver.")
        @PluginProperty
        private Map<String, String> options;

        @Generated
        protected DeviceRequest(DeviceRequestBuilder<?, ?> b) {
            this.driver = b.driver;
            this.count = b.count;
            this.deviceIds = b.deviceIds;
            this.capabilities = b.capabilities;
            this.options = b.options;
        }

        @Generated
        public static DeviceRequestBuilder<?, ?> builder() {
            return new DeviceRequestBuilderImpl();
        }

        @Generated
        public DeviceRequest() {
        }

        @Generated
        public String getDriver() {
            return this.driver;
        }

        @Generated
        public Integer getCount() {
            return this.count;
        }

        @Generated
        public List<String> getDeviceIds() {
            return this.deviceIds;
        }

        @Generated
        public List<List<String>> getCapabilities() {
            return this.capabilities;
        }

        @Generated
        public Map<String, String> getOptions() {
            return this.options;
        }

        @Generated
        public static abstract class DeviceRequestBuilder<C extends DeviceRequest, B extends DeviceRequestBuilder<C, B>> {
            @Generated
            private String driver;
            @Generated
            private Integer count;
            @Generated
            private List<String> deviceIds;
            @Generated
            private List<List<String>> capabilities;
            @Generated
            private Map<String, String> options;

            @Generated
            public B driver(String driver) {
                this.driver = driver;
                return this.self();
            }

            @Generated
            public B count(Integer count) {
                this.count = count;
                return this.self();
            }

            @Generated
            public B deviceIds(List<String> deviceIds) {
                this.deviceIds = deviceIds;
                return this.self();
            }

            @Generated
            public B capabilities(List<List<String>> capabilities) {
                this.capabilities = capabilities;
                return this.self();
            }

            @Generated
            public B options(Map<String, String> options) {
                this.options = options;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DockerOptions.DeviceRequest.DeviceRequestBuilder(driver=" + this.driver + ", count=" + this.count + ", deviceIds=" + this.deviceIds + ", capabilities=" + this.capabilities + ", options=" + this.options + ")";
            }
        }

        @Generated
        private static final class DeviceRequestBuilderImpl
        extends DeviceRequestBuilder<DeviceRequest, DeviceRequestBuilderImpl> {
            @Generated
            private DeviceRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected DeviceRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DeviceRequest build() {
                return new DeviceRequest(this);
            }
        }
    }
}

