/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.runners;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ConnectionClosedException;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.models.tasks.retrys.Exponential;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.RetryUtils;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.runners.AbstractLogConsumer;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.kestra.plugin.scripts.exec.scripts.runners.RunnerResult;
import io.kestra.plugin.scripts.exec.scripts.runners.ScriptException;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.convert.format.ReadableBytesTypeConverter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class DockerScriptRunner {
    private static final ReadableBytesTypeConverter READABLE_BYTES_TYPE_CONVERTER = new ReadableBytesTypeConverter();
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("[\\r\\n]+$");
    private final RetryUtils retryUtils;
    private final Boolean volumesEnabled;

    public DockerScriptRunner(ApplicationContext applicationContext) {
        this.retryUtils = (RetryUtils)applicationContext.getBean(RetryUtils.class);
        this.volumesEnabled = applicationContext.getProperty("kestra.tasks.scripts.docker.volume-enabled", Boolean.class).orElse(false);
    }

    private static DockerClient dockerClient(DockerOptions dockerOptions, RunContext runContext, Path workingDirectory) throws IOException, IllegalVariableEvaluationException {
        DefaultDockerClientConfig.Builder dockerClientConfigBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        String dockerHost = null;
        if (dockerOptions != null) {
            if (dockerOptions.getHost() != null) {
                dockerHost = runContext.render(dockerOptions.getHost());
            }
            if (dockerOptions.getConfig() != null) {
                Path docker = Files.createTempDirectory(workingDirectory, "docker", new FileAttribute[0]);
                Path file = Files.createFile(docker.resolve("config.json"), new FileAttribute[0]);
                Files.write(file, runContext.render(dockerOptions.getConfig()).getBytes(), new OpenOption[0]);
                dockerClientConfigBuilder.withDockerConfig(docker.toFile().getAbsolutePath());
            }
        }
        if (dockerHost != null) {
            dockerClientConfigBuilder.withDockerHost(dockerHost);
        } else if (Files.exists(Path.of("/var/run/docker.sock", new String[0]), new LinkOption[0])) {
            dockerClientConfigBuilder.withDockerHost("unix:///var/run/docker.sock");
        } else if (Files.exists(Path.of("/dind/docker.sock", new String[0]), new LinkOption[0])) {
            dockerClientConfigBuilder.withDockerHost("unix:///dind/docker.sock");
        }
        DefaultDockerClientConfig dockerClientConfig = dockerClientConfigBuilder.build();
        ZerodepDockerHttpClient dockerHttpClient = new ZerodepDockerHttpClient.Builder().dockerHost(dockerClientConfig.getDockerHost()).build();
        return DockerClientBuilder.getInstance((DockerClientConfig)dockerClientConfig).withDockerHttpClient((DockerHttpClient)dockerHttpClient).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunnerResult run(CommandsWrapper commands, DockerOptions dockerOptions) throws Exception {
        if (dockerOptions == null) {
            throw new IllegalArgumentException("Missing required docker properties");
        }
        RunContext runContext = commands.getRunContext();
        Logger logger = commands.getRunContext().logger();
        String image = runContext.render(dockerOptions.getImage(), commands.getAdditionalVars());
        final AbstractLogConsumer defaultLogConsumer = commands.getLogConsumer();
        try (DockerClient dockerClient = DockerScriptRunner.dockerClient(dockerOptions, runContext, commands.getWorkingDirectory());){
            RunnerResult runnerResult;
            CreateContainerCmd container = this.configure(commands, dockerClient, dockerOptions);
            if (dockerOptions.getPullPolicy() != DockerOptions.PullPolicy.NEVER) {
                this.pullImage(dockerClient, image, dockerOptions.getPullPolicy(), logger);
            }
            CreateContainerResponse exec = container.exec();
            dockerClient.startContainerCmd(exec.getId()).exec();
            logger.debug("Starting command with container id {} [{}]", (Object)exec.getId(), (Object)String.join((CharSequence)" ", commands.getCommands()));
            final AtomicBoolean ended = new AtomicBoolean(false);
            try {
                dockerClient.logContainerCmd(exec.getId()).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback.Adapter<Frame>(){
                    private final Map<StreamType, StringBuilder> logBuffers = new HashMap<StreamType, StringBuilder>();

                    public void onNext(Frame frame) {
                        String frameStr = new String(frame.getPayload());
                        Matcher newLineMatcher = NEWLINE_PATTERN.matcher(frameStr);
                        this.logBuffers.computeIfAbsent(frame.getStreamType(), streamType -> new StringBuilder()).append(newLineMatcher.replaceAll(""));
                        if (newLineMatcher.reset().find()) {
                            StringBuilder logBuffer = this.logBuffers.get(frame.getStreamType());
                            defaultLogConsumer.accept(logBuffer.toString(), frame.getStreamType() == StreamType.STDERR);
                            logBuffer.setLength(0);
                        }
                    }

                    public void onComplete() {
                        try {
                            this.logBuffers.entrySet().stream().filter(entry -> !((StringBuilder)entry.getValue()).isEmpty()).forEach(Rethrow.throwConsumer(entry -> {
                                String log = ((StringBuilder)entry.getValue()).toString();
                                defaultLogConsumer.accept(log, entry.getKey() == StreamType.STDERR);
                            }));
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        ended.set(true);
                        super.onComplete();
                    }
                });
                WaitContainerResultCallback result = dockerClient.waitContainerCmd(exec.getId()).start();
                Integer exitCode = result.awaitStatusCode();
                Await.until(ended::get);
                if (exitCode != 0) {
                    throw new ScriptException(exitCode, defaultLogConsumer.getStdOutCount(), defaultLogConsumer.getStdErrCount());
                }
                logger.debug("Command succeed with code " + exitCode);
                runnerResult = new RunnerResult(exitCode, defaultLogConsumer);
            }
            catch (Throwable throwable) {
                try {
                    InspectContainerResponse inspect = dockerClient.inspectContainerCmd(exec.getId()).exec();
                    if (Boolean.TRUE.equals(inspect.getState().getRunning())) {
                        try {
                            dockerClient.killContainerCmd(exec.getId()).exec();
                        }
                        catch (Exception e) {
                            logger.error("Unable to kill a running container", (Throwable)e);
                        }
                    }
                    dockerClient.removeContainerCmd(exec.getId()).exec();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                InspectContainerResponse inspect = dockerClient.inspectContainerCmd(exec.getId()).exec();
                if (Boolean.TRUE.equals(inspect.getState().getRunning())) {
                    try {
                        dockerClient.killContainerCmd(exec.getId()).exec();
                    }
                    catch (Exception e) {
                        logger.error("Unable to kill a running container", (Throwable)e);
                    }
                }
                dockerClient.removeContainerCmd(exec.getId()).exec();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return runnerResult;
        }
    }

    private CreateContainerCmd configure(CommandsWrapper commands, DockerClient dockerClient, DockerOptions dockerOptions) throws IllegalVariableEvaluationException {
        if (dockerOptions.getImage() == null) {
            throw new IllegalArgumentException("Missing docker image");
        }
        RunContext runContext = commands.getRunContext();
        Path workingDirectory = commands.getWorkingDirectory();
        Map<String, Object> additionalVars = commands.getAdditionalVars();
        String image = runContext.render(dockerOptions.getImage(), additionalVars);
        CreateContainerCmd container = dockerClient.createContainerCmd(image);
        DockerScriptRunner.addMetadata(runContext, container);
        HostConfig hostConfig = new HostConfig();
        if (commands.getEnv() != null && !commands.getEnv().isEmpty()) {
            container.withEnv(commands.getEnv().entrySet().stream().map(Rethrow.throwFunction(r -> (String)r.getKey() + "=" + (String)r.getValue())).collect(Collectors.toList()));
        }
        if (workingDirectory != null) {
            container.withWorkingDir(workingDirectory.toFile().getAbsolutePath());
        }
        ArrayList<Bind> binds = new ArrayList<Bind>();
        if (workingDirectory != null) {
            binds.add(new Bind(workingDirectory.toAbsolutePath().toString(), new Volume(workingDirectory.toAbsolutePath().toString()), AccessMode.rw));
        }
        if (dockerOptions.getUser() != null) {
            container.withUser(runContext.render(dockerOptions.getUser(), additionalVars));
        }
        if (dockerOptions.getEntryPoint() != null) {
            container.withEntrypoint(runContext.render(dockerOptions.getEntryPoint(), additionalVars));
        }
        if (dockerOptions.getExtraHosts() != null) {
            hostConfig.withExtraHosts((String[])runContext.render(dockerOptions.getExtraHosts(), additionalVars).toArray(String[]::new));
        }
        if (this.volumesEnabled.booleanValue() && dockerOptions.getVolumes() != null) {
            binds.addAll(runContext.render(dockerOptions.getVolumes()).stream().map(Bind::parse).toList());
        }
        if (!binds.isEmpty()) {
            hostConfig.withBinds(binds);
        }
        if (dockerOptions.getDeviceRequests() != null) {
            hostConfig.withDeviceRequests(dockerOptions.getDeviceRequests().stream().map(Rethrow.throwFunction(deviceRequest -> new DeviceRequest().withDriver(runContext.render(deviceRequest.getDriver())).withCount(deviceRequest.getCount()).withDeviceIds(runContext.render(deviceRequest.getDeviceIds())).withCapabilities(deviceRequest.getCapabilities()).withOptions(deviceRequest.getOptions()))).collect(Collectors.toList()));
        }
        if (dockerOptions.getCpu() != null && dockerOptions.getCpu().getCpus() != null) {
            hostConfig.withCpuQuota(Long.valueOf(dockerOptions.getCpu().getCpus() * 10000L));
        }
        if (dockerOptions.getMemory() != null) {
            if (dockerOptions.getMemory().getMemory() != null) {
                hostConfig.withMemory(DockerScriptRunner.convertBytes(runContext.render(dockerOptions.getMemory().getMemory())));
            }
            if (dockerOptions.getMemory().getMemorySwap() != null) {
                hostConfig.withMemorySwap(DockerScriptRunner.convertBytes(runContext.render(dockerOptions.getMemory().getMemorySwap())));
            }
            if (dockerOptions.getMemory().getMemorySwappiness() != null) {
                hostConfig.withMemorySwappiness(DockerScriptRunner.convertBytes(runContext.render(dockerOptions.getMemory().getMemorySwappiness())));
            }
            if (dockerOptions.getMemory().getMemoryReservation() != null) {
                hostConfig.withMemoryReservation(DockerScriptRunner.convertBytes(runContext.render(dockerOptions.getMemory().getMemoryReservation())));
            }
            if (dockerOptions.getMemory().getKernelMemory() != null) {
                hostConfig.withKernelMemory(DockerScriptRunner.convertBytes(runContext.render(dockerOptions.getMemory().getKernelMemory())));
            }
            if (dockerOptions.getMemory().getOomKillDisable() != null) {
                hostConfig.withOomKillDisable(dockerOptions.getMemory().getOomKillDisable());
            }
        }
        if (dockerOptions.getNetworkMode() != null) {
            hostConfig.withNetworkMode(runContext.render(dockerOptions.getNetworkMode(), additionalVars));
        }
        return container.withHostConfig(hostConfig).withCmd(commands.getCommands()).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true));
    }

    private static void addMetadata(RunContext runContext, CreateContainerCmd container) {
        Map flow = (Map)runContext.getVariables().get("flow");
        Map task = (Map)runContext.getVariables().get("task");
        Map execution = (Map)runContext.getVariables().get("execution");
        Map taskrun = (Map)runContext.getVariables().get("taskrun");
        container.withLabels((Map)ImmutableMap.of((Object)"flow.kestra.io/id", (Object)((String)flow.get("id")), (Object)"flow.kestra.io/namespace", (Object)((String)flow.get("namespace")), (Object)"task.kestra.io/id", (Object)((String)task.get("id")), (Object)"execution.kestra.io/id", (Object)((String)execution.get("id")), (Object)"taskrun.kestra.io/id", (Object)((String)taskrun.get("id"))));
    }

    private static Long convertBytes(String bytes) {
        return ((Number)READABLE_BYTES_TYPE_CONVERTER.convert((Object)bytes, Number.class).orElseThrow(() -> new IllegalArgumentException("Invalid size with value '" + bytes + "'"))).longValue();
    }

    private void pullImage(DockerClient dockerClient, String image, DockerOptions.PullPolicy policy, Logger logger) {
        NameParser.ReposTag imageParse = NameParser.parseRepositoryTag((String)image);
        if (policy.equals((Object)DockerOptions.PullPolicy.IF_NOT_PRESENT)) {
            try {
                dockerClient.inspectImageCmd(image).exec();
                return;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        try (PullImageCmd pull = dockerClient.pullImageCmd(image);){
            this.retryUtils.of((AbstractRetry)((Exponential.ExponentialBuilder)Exponential.builder().delayFactor(Double.valueOf(2.0)).interval(Duration.ofSeconds(5L)).maxInterval(Duration.ofSeconds(120L)).maxAttempt(Integer.valueOf(5))).build()).run((bool, throwable) -> throwable instanceof InternalServerErrorException || throwable.getCause() instanceof ConnectionClosedException, () -> {
                String tag = !imageParse.tag.isEmpty() ? imageParse.tag : "latest";
                String repository = pull.getRepository().contains(":") ? pull.getRepository().split(":")[0] : pull.getRepository();
                ((PullImageResultCallback)pull.withTag(tag).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
                logger.debug("Image pulled [{}:{}]", (Object)repository, (Object)tag);
                return true;
            });
        }
    }
}

