/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins.processor;

import com.google.common.base.Throwables;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.plugins.processor.ServicesFiles;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.NoArgsConstructor;

@SupportedOptions(value={"debug", "verify"})
public class PluginProcessor
extends AbstractProcessor {
    public static final String PLUGIN_RESOURCE_FILE = ServicesFiles.getPath(io.kestra.core.models.Plugin.class.getCanonicalName());
    private final List<String> exceptionStacks = Collections.synchronizedList(new ArrayList());
    private final Set<String> plugins = new HashSet<String>();
    private Elements elementUtils;

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(Plugin.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processImpl(annotations, roundEnv);
        }
        catch (RuntimeException e) {
            String trace = Throwables.getStackTraceAsString((Throwable)e);
            this.exceptionStacks.add(trace);
            this.fatalError(trace);
        }
        return false;
    }

    private void processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generatePluginConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Plugin.class);
        this.log(annotations.toString());
        this.log(elements.toString());
        TypeElement pluginInterface = this.elementUtils.getTypeElement(io.kestra.core.models.Plugin.class.getCanonicalName());
        for (Element element : elements) {
            TypeElement pluginType = PluginProcessor.asTypeElement(element);
            Types types = this.processingEnv.getTypeUtils();
            if (!types.isSubtype(pluginType.asType(), pluginInterface.asType()) || !PluginProcessor.isNotAbstract(pluginType) || !this.hasNoArgConstructor(pluginType)) continue;
            this.log("plugin provider: " + String.valueOf(pluginType.getQualifiedName()));
            this.plugins.add(this.getBinaryName(pluginType));
        }
    }

    private void generatePluginConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        this.log("Working on resource file: " + PLUGIN_RESOURCE_FILE);
        try {
            TreeSet<String> allServices = new TreeSet<String>();
            try {
                FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", PLUGIN_RESOURCE_FILE);
                this.log("Looking for existing resource file at " + String.valueOf(existingFile.toUri()));
                Set<String> oldServices = ServicesFiles.readServiceFile(existingFile.openInputStream());
                this.log("Existing service entries: " + String.valueOf(oldServices));
                allServices.addAll(oldServices);
            }
            catch (IOException e) {
                this.log("Resource file did not already exist.");
            }
            if (!allServices.addAll(this.plugins)) {
                this.log("No new service entries being added.");
                return;
            }
            this.log("New service file contents: " + String.valueOf(allServices));
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", PLUGIN_RESOURCE_FILE, new Element[0]);
            try (OutputStream out = fileObject.openOutputStream();){
                ServicesFiles.writeServiceFile(allServices, out);
            }
            this.log("Wrote to: " + String.valueOf(fileObject.toUri()));
        }
        catch (IOException e) {
            this.fatalError("Unable to create " + PLUGIN_RESOURCE_FILE + ", " + String.valueOf(e));
        }
    }

    private String getBinaryName(TypeElement element) {
        return this.getBinaryNameImpl(element, element.getSimpleName().toString());
    }

    private String getBinaryNameImpl(TypeElement element, String className) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement pkg = (PackageElement)enclosingElement;
            if (pkg.isUnnamed()) {
                return className;
            }
            return String.valueOf(pkg.getQualifiedName()) + "." + className;
        }
        TypeElement typeElement = PluginProcessor.asTypeElement(enclosingElement);
        return this.getBinaryNameImpl(typeElement, String.valueOf(typeElement.getSimpleName()) + "$" + className);
    }

    private static boolean isNotAbstract(TypeElement pluginType) {
        return !pluginType.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private boolean hasNoArgConstructor(TypeElement typeElement) {
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement constructorElement;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !(constructorElement = (ExecutableElement)element).getParameters().isEmpty()) continue;
            return true;
        }
        return this.hasAnnotation(typeElement, NoArgsConstructor.class);
    }

    private boolean hasAnnotation(TypeElement typeElement, Class<? extends Annotation> annotationClass) {
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationClass.getName())) continue;
            return true;
        }
        return false;
    }

    private static TypeElement asTypeElement(Element enclosingElement) {
        return enclosingElement.accept(new SimpleElementVisitor8<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void o) {
                return e;
            }
        }, null);
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void warning(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, element, annotation);
    }

    private void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }
}

