/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.statistics.DailyExecutionStatistics;
import io.kestra.core.models.executions.statistics.ExecutionCount;
import io.kestra.core.models.executions.statistics.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.core.value.ValueException;
import io.micronaut.data.model.Pageable;
import io.reactivex.Flowable;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Singleton
@MemoryRepositoryEnabled
public class MemoryExecutionRepository
implements ExecutionRepositoryInterface {
    private final Map<String, Execution> executions = new HashMap<String, Execution>();

    public Boolean isTaskRunEnabled() {
        return false;
    }

    public ArrayListTotal<Execution> find(Pageable pageable, String query, String namespace, String flowId, ZonedDateTime startDate, ZonedDateTime endDate, List<State.Type> state, @Nullable Map<String, String> labels) {
        throw new UnsupportedOperationException();
    }

    public Flowable<Execution> find(@Nullable String query, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<State.Type> state, @Nullable Map<String, String> labels) {
        return null;
    }

    public ArrayListTotal<TaskRun> findTaskRun(Pageable pageable, @Nullable String query, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<State.Type> states) {
        throw new UnsupportedOperationException();
    }

    public Execution delete(Execution execution) {
        throw new UnsupportedOperationException();
    }

    public Integer purge(Execution execution) {
        throw new UnsupportedOperationException();
    }

    public Optional<Execution> findById(String executionId) {
        return this.executions.containsKey(executionId) ? Optional.of(this.executions.get(executionId)) : Optional.empty();
    }

    public ArrayListTotal<Execution> findByFlowId(String namespace, String flowId, Pageable pageable) {
        if (pageable.getNumber() < 1) {
            throw new ValueException("Page cannot be < 1");
        }
        List filteredExecutions = this.executions.values().stream().filter(e -> Objects.nonNull(namespace)).filter(e -> e.getNamespace().equals(namespace)).filter(e -> Objects.nonNull(e.getFlowId())).filter(e -> e.getFlowId().equals(flowId)).collect(Collectors.toList());
        return ArrayListTotal.of((Pageable)pageable, filteredExecutions);
    }

    public Execution save(Execution execution) {
        return this.executions.put(execution.getId(), execution);
    }

    public Map<String, Map<String, List<DailyExecutionStatistics>>> dailyGroupByFlowStatistics(@Nullable String query, @Nullable String namespace, @Nullable String flowId, @Nullable List<ExecutionRepositoryInterface.FlowFilter> flows, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, boolean groupByNamespaceOnly) {
        throw new UnsupportedOperationException();
    }

    public List<ExecutionCount> executionCounts(List<Flow> flows, @Nullable List<State.Type> states, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        throw new UnsupportedOperationException();
    }

    public List<DailyExecutionStatistics> dailyStatistics(@Nullable String query, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy, boolean isTaskRun) {
        return Collections.emptyList();
    }

    public Integer maxTaskRunSetting() {
        throw new UnsupportedOperationException();
    }
}

