/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.MetricEntry;
import io.kestra.core.models.executions.metrics.MetricAggregations;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.MetricRepositoryInterface;
import io.kestra.repository.memory.MemoryRepositoryEnabled;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.Nullable;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
@MemoryRepositoryEnabled
public class MemoryMetricRepository
implements MetricRepositoryInterface {
    private final List<MetricEntry> metrics = new ArrayList<MetricEntry>();

    public ArrayListTotal<MetricEntry> findByExecutionId(String tenantId, String id, Pageable pageable) {
        List results = this.metrics.stream().filter(metric -> metric.getExecutionId().equals(id)).filter(metric -> tenantId == null && metric.getTenantId() == null || tenantId != null && tenantId.equals(metric.getTenantId())).collect(Collectors.toList());
        return new ArrayListTotal(results, (long)results.size());
    }

    public ArrayListTotal<MetricEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public ArrayListTotal<MetricEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public List<String> flowMetrics(String tenantId, String namespace, String flowId) {
        throw new UnsupportedOperationException();
    }

    public List<String> taskMetrics(String tenantId, String namespace, String flowId, String taskId) {
        throw new UnsupportedOperationException();
    }

    public List<String> tasksWithMetrics(String tenantId, String namespace, String flowId) {
        throw new UnsupportedOperationException();
    }

    public MetricAggregations aggregateByFlowId(String tenantId, String namespace, String flowId, @Nullable String taskId, String metric, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, String aggregation) {
        throw new UnsupportedOperationException();
    }

    public Integer purge(Execution execution) {
        throw new UnsupportedOperationException();
    }

    public MetricEntry save(MetricEntry metricEntry) {
        this.metrics.add(metricEntry);
        return metricEntry;
    }
}

