/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilled;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.MetricEntry;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.templates.Template;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.queues.QueueFactoryInterface;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.queues.WorkerJobQueueInterface;
import io.kestra.core.runners.Executor;
import io.kestra.core.runners.WorkerInstance;
import io.kestra.core.runners.WorkerJob;
import io.kestra.core.runners.WorkerJobRunning;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkerTriggerResult;
import io.kestra.runner.memory.MemoryQueue;
import io.kestra.runner.memory.MemoryQueueEnabled;
import io.kestra.runner.memory.MemoryWorkerJobQueue;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.commons.lang3.NotImplementedException;

@Factory
@MemoryQueueEnabled
public class MemoryQueueFactory
implements QueueFactoryInterface {
    @Inject
    ApplicationContext applicationContext;

    @Singleton
    @Named(value="executionQueue")
    public QueueInterface<Execution> execution() {
        return new MemoryQueue<Execution>(Execution.class, this.applicationContext);
    }

    @Singleton
    @Named(value="executorQueue")
    public QueueInterface<Executor> executor() {
        throw new NotImplementedException();
    }

    @Singleton
    @Named(value="workerJobQueue")
    public QueueInterface<WorkerJob> workerJob() {
        return new MemoryQueue<WorkerJob>(WorkerJob.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerTaskResultQueue")
    public QueueInterface<WorkerTaskResult> workerTaskResult() {
        return new MemoryQueue<WorkerTaskResult>(WorkerTaskResult.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerTriggerResultQueue")
    public QueueInterface<WorkerTriggerResult> workerTriggerResult() {
        return new MemoryQueue<WorkerTriggerResult>(WorkerTriggerResult.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerTaskLogQueue")
    public QueueInterface<LogEntry> logEntry() {
        return new MemoryQueue<LogEntry>(LogEntry.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerTaskMetricQueue")
    public QueueInterface<MetricEntry> metricEntry() {
        return new MemoryQueue<MetricEntry>(MetricEntry.class, this.applicationContext);
    }

    @Singleton
    @Named(value="flowQueue")
    public QueueInterface<Flow> flow() {
        return new MemoryQueue<Flow>(Flow.class, this.applicationContext);
    }

    @Singleton
    @Named(value="executionKilledQueue")
    public QueueInterface<ExecutionKilled> kill() {
        return new MemoryQueue<ExecutionKilled>(ExecutionKilled.class, this.applicationContext);
    }

    @Singleton
    @Named(value="templateQueue")
    public QueueInterface<Template> template() {
        return new MemoryQueue<Template>(Template.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerInstanceQueue")
    public QueueInterface<WorkerInstance> workerInstance() {
        return new MemoryQueue<WorkerInstance>(WorkerInstance.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerJobRunningQueue")
    public QueueInterface<WorkerJobRunning> workerJobRunning() {
        return new MemoryQueue<WorkerJobRunning>(WorkerJobRunning.class, this.applicationContext);
    }

    @Singleton
    @Named(value="triggerQueue")
    public QueueInterface<Trigger> trigger() {
        return new MemoryQueue<Trigger>(Trigger.class, this.applicationContext);
    }

    @Prototype
    public WorkerJobQueueInterface workerJobQueue() {
        return new MemoryWorkerJobQueue(this.applicationContext);
    }
}

