/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilled;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.MetricEntry;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.templates.Template;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.queues.QueueFactoryInterface;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.queues.QueueService;
import io.kestra.core.queues.WorkerJobQueueInterface;
import io.kestra.core.queues.WorkerTriggerResultQueueInterface;
import io.kestra.core.runners.Executor;
import io.kestra.core.runners.SubflowExecutionResult;
import io.kestra.core.runners.WorkerInstance;
import io.kestra.core.runners.WorkerJob;
import io.kestra.core.runners.WorkerJobRunning;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkerTriggerResult;
import io.kestra.core.utils.ExecutorsUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.runner.memory.MemoryQueue;
import io.kestra.runner.memory.MemoryQueueEnabled;
import io.kestra.runner.memory.MemoryWorkerJobQueue;
import io.kestra.runner.memory.MemoryWorkerTriggerResultQueue;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;

@Factory
@MemoryQueueEnabled
public class MemoryQueueFactory
implements QueueFactoryInterface {
    private static final String QUEUE_NAME = "memory-queue";
    @Inject
    ApplicationContext applicationContext;
    @Inject
    ExecutorsUtils executorsUtils;
    @Inject
    QueueService queueService;

    @Singleton
    @Named(value="executionQueue")
    public QueueInterface<Execution> execution() {
        return this.createQueueForType(Execution.class);
    }

    @Singleton
    @Named(value="executorQueue")
    public QueueInterface<Executor> executor() {
        throw new NotImplementedException();
    }

    @Singleton
    @Named(value="workerJobQueue")
    public QueueInterface<WorkerJob> workerJob() {
        return this.createQueueForType(WorkerJob.class);
    }

    @Singleton
    @Named(value="workerTaskResultQueue")
    public QueueInterface<WorkerTaskResult> workerTaskResult() {
        return this.createQueueForType(WorkerTaskResult.class);
    }

    @Singleton
    @Named(value="workerTriggerResultQueue")
    public QueueInterface<WorkerTriggerResult> workerTriggerResult() {
        return this.createQueueForType(WorkerTriggerResult.class);
    }

    @Singleton
    @Named(value="workerTaskLogQueue")
    public QueueInterface<LogEntry> logEntry() {
        return this.createQueueForType(LogEntry.class);
    }

    @Singleton
    @Named(value="workerTaskMetricQueue")
    public QueueInterface<MetricEntry> metricEntry() {
        return this.createQueueForType(MetricEntry.class);
    }

    @Singleton
    @Named(value="flowQueue")
    public QueueInterface<Flow> flow() {
        return this.createQueueForType(Flow.class);
    }

    @Singleton
    @Named(value="executionKilledQueue")
    public QueueInterface<ExecutionKilled> kill() {
        return this.createQueueForType(ExecutionKilled.class);
    }

    @Singleton
    @Named(value="templateQueue")
    public QueueInterface<Template> template() {
        return this.createQueueForType(Template.class);
    }

    @Singleton
    @Named(value="workerInstanceQueue")
    public QueueInterface<WorkerInstance> workerInstance() {
        return this.createQueueForType(WorkerInstance.class);
    }

    @Singleton
    @Named(value="workerJobRunningQueue")
    public QueueInterface<WorkerJobRunning> workerJobRunning() {
        return this.createQueueForType(WorkerJobRunning.class);
    }

    @Singleton
    @Named(value="triggerQueue")
    public QueueInterface<Trigger> trigger() {
        return this.createQueueForType(Trigger.class);
    }

    @Prototype
    public WorkerJobQueueInterface workerJobQueue() {
        return new MemoryWorkerJobQueue(this.applicationContext);
    }

    @Singleton
    public WorkerTriggerResultQueueInterface workerTriggerResultQueue() {
        return new MemoryWorkerTriggerResultQueue(this.applicationContext);
    }

    @Singleton
    @Named(value="subflowExecutionResultQueue")
    public QueueInterface<SubflowExecutionResult> subflowExecutionResult() {
        return this.createQueueForType(SubflowExecutionResult.class);
    }

    @PreDestroy
    void closeAllQueue() throws IOException {
        this.applicationContext.getBeansOfType(MemoryQueue.class).forEach(Rethrow.throwConsumer(MemoryQueue::close));
    }

    private <T> MemoryQueue<T> createQueueForType(Class<T> type) {
        return new MemoryQueue<T>(type, this.queueService, this.executorsUtils.cachedThreadPool(QUEUE_NAME));
    }
}

