/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.memory;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.StandAloneRunner;
import io.kestra.core.runners.WorkerJob;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.utils.Await;
import io.kestra.runner.memory.MemoryQueue;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MemoryRunner
extends StandAloneRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryRunner.class);
    @Inject
    @Named(value="executionQueue")
    protected QueueInterface<Execution> executionQueue;
    @Inject
    @Named(value="workerJobQueue")
    protected QueueInterface<WorkerJob> workerTaskQueue;
    @Inject
    @Named(value="workerTaskResultQueue")
    protected QueueInterface<WorkerTaskResult> workerTaskResultQueue;

    public void run() {
        super.run();
        Await.until(() -> ((MemoryQueue)this.executionQueue).getSubscribersCount() == 3 && ((MemoryQueue)this.workerTaskQueue).getSubscribersCount() == 1 && ((MemoryQueue)this.workerTaskResultQueue).getSubscribersCount() == 1, null, (Duration)Duration.ofSeconds(5L));
    }
}

