/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.memory;

import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.schedulers.SchedulerTriggerStateInterface;
import io.kestra.runner.memory.MemoryQueueEnabled;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Singleton
@MemoryQueueEnabled
public class MemorySchedulerTriggerState
implements SchedulerTriggerStateInterface {
    private final Map<String, Trigger> triggers = new HashMap<String, Trigger>();
    @Inject
    @Named(value="triggerQueue")
    QueueInterface<Trigger> triggerQueue;

    public Optional<Trigger> findLast(TriggerContext context) {
        return this.triggers.containsKey(context.uid()) ? Optional.of(this.triggers.get(context.uid())) : Optional.empty();
    }

    public Trigger save(Trigger trigger) {
        this.triggers.put(trigger.uid(), trigger);
        this.triggerQueue.emit((Object)trigger);
        return trigger;
    }
}

