/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.memory;

import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class MemoryMultipleConditionStorage
implements MultipleConditionStorageInterface {
    private final Map<String, Map<String, Map<String, MultipleConditionWindow>>> map = new ConcurrentHashMap<String, Map<String, Map<String, MultipleConditionWindow>>>();

    private Optional<Map<String, MultipleConditionWindow>> find(String namepace, String flow) {
        if (!this.map.containsKey(namepace)) {
            return Optional.empty();
        }
        Map<String, Map<String, MultipleConditionWindow>> byFlows = this.map.get(namepace);
        if (!byFlows.containsKey(flow)) {
            return Optional.empty();
        }
        return Optional.of(byFlows.get(flow));
    }

    public Optional<MultipleConditionWindow> get(Flow flow, String conditionId) {
        return this.find(flow.getNamespace(), flow.getId()).flatMap(byCondition -> byCondition.containsKey(conditionId) ? Optional.of((MultipleConditionWindow)byCondition.get(conditionId)) : Optional.empty());
    }

    public List<MultipleConditionWindow> expired() {
        ZonedDateTime now = ZonedDateTime.now();
        return this.map.entrySet().stream().flatMap(e -> ((Map)e.getValue()).entrySet().stream()).flatMap(e -> ((Map)e.getValue()).entrySet().stream()).map(Map.Entry::getValue).filter(e -> !e.isValid(now)).collect(Collectors.toList());
    }

    public synchronized void save(List<MultipleConditionWindow> multipleConditionWindows) {
        multipleConditionWindows.forEach(window -> {
            if (!this.map.containsKey(window.getNamespace())) {
                this.map.put(window.getNamespace(), new HashMap());
            }
            Map<String, Map<String, MultipleConditionWindow>> byFlows = this.map.get(window.getNamespace());
            if (!this.map.containsKey(window.getFlowId())) {
                byFlows.put(window.getFlowId(), new HashMap());
            }
            Map<String, MultipleConditionWindow> byCondition = byFlows.get(window.getFlowId());
            byCondition.put(window.getConditionId(), (MultipleConditionWindow)window);
        });
    }

    public void delete(MultipleConditionWindow multipleConditionWindow) {
        this.find(multipleConditionWindow.getNamespace(), multipleConditionWindow.getFlowId()).ifPresent(byCondition -> byCondition.remove(multipleConditionWindow.getConditionId()));
    }
}

