/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.exceptions.DeserializationException;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.exceptions.InvalidTriggerConfigurationException;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilled;
import io.kestra.core.models.executions.ExecutionKilledTrigger;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.WorkerGroup;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.RealtimeTriggerInterface;
import io.kestra.core.models.triggers.RecoverMissedSchedules;
import io.kestra.core.models.triggers.Schedulable;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.WorkerTriggerInterface;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.RunContextInitializer;
import io.kestra.core.runners.ScheduleContextInterface;
import io.kestra.core.runners.Scheduler;
import io.kestra.core.runners.SchedulerTriggerStateInterface;
import io.kestra.core.runners.WorkerGroupExecutorInterface;
import io.kestra.core.runners.WorkerJob;
import io.kestra.core.runners.WorkerTrigger;
import io.kestra.core.runners.WorkerTriggerResult;
import io.kestra.core.server.ClusterEvent;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceStateChangeEvent;
import io.kestra.core.server.ServiceType;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.FlowListenersInterface;
import io.kestra.core.services.FlowService;
import io.kestra.core.services.LabelService;
import io.kestra.core.services.LogService;
import io.kestra.core.services.MaintenanceService;
import io.kestra.core.services.PluginDefaultService;
import io.kestra.core.services.WorkerGroupService;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.Either;
import io.kestra.core.utils.ExecutorsUtils;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.scheduler.SchedulerExecutionStateInterface;
import io.kestra.scheduler.SchedulerExecutionWithTrigger;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Singleton
public abstract class AbstractScheduler
implements Scheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduler.class);
    protected final ApplicationContext applicationContext;
    protected final QueueInterface<Execution> executionQueue;
    protected final QueueInterface<Trigger> triggerQueue;
    private final QueueInterface<WorkerJob> workerJobQueue;
    private final QueueInterface<WorkerTriggerResult> workerTriggerResultQueue;
    private final QueueInterface<ExecutionKilled> executionKilledQueue;
    private final QueueInterface<LogEntry> logQueue;
    private final Optional<QueueInterface> clusterEventQueue;
    protected final FlowListenersInterface flowListeners;
    private final RunContextFactory runContextFactory;
    private final RunContextInitializer runContextInitializer;
    private final MetricRegistry metricRegistry;
    private final ConditionService conditionService;
    private final PluginDefaultService pluginDefaultService;
    private final WorkerGroupService workerGroupService;
    private final LogService logService;
    protected SchedulerExecutionStateInterface executionState;
    private final WorkerGroupExecutorInterface workerGroupExecutorInterface;
    private final MaintenanceService maintenanceService;
    private volatile Boolean isReady = false;
    private final ScheduledExecutorService scheduleExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> scheduledFuture;
    private final ScheduledExecutorService executionMonitorExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> executionMonitorFuture;
    protected SchedulerTriggerStateInterface triggerState;
    private volatile List<FlowWithTriggers> schedulable = new ArrayList<FlowWithTriggers>();
    private volatile Map<String, FlowWithWorkerTriggerNextDate> schedulableNextDate = new ConcurrentHashMap<String, FlowWithWorkerTriggerNextDate>();
    private final String id = IdUtils.create();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicBoolean isPaused = new AtomicBoolean(false);
    private final AtomicReference<Service.ServiceState> state = new AtomicReference();
    private final ApplicationEventPublisher<ServiceStateChangeEvent> serviceStateEventPublisher;
    protected final ApplicationEventPublisher<CrudEvent<Execution>> executionEventPublisher;
    protected final List<Runnable> receiveCancellations = new ArrayList<Runnable>();

    @Inject
    public AbstractScheduler(ApplicationContext applicationContext, FlowListenersInterface flowListeners) {
        this.applicationContext = applicationContext;
        this.executionQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionQueue"));
        this.triggerQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"triggerQueue"));
        this.workerJobQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"workerJobQueue"));
        this.executionKilledQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionKilledQueue"));
        this.workerTriggerResultQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"workerTriggerResultQueue"));
        this.clusterEventQueue = applicationContext.findBean(QueueInterface.class, Qualifiers.byName((String)"clusterEventQueue"));
        this.logQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"workerTaskLogQueue"));
        this.flowListeners = flowListeners;
        this.runContextFactory = (RunContextFactory)applicationContext.getBean(RunContextFactory.class);
        this.runContextInitializer = (RunContextInitializer)applicationContext.getBean(RunContextInitializer.class);
        this.metricRegistry = (MetricRegistry)applicationContext.getBean(MetricRegistry.class);
        this.conditionService = (ConditionService)applicationContext.getBean(ConditionService.class);
        this.pluginDefaultService = (PluginDefaultService)applicationContext.getBean(PluginDefaultService.class);
        this.workerGroupService = (WorkerGroupService)applicationContext.getBean(WorkerGroupService.class);
        this.logService = (LogService)applicationContext.getBean(LogService.class);
        this.serviceStateEventPublisher = (ApplicationEventPublisher)applicationContext.getBean(ApplicationEventPublisher.class);
        this.executionEventPublisher = (ApplicationEventPublisher)applicationContext.getBean(ApplicationEventPublisher.class);
        this.workerGroupExecutorInterface = (WorkerGroupExecutorInterface)applicationContext.getBean(WorkerGroupExecutorInterface.class);
        this.maintenanceService = (MaintenanceService)applicationContext.getBean(MaintenanceService.class);
        this.setState(Service.ServiceState.CREATED);
    }

    @VisibleForTesting
    public boolean isReady() {
        return this.isReady;
    }

    public void run() {
        this.flowListeners.run();
        this.flowListeners.listen(this::initializedTriggers);
        this.scheduledFuture = this.scheduleExecutor.scheduleAtFixedRate(this::handle, 0L, 1L, TimeUnit.SECONDS);
        Thread.ofVirtual().name("scheduler-evaluation-loop-watch").start(() -> {
            Await.until(this.scheduledFuture::isDone);
            try {
                this.scheduledFuture.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Scheduler fatal exception", (Throwable)e);
                this.close();
                this.applicationContext.close();
            }
        });
        this.executionMonitorFuture = this.executionMonitorExecutor.scheduleWithFixedDelay(this::executionMonitor, 30L, 10L, TimeUnit.SECONDS);
        Thread.ofVirtual().name("scheduler-monitoring-loop-watch").start(() -> {
            Await.until(this.executionMonitorFuture::isDone);
            try {
                this.executionMonitorFuture.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Scheduler fatal exception", (Throwable)e);
                this.close();
                this.applicationContext.close();
            }
        });
        this.flowListeners.listen((flow, previous) -> {
            if (flow.isDeleted() || previous != null) {
                List triggersDeleted = flow.isDeleted() ? ListUtils.emptyOnNull((List)flow.getTriggers()) : FlowService.findRemovedTrigger((Flow)flow, (Flow)previous);
                triggersDeleted.forEach(abstractTrigger -> {
                    Trigger trigger = Trigger.of((FlowInterface)flow, (AbstractTrigger)abstractTrigger);
                    try {
                        this.triggerQueue.delete((Object)trigger);
                        this.executionKilledQueue.emit((Object)((ExecutionKilledTrigger.ExecutionKilledTriggerBuilder)ExecutionKilledTrigger.builder().tenantId(trigger.getTenantId())).namespace(trigger.getNamespace()).flowId(trigger.getFlowId()).triggerId(trigger.getTriggerId()).build());
                    }
                    catch (QueueException e) {
                        log.error("Unable to kill the trigger {}.{}.{}", new Object[]{trigger.getNamespace(), trigger.getFlowId(), trigger.getTriggerId(), e});
                    }
                });
            }
            if (previous != null) {
                FlowService.findUpdatedTrigger((Flow)flow, (Flow)previous).forEach(abstractTrigger -> {
                    if (abstractTrigger instanceof WorkerTriggerInterface) {
                        RunContext runContext = this.runContextFactory.of((Flow)flow, abstractTrigger);
                        ConditionContext conditionContext = this.conditionService.conditionContext(runContext, (Flow)flow, null);
                        try {
                            this.triggerState.update((Flow)flow, abstractTrigger, conditionContext);
                        }
                        catch (Exception e) {
                            this.logError(conditionContext, (FlowWithSource)flow, (AbstractTrigger)abstractTrigger, e);
                        }
                        Trigger trigger = Trigger.of((FlowInterface)flow, (AbstractTrigger)abstractTrigger);
                        try {
                            this.executionKilledQueue.emit((Object)((ExecutionKilledTrigger.ExecutionKilledTriggerBuilder)ExecutionKilledTrigger.builder().tenantId(trigger.getTenantId())).namespace(trigger.getNamespace()).flowId(trigger.getFlowId()).triggerId(trigger.getTriggerId()).build());
                        }
                        catch (QueueException e) {
                            log.error("Unable to kill the trigger {}.{}.{}", new Object[]{trigger.getNamespace(), trigger.getFlowId(), trigger.getTriggerId(), e});
                        }
                    }
                });
            }
        });
        this.receiveCancellations.add(this.workerTriggerResultQueue.receive(null, Scheduler.class, either -> {
            if (either.isRight()) {
                log.error("Unable to deserialize a worker trigger result: {}", (Object)((DeserializationException)either.getRight()).getMessage());
                return;
            }
            WorkerTriggerResult workerTriggerResult = (WorkerTriggerResult)either.getLeft();
            if (workerTriggerResult.getTrigger() instanceof RealtimeTriggerInterface && workerTriggerResult.getExecution().isPresent()) {
                this.emitExecution((Execution)workerTriggerResult.getExecution().get(), workerTriggerResult.getTriggerContext());
            } else if (workerTriggerResult.getExecution().isPresent()) {
                ZonedDateTime nextExecutionDate;
                SchedulerExecutionWithTrigger triggerExecution = new SchedulerExecutionWithTrigger((Execution)workerTriggerResult.getExecution().get(), workerTriggerResult.getTriggerContext());
                try {
                    nextExecutionDate = this.nextEvaluationDate(workerTriggerResult.getTrigger());
                }
                catch (InvalidTriggerConfigurationException e) {
                    this.disableInvalidTrigger(workerTriggerResult.getTriggerContext(), (Throwable)e);
                    return;
                }
                this.handleEvaluateWorkerTriggerResult(triggerExecution, nextExecutionDate);
            } else {
                ZonedDateTime nextExecutionDate;
                try {
                    nextExecutionDate = this.nextEvaluationDate(workerTriggerResult.getTrigger());
                }
                catch (InvalidTriggerConfigurationException e) {
                    this.disableInvalidTrigger(workerTriggerResult.getTriggerContext(), (Throwable)e);
                    return;
                }
                this.triggerState.update(Trigger.of((TriggerContext)workerTriggerResult.getTriggerContext(), (ZonedDateTime)nextExecutionDate));
            }
        }));
        this.clusterEventQueue.ifPresent(clusterEventQueueInterface -> this.receiveCancellations.addFirst(clusterEventQueueInterface.receive(this::clusterEventQueue)));
        if (this.maintenanceService.isInMaintenanceMode()) {
            this.enterMaintenance();
        } else {
            this.setState(Service.ServiceState.RUNNING);
        }
        log.info("Scheduler started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializedTriggers(List<FlowWithSource> flows) {
        AbstractScheduler abstractScheduler = this;
        synchronized (abstractScheduler) {
            Map triggers = this.triggerState.findAllForAllTenants().stream().collect(Collectors.toMap(HasUID::uid, Function.identity()));
            flows.stream().map(flow -> this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, log)).filter(Objects::nonNull).filter(flow -> flow.getTriggers() != null && !flow.getTriggers().isEmpty()).flatMap(flow -> flow.getTriggers().stream().filter(trigger -> trigger instanceof WorkerTriggerInterface).map(trigger -> {
                record FlowAndTrigger(FlowWithSource flow, AbstractTrigger trigger) {
                    @Override
                    public boolean equals(Object o) {
                        if (o == null || this.getClass() != o.getClass()) {
                            return false;
                        }
                        FlowAndTrigger that = (FlowAndTrigger)o;
                        return Objects.equals(Trigger.uid((Flow)this.flow(), (AbstractTrigger)this.trigger()), Trigger.uid((Flow)that.flow(), (AbstractTrigger)that.trigger()));
                    }

                    @Override
                    public int hashCode() {
                        return Objects.hashCode(Trigger.uid((Flow)this.flow(), (AbstractTrigger)this.trigger()));
                    }
                }
                return new FlowAndTrigger((FlowWithSource)flow, (AbstractTrigger)trigger);
            })).distinct().forEach(flowAndTrigger -> {
                String triggerUid = Trigger.uid((Flow)flowAndTrigger.flow(), (AbstractTrigger)flowAndTrigger.trigger());
                Optional<Trigger> trigger = Optional.ofNullable((Trigger)triggers.get(triggerUid));
                if (trigger.isEmpty()) {
                    RunContext runContext = this.runContextFactory.of((Flow)flowAndTrigger.flow(), flowAndTrigger.trigger());
                    ConditionContext conditionContext = this.conditionService.conditionContext(runContext, (Flow)flowAndTrigger.flow(), null);
                    try {
                        ZonedDateTime zonedDateTime;
                        AbstractTrigger patt0$temp = flowAndTrigger.trigger();
                        if (patt0$temp instanceof Schedulable) {
                            Schedulable schedule = (Schedulable)patt0$temp;
                            zonedDateTime = schedule.nextEvaluationDate(conditionContext, Optional.empty());
                        } else {
                            zonedDateTime = AbstractScheduler.now();
                        }
                        ZonedDateTime nextExecutionDate = zonedDateTime;
                        Trigger newTrigger = ((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().tenantId(flowAndTrigger.flow().getTenantId())).namespace(flowAndTrigger.flow().getNamespace())).flowId(flowAndTrigger.flow().getId())).triggerId(flowAndTrigger.trigger().getId())).date(AbstractScheduler.now())).nextExecutionDate(nextExecutionDate)).stopAfter(flowAndTrigger.trigger().getStopAfter())).build();
                        Object flowWithWorkerTrigger = ((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)FlowWithWorkerTrigger.builder().flow(flowAndTrigger.flow())).abstractTrigger(flowAndTrigger.trigger())).conditionContext(conditionContext)).triggerContext(newTrigger)).build();
                        this.schedulableNextDate.put(newTrigger.uid(), FlowWithWorkerTriggerNextDate.of(flowWithWorkerTrigger));
                        this.triggerState.create(newTrigger);
                    }
                    catch (Exception e) {
                        this.logError(conditionContext, flowAndTrigger.flow(), flowAndTrigger.trigger(), e);
                    }
                } else {
                    AbstractTrigger patt0$temp = flowAndTrigger.trigger();
                    if (patt0$temp instanceof Schedulable) {
                        Schedulable schedule = (Schedulable)patt0$temp;
                        RunContext runContext = this.runContextFactory.of((Flow)flowAndTrigger.flow(), flowAndTrigger.trigger());
                        ConditionContext conditionContext = this.conditionService.conditionContext(runContext, (Flow)flowAndTrigger.flow(), null);
                        RecoverMissedSchedules recoverMissedSchedules = Optional.ofNullable(schedule.getRecoverMissedSchedules()).orElseGet(() -> schedule.defaultRecoverMissedSchedules(runContext));
                        try {
                            Trigger lastUpdate = trigger.get();
                            if (recoverMissedSchedules == RecoverMissedSchedules.LAST) {
                                ZonedDateTime previousDate = schedule.previousEvaluationDate(conditionContext);
                                if (previousDate.isAfter(trigger.get().getDate())) {
                                    lastUpdate = ((Trigger.TriggerBuilder)trigger.get().toBuilder().nextExecutionDate(previousDate)).build();
                                    this.triggerState.update(lastUpdate);
                                }
                            } else {
                                ZonedDateTime nextEvaluationDate = schedule.nextEvaluationDate();
                                if (recoverMissedSchedules == RecoverMissedSchedules.NONE && !Objects.equals(trigger.get().getNextExecutionDate(), nextEvaluationDate)) {
                                    lastUpdate = ((Trigger.TriggerBuilder)trigger.get().toBuilder().nextExecutionDate(nextEvaluationDate)).build();
                                    this.triggerState.update(lastUpdate);
                                }
                            }
                            Object flowWithWorkerTrigger = ((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)FlowWithWorkerTrigger.builder().flow(flowAndTrigger.flow())).abstractTrigger(flowAndTrigger.trigger())).conditionContext(conditionContext)).triggerContext(lastUpdate)).build();
                            this.schedulableNextDate.put(lastUpdate.uid(), FlowWithWorkerTriggerNextDate.of(flowWithWorkerTrigger));
                        }
                        catch (Exception e) {
                            this.logError(conditionContext, flowAndTrigger.flow(), flowAndTrigger.trigger(), e);
                        }
                    }
                }
            });
        }
        this.isReady = true;
    }

    private void clusterEventQueue(Either<ClusterEvent, DeserializationException> either) {
        if (either.isRight()) {
            log.error("Unable to deserialize a cluster event: {}", (Object)((DeserializationException)either.getRight()).getMessage());
            return;
        }
        ClusterEvent clusterEvent = (ClusterEvent)either.getLeft();
        log.info("Cluster event received: {}", (Object)clusterEvent);
        switch (clusterEvent.eventType()) {
            case MAINTENANCE_ENTER: {
                this.enterMaintenance();
                break;
            }
            case MAINTENANCE_EXIT: {
                this.exitMaintenance();
            }
        }
    }

    private void enterMaintenance() {
        this.executionQueue.pause();
        this.triggerQueue.pause();
        this.workerJobQueue.pause();
        this.workerTriggerResultQueue.pause();
        this.executionKilledQueue.pause();
        this.pauseAdditionalQueues();
        this.isPaused.set(true);
        this.setState(Service.ServiceState.MAINTENANCE);
    }

    private void exitMaintenance() {
        this.executionQueue.resume();
        this.triggerQueue.resume();
        this.workerJobQueue.resume();
        this.workerTriggerResultQueue.resume();
        this.executionKilledQueue.resume();
        this.resumeAdditionalQueues();
        this.isPaused.set(false);
        this.setState(Service.ServiceState.RUNNING);
    }

    protected void resumeAdditionalQueues() {
    }

    protected void pauseAdditionalQueues() {
    }

    private ZonedDateTime nextEvaluationDate(AbstractTrigger abstractTrigger) throws InvalidTriggerConfigurationException {
        if (abstractTrigger instanceof PollingTriggerInterface) {
            PollingTriggerInterface interval = (PollingTriggerInterface)abstractTrigger;
            return interval.nextEvaluationDate();
        }
        return ZonedDateTime.now();
    }

    private ZonedDateTime nextEvaluationDate(AbstractTrigger abstractTrigger, ConditionContext conditionContext, Optional<? extends TriggerContext> last) throws Exception, InvalidTriggerConfigurationException {
        if (abstractTrigger instanceof PollingTriggerInterface) {
            PollingTriggerInterface interval = (PollingTriggerInterface)abstractTrigger;
            return interval.nextEvaluationDate(conditionContext, last);
        }
        return ZonedDateTime.now();
    }

    private Duration interval(AbstractTrigger abstractTrigger) {
        if (abstractTrigger instanceof PollingTriggerInterface) {
            PollingTriggerInterface interval = (PollingTriggerInterface)abstractTrigger;
            return interval.getInterval();
        }
        return Duration.ofSeconds(1L);
    }

    private List<FlowWithTriggers> computeSchedulable(List<FlowWithSource> flows, List<Trigger> triggerContextsToEvaluate, ScheduleContextInterface scheduleContext) {
        List<String> flowToKeep = triggerContextsToEvaluate.stream().map(TriggerContext::getFlowId).toList();
        List<String> flowIds = flows.stream().map(FlowId::uidWithoutRevision).toList();
        Map triggerById = triggerContextsToEvaluate.stream().collect(Collectors.toMap(HasUID::uid, Function.identity()));
        triggerContextsToEvaluate.stream().filter(trigger -> !flowIds.contains(FlowId.uid((Trigger)trigger))).forEach(trigger -> {
            try {
                this.triggerState.delete(trigger);
            }
            catch (QueueException e) {
                log.error("Unable to delete the trigger: {}.{}.{}", new Object[]{trigger.getNamespace(), trigger.getFlowId(), trigger.getTriggerId(), e});
            }
        });
        return flows.stream().filter(flow -> flowToKeep.contains(flow.getId())).filter(flow -> flow.getTriggers() != null && !flow.getTriggers().isEmpty()).filter(flow -> !flow.isDisabled() && !(flow instanceof FlowWithException)).map(flow -> this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, log)).filter(Objects::nonNull).flatMap(flow -> flow.getTriggers().stream().filter(abstractTrigger -> !abstractTrigger.isDisabled() && abstractTrigger instanceof WorkerTriggerInterface).map(abstractTrigger -> {
            Trigger triggerContext;
            RunContext runContext = this.runContextFactory.of((Flow)flow, abstractTrigger);
            ConditionContext conditionContext = this.conditionService.conditionContext(runContext, (Flow)flow, null);
            Trigger lastTrigger = (Trigger)triggerById.get(Trigger.uid((Flow)flow, (AbstractTrigger)abstractTrigger));
            if (lastTrigger == null) {
                return null;
            }
            if (lastTrigger.getNextExecutionDate() == null) {
                try {
                    triggerContext = ((Trigger.TriggerBuilder)lastTrigger.toBuilder().nextExecutionDate(this.nextEvaluationDate((AbstractTrigger)abstractTrigger, conditionContext, (Optional<? extends TriggerContext>)Optional.of(lastTrigger)))).build();
                }
                catch (InvalidTriggerConfigurationException e) {
                    this.logError(conditionContext, (FlowWithSource)flow, (AbstractTrigger)abstractTrigger, e);
                    this.disableInvalidTrigger((FlowWithSource)flow, (AbstractTrigger)abstractTrigger, e);
                    return null;
                }
                catch (Exception e) {
                    this.logError(conditionContext, (FlowWithSource)flow, (AbstractTrigger)abstractTrigger, e);
                    return null;
                }
                this.triggerState.save(triggerContext, scheduleContext, "/kestra/services/scheduler/compute-schedulable/save/lastTrigger-nextDate-null");
            } else {
                triggerContext = lastTrigger;
            }
            return new FlowWithTriggers((FlowWithSource)flow, (AbstractTrigger)abstractTrigger, triggerContext, conditionContext.withVariables((Map)ImmutableMap.of((Object)"trigger", (Object)ImmutableMap.of((Object)"date", (Object)(triggerContext.getNextExecutionDate() != null ? triggerContext.getNextExecutionDate() : AbstractScheduler.now())))));
        })).filter(Objects::nonNull).toList();
    }

    private void disableInvalidTrigger(TriggerContext triggerContext, Throwable e) {
        try {
            Trigger disabledTrigger = ((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().tenantId(triggerContext.getTenantId())).namespace(triggerContext.getNamespace())).flowId(triggerContext.getFlowId())).triggerId(triggerContext.getTriggerId())).date(triggerContext.getDate())).backfill(triggerContext.getBackfill())).stopAfter(triggerContext.getStopAfter())).disabled(Boolean.valueOf(true))).updatedDate(Instant.now()).build();
            this.triggerState.update(disabledTrigger);
            this.triggerQueue.emit((Object)disabledTrigger);
            log.warn("Disabled trigger {}.{} due to invalid configuration: {}", new Object[]{disabledTrigger.getFlowId(), disabledTrigger.getTriggerId(), e.getMessage()});
        }
        catch (Exception ex) {
            log.error("Failed to disable trigger {}.{}: {}", new Object[]{triggerContext.getFlowId(), triggerContext.getTriggerId(), ex.getMessage(), ex});
        }
    }

    private void disableInvalidTrigger(FlowWithSource flow, AbstractTrigger trigger, Throwable e) {
        Trigger disabledTrigger = ((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().tenantId(flow.getTenantId())).namespace(flow.getNamespace())).flowId(flow.getId())).triggerId(trigger.getId())).disabled(Boolean.valueOf(true))).updatedDate(Instant.now()).build();
        this.disableInvalidTrigger((TriggerContext)disabledTrigger, e);
    }

    private void disableInvalidTrigger(FlowWithWorkerTrigger f, Throwable e) {
        this.disableInvalidTrigger((TriggerContext)f.getTriggerContext(), e);
    }

    public abstract void handleNext(List<FlowWithSource> var1, ZonedDateTime var2, BiConsumer<List<Trigger>, ScheduleContextInterface> var3);

    public List<FlowWithTriggers> schedulerTriggers() {
        Map flows = this.getFlowsWithDefaults().stream().collect(Collectors.toMap(FlowInterface::uidWithoutRevision, Function.identity()));
        return this.triggerState.findAllForAllTenants().stream().filter(trigger -> flows.containsKey(trigger.flowUid())).map(trigger -> new FlowWithTriggers((FlowWithSource)flows.get(trigger.flowUid()), ListUtils.emptyOnNull((List)((FlowWithSource)flows.get(trigger.flowUid())).getTriggers()).stream().filter(t -> t.getId().equals(trigger.getTriggerId())).findFirst().orElse(null), (Trigger)trigger, null)).toList();
    }

    private void handle() {
        if (!this.isReady()) {
            log.warn("Scheduler is not ready, waiting");
            return;
        }
        if (this.isPaused.get()) {
            return;
        }
        ZonedDateTime now = AbstractScheduler.now();
        List flows = this.flowListeners.flows();
        this.handleNext(flows, now, (triggers, scheduleContext) -> {
            if (triggers.isEmpty()) {
                return;
            }
            List<Trigger> triggerContextsToEvaluate = triggers.stream().filter(trigger -> Boolean.FALSE.equals(trigger.getDisabled())).toList();
            List<FlowWithTriggers> schedulable = this.computeSchedulable(flows, triggerContextsToEvaluate, (ScheduleContextInterface)scheduleContext);
            this.metricRegistry.counter("scheduler.loop.count", "Total number of evaluation loops executed by the Scheduler", new String[0]).increment();
            if (log.isTraceEnabled()) {
                log.trace("Scheduler next iteration for {} with {} schedulables of {} flows", new Object[]{now, schedulable.size(), this.flowListeners.flows().size()});
            }
            List<FlowWithWorkerTriggerNextDate> readyForEvaluate = schedulable.stream().map(flowWithTriggers -> ((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)FlowWithWorkerTrigger.builder().flow(flowWithTriggers.getFlow())).abstractTrigger(flowWithTriggers.getAbstractTrigger())).conditionContext(flowWithTriggers.getConditionContext())).triggerContext(((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)flowWithTriggers.triggerContext.toBuilder().date(AbstractScheduler.now())).stopAfter(flowWithTriggers.getAbstractTrigger().getStopAfter())).build())).build()).filter(f -> f.getTriggerContext().getEvaluateRunningDate() == null).map(FlowWithWorkerTriggerNextDate::of).filter(Objects::nonNull).toList();
            if (log.isTraceEnabled()) {
                log.trace("Scheduler will evaluate for {} with {} readyForEvaluate of {} schedulables", new Object[]{now, readyForEvaluate.size(), schedulable.size()});
            }
            this.metricRegistry.counter("scheduler.evaluate.count", "Total number of triggers evaluated by the Scheduler", new String[0]).increment((double)readyForEvaluate.size());
            readyForEvaluate.forEach(f -> {
                block16: {
                    this.schedulableNextDate.put(f.getTriggerContext().uid(), (FlowWithWorkerTriggerNextDate)f);
                    Logger logger = f.getConditionContext().getRunContext().logger();
                    try {
                        List conditions = f.getAbstractTrigger().getConditions() != null ? f.getAbstractTrigger().getConditions() : Collections.emptyList();
                        boolean shouldEvaluate = this.conditionService.areValid(conditions, f.getConditionContext());
                        if (shouldEvaluate) {
                            if (this.interval(f.getAbstractTrigger()) != null) {
                                Trigger triggerRunning = Trigger.of((Trigger)f.getTriggerContext(), (ZonedDateTime)now);
                                Object flowWithTrigger = ((FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder)f.toBuilder().triggerContext(triggerRunning)).build();
                                try {
                                    this.triggerState.save(triggerRunning, scheduleContext, "/kestra/services/scheduler/handle/save/on-eval-true/polling");
                                    this.sendWorkerTriggerToWorker((FlowWithWorkerTrigger)flowWithTrigger);
                                }
                                catch (InternalException e) {
                                    this.logService.logTrigger((TriggerContext)f.getTriggerContext(), logger, Level.ERROR, "Unable to send worker trigger to worker", new Object[]{e});
                                }
                            } else {
                                AbstractTrigger patt0$temp = f.getAbstractTrigger();
                                if (patt0$temp instanceof Schedulable) {
                                    Schedulable schedule = (Schedulable)patt0$temp;
                                    Optional<SchedulerExecutionWithTrigger> schedulerExecutionWithTrigger = this.evaluateScheduleTrigger((FlowWithWorkerTrigger)f);
                                    if (schedulerExecutionWithTrigger.isPresent()) {
                                        this.handleEvaluateSchedulingTriggerResult(schedule, schedulerExecutionWithTrigger.get(), f.getConditionContext(), (ScheduleContextInterface)scheduleContext);
                                    } else {
                                        Trigger trigger = Trigger.fromEvaluateFailed((TriggerContext)f.getTriggerContext(), (ZonedDateTime)schedule.nextEvaluationDate(f.getConditionContext(), Optional.of(f.getTriggerContext())));
                                        trigger = trigger.checkBackfill();
                                        this.triggerState.save(trigger, scheduleContext, "/kestra/services/scheduler/handle/save/on-eval-true/schedule");
                                    }
                                } else {
                                    this.logService.logTrigger((TriggerContext)f.getTriggerContext(), logger, Level.ERROR, "Worker trigger must have an interval (except the Schedule and Streaming)", new Object[0]);
                                }
                            }
                            break block16;
                        }
                        ZonedDateTime nextExecutionDate = null;
                        try {
                            nextExecutionDate = this.nextEvaluationDate(f.getAbstractTrigger(), f.getConditionContext(), Optional.of(f.getTriggerContext()));
                        }
                        catch (InvalidTriggerConfigurationException e) {
                            this.logError((FlowWithWorkerTrigger)f, e);
                            this.disableInvalidTrigger((FlowWithWorkerTrigger)f, (Throwable)e);
                            return;
                        }
                        catch (Exception e) {
                            this.logError((FlowWithWorkerTrigger)f, e);
                        }
                        Trigger trigger = ((Trigger.TriggerBuilder)f.getTriggerContext().toBuilder().nextExecutionDate(nextExecutionDate)).build().checkBackfill();
                        this.triggerState.save(trigger, scheduleContext, "/kestra/services/scheduler/handle/save/on-eval-false");
                    }
                    catch (Exception ie) {
                        ZonedDateTime nextExecutionDate;
                        logger.error("Unable to evaluate the trigger '{}'", (Object)f.getAbstractTrigger().getId(), (Object)ie);
                        Execution execution = Execution.builder().id(IdUtils.create()).tenantId(f.getTriggerContext().getTenantId()).namespace(f.getTriggerContext().getNamespace()).flowId(f.getTriggerContext().getFlowId()).flowRevision(f.getFlow().getRevision()).labels(LabelService.labelsExcludingSystem((FlowInterface)f.getFlow())).state(new State().withState(State.Type.FAILED)).build();
                        try {
                            nextExecutionDate = this.nextEvaluationDate(f.getAbstractTrigger());
                        }
                        catch (InvalidTriggerConfigurationException e2) {
                            this.logError((FlowWithWorkerTrigger)f, e2);
                            this.disableInvalidTrigger((FlowWithWorkerTrigger)f, (Throwable)e2);
                            return;
                        }
                        Trigger trigger = f.getTriggerContext().resetExecution(State.Type.FAILED, nextExecutionDate);
                        this.saveLastTriggerAndEmitExecution(execution, trigger, triggerToSave -> this.triggerState.save(triggerToSave, scheduleContext, "/kestra/services/scheduler/handle/save/on-error"));
                    }
                }
            });
        });
        this.metricRegistry.timer("scheduler.evaluation.loop.duration", "Trigger evaluation loop duration inside the Scheduler", new String[0]).record(Duration.between(now, ZonedDateTime.now()));
    }

    private List<FlowWithSource> getFlowsWithDefaults() {
        return this.flowListeners.flows().stream().map(flow -> this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, log)).filter(Objects::nonNull).toList();
    }

    private void handleEvaluateWorkerTriggerResult(SchedulerExecutionWithTrigger result, ZonedDateTime nextExecutionDate) {
        Optional.ofNullable(result).ifPresent(executionWithTrigger -> {
            this.log((SchedulerExecutionWithTrigger)executionWithTrigger);
            Trigger trigger = Trigger.of((TriggerContext)executionWithTrigger.getTriggerContext(), (Execution)executionWithTrigger.getExecution(), (ZonedDateTime)nextExecutionDate);
            this.saveLastTriggerAndEmitExecution(executionWithTrigger.getExecution(), trigger, triggerToSave -> this.triggerState.update(triggerToSave));
        });
    }

    private void handleEvaluateSchedulingTriggerResult(Schedulable schedule, SchedulerExecutionWithTrigger result, ConditionContext conditionContext, ScheduleContextInterface scheduleContext) throws Exception {
        this.log(result);
        Trigger trigger = Trigger.of((TriggerContext)result.getTriggerContext(), (Execution)result.getExecution(), (ZonedDateTime)schedule.nextEvaluationDate(conditionContext, Optional.of(result.getTriggerContext())));
        trigger = trigger.checkBackfill();
        if (result.getExecution().getState().getCurrent() == State.Type.FAILED) {
            trigger = trigger.resetExecution(State.Type.FAILED);
        }
        this.saveLastTriggerAndEmitExecution(result.getExecution(), trigger, triggerToSave -> this.triggerState.save(triggerToSave, scheduleContext, "/kestra/services/scheduler/handleEvaluateSchedulingTriggerResult/save"));
    }

    protected void saveLastTriggerAndEmitExecution(Execution execution, Trigger trigger, Consumer<Trigger> saveAction) {
        saveAction.accept(trigger);
        this.emitExecution(execution, (TriggerContext)trigger);
    }

    private void emitExecution(Execution execution, TriggerContext trigger) {
        Execution newExecution = execution.withTenantId(trigger.getTenantId());
        try {
            this.executionQueue.emit((Object)newExecution);
            this.executionEventPublisher.publishEvent((Object)new CrudEvent((Object)newExecution, CrudEventType.CREATE));
        }
        catch (QueueException e) {
            try {
                Execution failedExecution = this.fail(newExecution, (Exception)((Object)e));
                this.executionQueue.emit((Object)failedExecution);
                this.executionEventPublisher.publishEvent((Object)new CrudEvent((Object)failedExecution, CrudEventType.CREATE));
            }
            catch (QueueException ex) {
                log.error("Unable to emit the execution", (Throwable)ex);
            }
        }
    }

    private Execution fail(Execution message, Exception e) {
        Execution.FailedExecutionWithLog failedExecution = message.failedExecutionFromExecutor(e);
        try {
            this.logQueue.emitAsync(failedExecution.getLogs());
        }
        catch (QueueException queueException) {
            // empty catch block
        }
        return failedExecution.getExecution().getState().isFailed() ? failedExecution.getExecution() : failedExecution.getExecution().withState(State.Type.FAILED);
    }

    private void executionMonitor() {
        try {
            ZonedDateTime now = ZonedDateTime.now();
            List triggers = this.triggerState.findByNextExecutionDateReadyButLockedTriggers(now);
            if (CollectionUtils.isEmpty((Collection)triggers)) {
                log.debug("executionMonitor triggers is empty, skip");
                return;
            }
            triggers.forEach(lastTrigger -> {
                Optional<Execution> execution = this.executionState.findById(lastTrigger.getTenantId(), lastTrigger.getExecutionId());
                if (execution.isEmpty()) {
                    if (lastTrigger.getUpdatedDate() != null) {
                        this.metricRegistry.timer("scheduler.execution.missing.duration", "Missing execution duration inside the Scheduler. A missing execution is an execution that was triggered by the Scheduler but not yet started by the Executor", this.metricRegistry.tags((TriggerContext)lastTrigger)).record(Duration.between(lastTrigger.getUpdatedDate(), Instant.now()));
                    }
                    if (lastTrigger.getUpdatedDate() == null || lastTrigger.getUpdatedDate().plusSeconds(60L).isBefore(Instant.now())) {
                        this.logService.logTrigger((TriggerContext)lastTrigger, Level.WARN, "Execution '{}' is not found, schedule is blocked since '{}'", new Object[]{lastTrigger.getExecutionId(), lastTrigger.getUpdatedDate()});
                    }
                    return;
                }
                if (lastTrigger.getUpdatedDate() != null) {
                    this.metricRegistry.timer("scheduler.execution.lock.duration", "Trigger lock duration waiting for an execution to be terminated", this.metricRegistry.tags((TriggerContext)lastTrigger)).record(Duration.between(lastTrigger.getUpdatedDate(), Instant.now()));
                }
                if (log.isDebugEnabled()) {
                    this.logService.logTrigger((TriggerContext)lastTrigger, Level.DEBUG, "Execution '{}' is still '{}', updated at '{}'", new Object[]{lastTrigger.getExecutionId(), execution.get().getState().getCurrent(), lastTrigger.getUpdatedDate()});
                }
            });
        }
        catch (Exception e) {
            log.error("executionMonitor error", (Throwable)e);
        }
    }

    private void log(SchedulerExecutionWithTrigger executionWithTrigger) {
        this.metricRegistry.counter("scheduler.trigger.count", "Total number of executions triggered by the Scheduler", this.metricRegistry.tags(executionWithTrigger.getExecution())).increment();
        ZonedDateTime now = AbstractScheduler.now();
        if (executionWithTrigger.getExecution().getTrigger() != null && executionWithTrigger.getExecution().getTrigger().getVariables() != null && executionWithTrigger.getExecution().getTrigger().getVariables().containsKey("next")) {
            ZonedDateTime next;
            Object nextVariable = executionWithTrigger.getExecution().getTrigger().getVariables().get("next");
            ZonedDateTime zonedDateTime = next = nextVariable != null ? ZonedDateTime.parse((CharSequence)nextVariable) : null;
            if (next != null && now.isBefore(next)) {
                this.metricRegistry.timer("scheduler.trigger.delay.duration", "Trigger delay duration inside the Scheduler", this.metricRegistry.tags(executionWithTrigger.getExecution())).record(Duration.between(executionWithTrigger.getTriggerContext().getDate(), now));
            }
        }
        this.logService.logTrigger(executionWithTrigger.getTriggerContext(), Level.INFO, "Scheduled execution {} at '{}' started at '{}'", new Object[]{executionWithTrigger.getExecution().getId(), executionWithTrigger.getTriggerContext().getDate(), now});
    }

    private static ZonedDateTime now() {
        return ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    private Optional<SchedulerExecutionWithTrigger> evaluateScheduleTrigger(FlowWithWorkerTrigger flowWithTrigger) {
        return (Optional)this.metricRegistry.timer("scheduler.trigger.evaluation.duration", "Trigger evaluation duration for trigger executed inside the Scheduler (Schedulable triggers)", this.metricRegistry.tags(flowWithTrigger.getAbstractTrigger())).record(() -> {
            try {
                DefaultRunContext runContext = (DefaultRunContext)flowWithTrigger.getConditionContext().getRunContext();
                this.runContextInitializer.forScheduler(runContext, (TriggerContext)flowWithTrigger.getTriggerContext(), flowWithTrigger.getAbstractTrigger());
                Optional evaluate = ((Schedulable)flowWithTrigger.getAbstractTrigger()).evaluate(flowWithTrigger.getConditionContext(), (TriggerContext)flowWithTrigger.getTriggerContext());
                if (log.isDebugEnabled()) {
                    this.logService.logTrigger((TriggerContext)flowWithTrigger.getTriggerContext(), Level.DEBUG, "[type: {}] {}", new Object[]{flowWithTrigger.getAbstractTrigger().getType(), evaluate.map(execution -> "New execution '" + execution.getId() + "'").orElse("Empty evaluation")});
                }
                flowWithTrigger.getConditionContext().getRunContext().cleanup();
                return evaluate.map(execution -> new SchedulerExecutionWithTrigger((Execution)execution, (TriggerContext)flowWithTrigger.getTriggerContext()));
            }
            catch (Exception e) {
                this.logError(flowWithTrigger, e);
                return Optional.empty();
            }
        });
    }

    private void logError(FlowWithWorkerTrigger flowWithWorkerTriggerNextDate, Throwable e) {
        Logger logger = flowWithWorkerTriggerNextDate.getConditionContext().getRunContext().logger();
        this.logService.logTrigger((TriggerContext)flowWithWorkerTriggerNextDate.getTriggerContext(), logger, Level.WARN, "[date: {}] Evaluate Failed with error '{}'", new Object[]{flowWithWorkerTriggerNextDate.getTriggerContext().getDate(), e.getMessage(), e});
        if (logger.isTraceEnabled()) {
            logger.trace(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void logError(ConditionContext conditionContext, FlowWithSource flow, AbstractTrigger trigger, Throwable e) {
        Logger logger = conditionContext.getRunContext().logger();
        this.logService.logExecution((FlowId)flow, logger, Level.ERROR, "[trigger: {}] [date: {}] Evaluate Failed with error '{}'", new Object[]{trigger.getId(), AbstractScheduler.now(), e.getMessage(), e});
    }

    private void sendWorkerTriggerToWorker(FlowWithWorkerTrigger flowWithTrigger) throws InternalException {
        if (log.isDebugEnabled()) {
            this.logService.logTrigger((TriggerContext)flowWithTrigger.getTriggerContext(), Level.DEBUG, "[date: {}] Scheduling evaluation to the worker", new Object[]{flowWithTrigger.getTriggerContext().getDate()});
        }
        WorkerTrigger workerTrigger = WorkerTrigger.builder().trigger(flowWithTrigger.abstractTrigger).triggerContext(flowWithTrigger.triggerContext).conditionContext(flowWithTrigger.conditionContext).build();
        try {
            Optional workerGroup = this.workerGroupService.resolveGroupFromJob((FlowInterface)flowWithTrigger.getFlow(), (WorkerJob)workerTrigger);
            if (workerGroup.isPresent()) {
                String tenantId = flowWithTrigger.getFlow().getTenantId();
                RunContext runContext = flowWithTrigger.conditionContext.getRunContext();
                String workerGroupKey = runContext.render(((WorkerGroup)workerGroup.get()).getKey());
                if (this.workerGroupExecutorInterface.isWorkerGroupExistForKey(workerGroupKey, tenantId)) {
                    if (this.workerGroupExecutorInterface.isWorkerGroupAvailableForKey(workerGroupKey)) {
                        this.workerJobQueue.emit(workerGroupKey, (Object)workerTrigger);
                    } else {
                        WorkerGroup.Fallback fallback = workerGroup.map(WorkerGroup::getFallback).orElse(WorkerGroup.Fallback.WAIT);
                        switch (fallback) {
                            case FAIL: {
                                runContext.logger().error("No workers are available for worker group '{}', ignoring the trigger.", (Object)workerGroupKey);
                                break;
                            }
                            case CANCEL: {
                                runContext.logger().warn("No workers are available for worker group '{}', ignoring the trigger.", (Object)workerGroupKey);
                                break;
                            }
                            case WAIT: {
                                runContext.logger().info("No workers are available for worker group '{}', waiting for one to be available.", (Object)workerGroupKey);
                                this.workerJobQueue.emit(workerGroupKey, (Object)workerTrigger);
                            }
                        }
                    }
                } else {
                    runContext.logger().error("No worker group exist for key '{}', ignoring the trigger.", (Object)workerGroupKey);
                }
            } else {
                this.workerJobQueue.emit((Object)workerTrigger);
            }
        }
        catch (QueueException e) {
            log.error("Unable to emit the Worker Trigger job", (Throwable)e);
        }
    }

    @PreDestroy
    public void close() {
        this.close(null);
    }

    protected void close(@Nullable Runnable onClose) {
        if (this.shutdown.compareAndSet(false, true)) {
            if (log.isDebugEnabled()) {
                log.debug("Terminating");
            }
            this.setState(Service.ServiceState.TERMINATING);
            this.receiveCancellations.forEach(Runnable::run);
            ExecutorsUtils.closeScheduledThreadPool((ScheduledExecutorService)this.scheduleExecutor, (Duration)Duration.ofSeconds(5L), List.of(this.scheduledFuture));
            ExecutorsUtils.closeScheduledThreadPool((ScheduledExecutorService)this.executionMonitorExecutor, (Duration)Duration.ofSeconds(5L), List.of(this.executionMonitorFuture));
            try {
                if (onClose != null) {
                    onClose.run();
                }
            }
            catch (Exception e) {
                log.error("Unexpected error while terminating scheduler.", (Throwable)e);
            }
            this.setState(Service.ServiceState.TERMINATED_GRACEFULLY);
            if (log.isDebugEnabled()) {
                log.debug("Closed ({}).", (Object)this.state.get().name());
            }
        }
    }

    protected void setState(Service.ServiceState state) {
        this.state.set(state);
        this.serviceStateEventPublisher.publishEvent((Object)new ServiceStateChangeEvent((Service)this));
    }

    public String getId() {
        return this.id;
    }

    public ServiceType getType() {
        return ServiceType.SCHEDULER;
    }

    public Service.ServiceState getState() {
        return this.state.get();
    }

    @Generated
    public SchedulerTriggerStateInterface getTriggerState() {
        return this.triggerState;
    }

    @Generated
    public List<FlowWithTriggers> getSchedulable() {
        return this.schedulable;
    }

    @Generated
    public Map<String, FlowWithWorkerTriggerNextDate> getSchedulableNextDate() {
        return this.schedulableNextDate;
    }

    private static class FlowWithWorkerTrigger {
        private FlowWithSource flow;
        private AbstractTrigger abstractTrigger;
        private Trigger triggerContext;
        private ConditionContext conditionContext;

        public FlowWithWorkerTrigger from(FlowWithSource flow) throws InternalException {
            AbstractTrigger abstractTrigger = flow.getTriggers().stream().filter(a -> a.getId().equals(this.abstractTrigger.getId()) && a instanceof WorkerTriggerInterface).findFirst().orElseThrow(() -> new InternalException("Couldn't find the trigger '" + this.abstractTrigger.getId() + "' on flow '" + flow.uid() + "'"));
            return ((FlowWithWorkerTriggerBuilder)((FlowWithWorkerTriggerBuilder)this.toBuilder().flow(flow)).abstractTrigger(abstractTrigger)).build();
        }

        @Generated
        protected FlowWithWorkerTrigger(FlowWithWorkerTriggerBuilder<?, ?> b) {
            this.flow = b.flow;
            this.abstractTrigger = b.abstractTrigger;
            this.triggerContext = b.triggerContext;
            this.conditionContext = b.conditionContext;
        }

        @Generated
        public static FlowWithWorkerTriggerBuilder<?, ?> builder() {
            return new FlowWithWorkerTriggerBuilderImpl();
        }

        @Generated
        public FlowWithWorkerTriggerBuilder<?, ?> toBuilder() {
            return new FlowWithWorkerTriggerBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public FlowWithSource getFlow() {
            return this.flow;
        }

        @Generated
        public AbstractTrigger getAbstractTrigger() {
            return this.abstractTrigger;
        }

        @Generated
        public Trigger getTriggerContext() {
            return this.triggerContext;
        }

        @Generated
        public ConditionContext getConditionContext() {
            return this.conditionContext;
        }

        @Generated
        public FlowWithWorkerTrigger() {
        }

        @Generated
        public static abstract class FlowWithWorkerTriggerBuilder<C extends FlowWithWorkerTrigger, B extends FlowWithWorkerTriggerBuilder<C, B>> {
            @Generated
            private FlowWithSource flow;
            @Generated
            private AbstractTrigger abstractTrigger;
            @Generated
            private Trigger triggerContext;
            @Generated
            private ConditionContext conditionContext;

            @Generated
            protected B $fillValuesFrom(C instance) {
                FlowWithWorkerTriggerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(FlowWithWorkerTrigger instance, FlowWithWorkerTriggerBuilder<?, ?> b) {
                b.flow(instance.flow);
                b.abstractTrigger(instance.abstractTrigger);
                b.triggerContext(instance.triggerContext);
                b.conditionContext(instance.conditionContext);
            }

            @Generated
            public B flow(FlowWithSource flow) {
                this.flow = flow;
                return this.self();
            }

            @Generated
            public B abstractTrigger(AbstractTrigger abstractTrigger) {
                this.abstractTrigger = abstractTrigger;
                return this.self();
            }

            @Generated
            public B triggerContext(Trigger triggerContext) {
                this.triggerContext = triggerContext;
                return this.self();
            }

            @Generated
            public B conditionContext(ConditionContext conditionContext) {
                this.conditionContext = conditionContext;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AbstractScheduler.FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder(flow=" + String.valueOf(this.flow) + ", abstractTrigger=" + String.valueOf(this.abstractTrigger) + ", triggerContext=" + String.valueOf(this.triggerContext) + ", conditionContext=" + String.valueOf(this.conditionContext) + ")";
            }
        }

        @Generated
        private static final class FlowWithWorkerTriggerBuilderImpl
        extends FlowWithWorkerTriggerBuilder<FlowWithWorkerTrigger, FlowWithWorkerTriggerBuilderImpl> {
            @Generated
            private FlowWithWorkerTriggerBuilderImpl() {
            }

            @Override
            @Generated
            protected FlowWithWorkerTriggerBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public FlowWithWorkerTrigger build() {
                return new FlowWithWorkerTrigger(this);
            }
        }
    }

    public static class FlowWithWorkerTriggerNextDate
    extends FlowWithWorkerTrigger {
        private ZonedDateTime next;

        private static FlowWithWorkerTriggerNextDate of(FlowWithWorkerTrigger f) {
            return ((FlowWithWorkerTriggerNextDateBuilder)((FlowWithWorkerTriggerNextDateBuilder)((FlowWithWorkerTriggerNextDateBuilder)((FlowWithWorkerTriggerNextDateBuilder)((FlowWithWorkerTriggerNextDateBuilder)FlowWithWorkerTriggerNextDate.builder().flow(f.getFlow())).abstractTrigger(f.getAbstractTrigger())).conditionContext(f.getConditionContext())).triggerContext(((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().tenantId(f.getTriggerContext().getTenantId())).namespace(f.getTriggerContext().getNamespace())).flowId(f.getTriggerContext().getFlowId())).triggerId(f.getTriggerContext().getTriggerId())).date(f.getTriggerContext().getNextExecutionDate())).nextExecutionDate(f.getTriggerContext().getNextExecutionDate())).backfill(f.getTriggerContext().getBackfill())).stopAfter(f.getTriggerContext().getStopAfter())).build())).next(f.getTriggerContext().getNextExecutionDate())).build();
        }

        @Generated
        protected FlowWithWorkerTriggerNextDate(FlowWithWorkerTriggerNextDateBuilder<?, ?> b) {
            super(b);
            this.next = b.next;
        }

        @Generated
        public static FlowWithWorkerTriggerNextDateBuilder<?, ?> builder() {
            return new FlowWithWorkerTriggerNextDateBuilderImpl();
        }

        @Generated
        public ZonedDateTime getNext() {
            return this.next;
        }

        @Generated
        public FlowWithWorkerTriggerNextDate() {
        }

        @Generated
        public static abstract class FlowWithWorkerTriggerNextDateBuilder<C extends FlowWithWorkerTriggerNextDate, B extends FlowWithWorkerTriggerNextDateBuilder<C, B>>
        extends FlowWithWorkerTrigger.FlowWithWorkerTriggerBuilder<C, B> {
            @Generated
            private ZonedDateTime next;

            @Generated
            public B next(ZonedDateTime next) {
                this.next = next;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "AbstractScheduler.FlowWithWorkerTriggerNextDate.FlowWithWorkerTriggerNextDateBuilder(super=" + super.toString() + ", next=" + String.valueOf(this.next) + ")";
            }
        }

        @Generated
        private static final class FlowWithWorkerTriggerNextDateBuilderImpl
        extends FlowWithWorkerTriggerNextDateBuilder<FlowWithWorkerTriggerNextDate, FlowWithWorkerTriggerNextDateBuilderImpl> {
            @Generated
            private FlowWithWorkerTriggerNextDateBuilderImpl() {
            }

            @Override
            @Generated
            protected FlowWithWorkerTriggerNextDateBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public FlowWithWorkerTriggerNextDate build() {
                return new FlowWithWorkerTriggerNextDate(this);
            }
        }
    }

    public static class FlowWithTriggers {
        private final FlowWithSource flow;
        private final AbstractTrigger abstractTrigger;
        private final Trigger triggerContext;
        private final ConditionContext conditionContext;

        public String uid() {
            return Trigger.uid((Flow)this.flow, (AbstractTrigger)this.abstractTrigger);
        }

        @Generated
        public static FlowWithTriggersBuilder builder() {
            return new FlowWithTriggersBuilder();
        }

        @Generated
        public FlowWithTriggersBuilder toBuilder() {
            return new FlowWithTriggersBuilder().flow(this.flow).abstractTrigger(this.abstractTrigger).triggerContext(this.triggerContext).conditionContext(this.conditionContext);
        }

        @ConstructorProperties(value={"flow", "abstractTrigger", "triggerContext", "conditionContext"})
        @Generated
        public FlowWithTriggers(FlowWithSource flow, AbstractTrigger abstractTrigger, Trigger triggerContext, ConditionContext conditionContext) {
            this.flow = flow;
            this.abstractTrigger = abstractTrigger;
            this.triggerContext = triggerContext;
            this.conditionContext = conditionContext;
        }

        @Generated
        public FlowWithSource getFlow() {
            return this.flow;
        }

        @Generated
        public AbstractTrigger getAbstractTrigger() {
            return this.abstractTrigger;
        }

        @Generated
        public Trigger getTriggerContext() {
            return this.triggerContext;
        }

        @Generated
        public ConditionContext getConditionContext() {
            return this.conditionContext;
        }

        @Generated
        public static class FlowWithTriggersBuilder {
            @Generated
            private FlowWithSource flow;
            @Generated
            private AbstractTrigger abstractTrigger;
            @Generated
            private Trigger triggerContext;
            @Generated
            private ConditionContext conditionContext;

            @Generated
            FlowWithTriggersBuilder() {
            }

            @Generated
            public FlowWithTriggersBuilder flow(FlowWithSource flow) {
                this.flow = flow;
                return this;
            }

            @Generated
            public FlowWithTriggersBuilder abstractTrigger(AbstractTrigger abstractTrigger) {
                this.abstractTrigger = abstractTrigger;
                return this;
            }

            @Generated
            public FlowWithTriggersBuilder triggerContext(Trigger triggerContext) {
                this.triggerContext = triggerContext;
                return this;
            }

            @Generated
            public FlowWithTriggersBuilder conditionContext(ConditionContext conditionContext) {
                this.conditionContext = conditionContext;
                return this;
            }

            @Generated
            public FlowWithTriggers build() {
                return new FlowWithTriggers(this.flow, this.abstractTrigger, this.triggerContext, this.conditionContext);
            }

            @Generated
            public String toString() {
                return "AbstractScheduler.FlowWithTriggers.FlowWithTriggersBuilder(flow=" + String.valueOf(this.flow) + ", abstractTrigger=" + String.valueOf(this.abstractTrigger) + ", triggerContext=" + String.valueOf(this.triggerContext) + ", conditionContext=" + String.valueOf(this.conditionContext) + ")";
            }
        }
    }
}

