/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.scheduler.endpoint;

import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.scheduler.AbstractScheduler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import jakarta.inject.Inject;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Endpoint(id="scheduler", defaultSensitive=false)
@Requires(property="kestra.server-type", pattern="(SCHEDULER|STANDALONE)")
public class SchedulerEndpoint {
    @Inject
    AbstractScheduler scheduler;

    @Read
    public SchedulerEndpointResult running() {
        Map<String, AbstractScheduler.FlowWithWorkerTriggerNextDate> schedulableNextDate = this.scheduler.getSchedulableNextDate();
        List<SchedulerEndpointSchedule> result = this.scheduler.schedulerTriggers().stream().filter(flowWithTriggers -> !(flowWithTriggers.getFlow() instanceof FlowWithException)).map(flowWithTrigger -> {
            String uid = Trigger.uid((Flow)flowWithTrigger.getFlow(), (AbstractTrigger)flowWithTrigger.getAbstractTrigger());
            return new SchedulerEndpointSchedule(flowWithTrigger.getFlow().getId(), flowWithTrigger.getFlow().getNamespace(), flowWithTrigger.getFlow().getRevision(), flowWithTrigger.getAbstractTrigger(), schedulableNextDate.containsKey(uid) ? ((AbstractScheduler.FlowWithWorkerTriggerNextDate)schedulableNextDate.get(uid)).getNext() : null);
        }).toList();
        return SchedulerEndpointResult.builder().schedulableCount(result.size()).schedulable(result).build();
    }

    public static class SchedulerEndpointResult {
        private final int schedulableCount;
        private final List<SchedulerEndpointSchedule> schedulable;

        @ConstructorProperties(value={"schedulableCount", "schedulable"})
        @Generated
        SchedulerEndpointResult(int schedulableCount, List<SchedulerEndpointSchedule> schedulable) {
            this.schedulableCount = schedulableCount;
            this.schedulable = schedulable;
        }

        @Generated
        public static SchedulerEndpointResultBuilder builder() {
            return new SchedulerEndpointResultBuilder();
        }

        @Generated
        public int getSchedulableCount() {
            return this.schedulableCount;
        }

        @Generated
        public List<SchedulerEndpointSchedule> getSchedulable() {
            return this.schedulable;
        }

        @Generated
        public static class SchedulerEndpointResultBuilder {
            @Generated
            private int schedulableCount;
            @Generated
            private List<SchedulerEndpointSchedule> schedulable;

            @Generated
            SchedulerEndpointResultBuilder() {
            }

            @Generated
            public SchedulerEndpointResultBuilder schedulableCount(int schedulableCount) {
                this.schedulableCount = schedulableCount;
                return this;
            }

            @Generated
            public SchedulerEndpointResultBuilder schedulable(List<SchedulerEndpointSchedule> schedulable) {
                this.schedulable = schedulable;
                return this;
            }

            @Generated
            public SchedulerEndpointResult build() {
                return new SchedulerEndpointResult(this.schedulableCount, this.schedulable);
            }

            @Generated
            public String toString() {
                return "SchedulerEndpoint.SchedulerEndpointResult.SchedulerEndpointResultBuilder(schedulableCount=" + this.schedulableCount + ", schedulable=" + String.valueOf(this.schedulable) + ")";
            }
        }
    }

    public static class SchedulerEndpointSchedule {
        private final String flowId;
        private final String namespace;
        private final Integer revision;
        private final AbstractTrigger trigger;
        private final ZonedDateTime next;

        @Generated
        public String getFlowId() {
            return this.flowId;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public Integer getRevision() {
            return this.revision;
        }

        @Generated
        public AbstractTrigger getTrigger() {
            return this.trigger;
        }

        @Generated
        public ZonedDateTime getNext() {
            return this.next;
        }

        @ConstructorProperties(value={"flowId", "namespace", "revision", "trigger", "next"})
        @Generated
        public SchedulerEndpointSchedule(String flowId, String namespace, Integer revision, AbstractTrigger trigger, ZonedDateTime next) {
            this.flowId = flowId;
            this.namespace = namespace;
            this.revision = revision;
            this.trigger = trigger;
            this.next = next;
        }
    }
}

