/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.NamespaceFiles;
import io.kestra.core.models.tasks.RunnableTaskException;
import io.kestra.core.models.tasks.runners.AbstractLogConsumer;
import io.kestra.core.models.tasks.runners.DefaultLogConsumer;
import io.kestra.core.models.tasks.runners.RemoteRunnerInterface;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.models.tasks.runners.TargetOS;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.models.tasks.runners.TaskException;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.tasks.runners.TaskRunnerDetailResult;
import io.kestra.core.models.tasks.runners.TaskRunnerResult;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.FilesService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextInitializer;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.NamespaceFilesUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.core.runner.Process;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.RunnerType;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.runner.docker.Docker;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;

public class CommandsWrapper
implements TaskCommands {
    private RunContext runContext;
    private Path workingDirectory;
    private Path outputDirectory;
    private Map<String, Object> additionalVars;
    private Property<List<String>> interpreter;
    private Property<List<String>> beforeCommands;
    private Property<List<String>> commands;
    private boolean beforeCommandsWithOptions;
    private boolean failFast;
    private Map<String, String> env;
    private AbstractLogConsumer logConsumer;
    private RunnerType runnerType;
    private String containerImage;
    private TaskRunner<?> taskRunner;
    private DockerOptions dockerOptions;
    @Deprecated
    private Boolean warningOnStdErr;
    private NamespaceFiles namespaceFiles;
    private Object inputFiles;
    private List<String> outputFiles;
    private Boolean enableOutputDirectory;
    private Duration timeout;
    private TargetOS targetOS;

    public CommandsWrapper(RunContext runContext) {
        this.runContext = runContext;
        this.workingDirectory = runContext.workingDir().path();
        this.logConsumer = new DefaultLogConsumer(runContext);
        this.additionalVars = new HashMap<String, Object>();
        this.env = new HashMap<String, String>();
    }

    public CommandsWrapper withEnv(Map<String, String> envs) {
        return new CommandsWrapper(this.runContext, this.workingDirectory, this.getOutputDirectory(), this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, envs, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    public CommandsWrapper addAdditionalVars(Map<String, Object> additionalVars) {
        if (this.additionalVars == null) {
            this.additionalVars = new HashMap<String, Object>();
        }
        this.additionalVars.putAll(additionalVars);
        return this;
    }

    public CommandsWrapper addEnv(Map<String, String> envs) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.putAll(envs);
        return this;
    }

    public <T extends TaskRunnerDetailResult> ScriptOutput run() throws Exception {
        if (this.namespaceFiles != null && !Boolean.FALSE.equals(this.runContext.render(this.namespaceFiles.getEnabled()).as(Boolean.class).orElse(true))) {
            NamespaceFilesUtils namespaceFilesUtils = (NamespaceFilesUtils)((DefaultRunContext)this.runContext).getApplicationContext().getBean(NamespaceFilesUtils.class);
            namespaceFilesUtils.loadNamespaceFiles(this.runContext, this.namespaceFiles);
        }
        TaskRunner<T> realTaskRunner = this.getTaskRunner();
        if (this.inputFiles != null) {
            FilesService.inputFiles((RunContext)this.runContext, (Map)realTaskRunner.additionalVars(this.runContext, (TaskCommands)this), (Object)this.inputFiles);
        }
        RunContextInitializer initializer = (RunContextInitializer)((DefaultRunContext)this.runContext).getApplicationContext().getBean(RunContextInitializer.class);
        DefaultRunContext taskRunnerRunContext = initializer.forPlugin(((DefaultRunContext)this.runContext).clone(), realTaskRunner);
        List renderedCommands = this.renderCommands(this.runContext, this.commands);
        List<String> renderedBeforeCommands = this.renderCommands(this.runContext, this.beforeCommands);
        List<String> renderedInterpreter = this.renderCommands(this.runContext, this.interpreter);
        List finalCommands = renderedBeforeCommands.isEmpty() && renderedInterpreter.isEmpty() ? renderedCommands : ScriptService.scriptCommands(renderedInterpreter, this.isBeforeCommandsWithOptions() ? this.getBeforeCommandsWithOptions(renderedBeforeCommands) : renderedBeforeCommands, renderedCommands, (TargetOS)Optional.ofNullable(this.targetOS).orElse(TargetOS.AUTO));
        this.commands = Property.ofValue(finalCommands);
        ScriptOutput.ScriptOutputBuilder<?, ?> scriptOutputBuilder = ScriptOutput.builder();
        try {
            TaskRunnerResult taskRunnerResult = realTaskRunner.run((RunContext)taskRunnerRunContext, (TaskCommands)this, this.outputFiles);
            ((ScriptOutput.ScriptOutputBuilder)((ScriptOutput.ScriptOutputBuilder)scriptOutputBuilder.exitCode(taskRunnerResult.getExitCode())).outputFiles(this.getOutputFiles((RunContext)taskRunnerRunContext))).taskRunner(taskRunnerResult.getDetails());
            if (taskRunnerResult.getLogConsumer() != null) {
                ((ScriptOutput.ScriptOutputBuilder)((ScriptOutput.ScriptOutputBuilder)scriptOutputBuilder.stdOutLineCount(taskRunnerResult.getLogConsumer().getStdOutCount())).stdErrLineCount(taskRunnerResult.getLogConsumer().getStdErrCount())).vars(taskRunnerResult.getLogConsumer().getOutputs());
            }
            return scriptOutputBuilder.build();
        }
        catch (TaskException e) {
            Object output = ((ScriptOutput.ScriptOutputBuilder)((ScriptOutput.ScriptOutputBuilder)((ScriptOutput.ScriptOutputBuilder)((ScriptOutput.ScriptOutputBuilder)((ScriptOutput.ScriptOutputBuilder)scriptOutputBuilder.exitCode(e.getExitCode())).stdOutLineCount(e.getStdOutCount())).stdErrLineCount(e.getStdErrCount())).vars(e.getLogConsumer() != null ? e.getLogConsumer().getOutputs() : null)).outputFiles(this.getOutputFiles((RunContext)taskRunnerRunContext))).build();
            throw new RunnableTaskException((Exception)((Object)e), output);
        }
    }

    private Map<String, URI> getOutputFiles(RunContext taskRunnerRunContext) throws Exception {
        HashMap<String, URI> outputFiles = new HashMap<String, URI>();
        if (this.outputDirectoryEnabled()) {
            outputFiles.putAll(ScriptService.uploadOutputFiles((RunContext)taskRunnerRunContext, (Path)this.getOutputDirectory()));
        }
        if (this.outputFiles != null) {
            outputFiles.putAll(FilesService.outputFiles((RunContext)taskRunnerRunContext, this.outputFiles));
        }
        return outputFiles;
    }

    public <T extends TaskRunnerDetailResult> TaskRunner<T> getTaskRunner() {
        if (this.runnerType != null) {
            return switch (this.runnerType) {
                default -> throw new MatchException(null, null);
                case RunnerType.DOCKER -> Docker.from(this.dockerOptions);
                case RunnerType.PROCESS -> new Process();
            };
        }
        if (this.taskRunner instanceof Docker && this.dockerOptions != null) {
            return Docker.from(this.dockerOptions);
        }
        return this.taskRunner;
    }

    public Boolean getEnableOutputDirectory() {
        if (this.enableOutputDirectory == null) {
            return this.runnerType != null;
        }
        return this.enableOutputDirectory;
    }

    public Path getOutputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.workingDirectory.resolve(IdUtils.create());
            if (!this.outputDirectory.toFile().mkdirs()) {
                throw new RuntimeException("Unable to create the output directory " + String.valueOf(this.outputDirectory));
            }
        }
        return this.outputDirectory;
    }

    public String render(RunContext runContext, String command, List<String> internalStorageLocalFiles) throws IllegalVariableEvaluationException, IOException {
        TaskRunner taskRunner = this.getTaskRunner();
        return ScriptService.replaceInternalStorage((RunContext)this.runContext, (Map)taskRunner.additionalVars(runContext, (TaskCommands)this), (String)command, (boolean)(taskRunner instanceof RemoteRunnerInterface));
    }

    public String render(RunContext runContext, Property<String> command) throws IllegalVariableEvaluationException, IOException {
        TaskRunner taskRunner = this.getTaskRunner();
        if (command == null) {
            return null;
        }
        return runContext.render(command).as(String.class, taskRunner.additionalVars(runContext, (TaskCommands)this)).map(Rethrow.throwFunction(c -> ScriptService.replaceInternalStorage((RunContext)runContext, (String)c, (boolean)(taskRunner instanceof RemoteRunnerInterface)))).orElse(null);
    }

    public List<String> renderCommands(RunContext runContext, Property<List<String>> commands) throws IllegalVariableEvaluationException, IOException {
        TaskRunner taskRunner = this.getTaskRunner();
        return ScriptService.replaceInternalStorage((RunContext)this.runContext, (Map)taskRunner.additionalVars(runContext, (TaskCommands)this), commands, (boolean)(taskRunner instanceof RemoteRunnerInterface));
    }

    protected List<String> getBeforeCommandsWithOptions(List<String> beforeCommands) throws IllegalVariableEvaluationException {
        if (!this.isFailFast()) {
            return beforeCommands;
        }
        if (beforeCommands == null || beforeCommands.isEmpty()) {
            return this.getExitOnErrorCommands();
        }
        ArrayList<String> newCommands = new ArrayList<String>(beforeCommands.size() + 1);
        newCommands.addAll(this.getExitOnErrorCommands());
        newCommands.addAll(beforeCommands);
        return newCommands;
    }

    protected List<String> getExitOnErrorCommands() {
        TargetOS os = this.getTargetOS();
        if (os == TargetOS.WINDOWS || os == TargetOS.AUTO && SystemUtils.IS_OS_WINDOWS && this.getTaskRunner() instanceof Process) {
            return List.of("");
        }
        return List.of("set -e");
    }

    @ConstructorProperties(value={"runContext", "workingDirectory", "outputDirectory", "additionalVars", "interpreter", "beforeCommands", "commands", "beforeCommandsWithOptions", "failFast", "env", "logConsumer", "runnerType", "containerImage", "taskRunner", "dockerOptions", "warningOnStdErr", "namespaceFiles", "inputFiles", "outputFiles", "enableOutputDirectory", "timeout", "targetOS"})
    @Generated
    public CommandsWrapper(RunContext runContext, Path workingDirectory, Path outputDirectory, Map<String, Object> additionalVars, Property<List<String>> interpreter, Property<List<String>> beforeCommands, Property<List<String>> commands, boolean beforeCommandsWithOptions, boolean failFast, Map<String, String> env, AbstractLogConsumer logConsumer, RunnerType runnerType, String containerImage, TaskRunner<?> taskRunner, DockerOptions dockerOptions, Boolean warningOnStdErr, NamespaceFiles namespaceFiles, Object inputFiles, List<String> outputFiles, Boolean enableOutputDirectory, Duration timeout, TargetOS targetOS) {
        this.runContext = runContext;
        this.workingDirectory = workingDirectory;
        this.outputDirectory = outputDirectory;
        this.additionalVars = additionalVars;
        this.interpreter = interpreter;
        this.beforeCommands = beforeCommands;
        this.commands = commands;
        this.beforeCommandsWithOptions = beforeCommandsWithOptions;
        this.failFast = failFast;
        this.env = env;
        this.logConsumer = logConsumer;
        this.runnerType = runnerType;
        this.containerImage = containerImage;
        this.taskRunner = taskRunner;
        this.dockerOptions = dockerOptions;
        this.warningOnStdErr = warningOnStdErr;
        this.namespaceFiles = namespaceFiles;
        this.inputFiles = inputFiles;
        this.outputFiles = outputFiles;
        this.enableOutputDirectory = enableOutputDirectory;
        this.timeout = timeout;
        this.targetOS = targetOS;
    }

    @Generated
    public RunContext getRunContext() {
        return this.runContext;
    }

    @Generated
    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Generated
    public Map<String, Object> getAdditionalVars() {
        return this.additionalVars;
    }

    @Generated
    public Property<List<String>> getInterpreter() {
        return this.interpreter;
    }

    @Generated
    public Property<List<String>> getBeforeCommands() {
        return this.beforeCommands;
    }

    @Generated
    public Property<List<String>> getCommands() {
        return this.commands;
    }

    @Generated
    public boolean isBeforeCommandsWithOptions() {
        return this.beforeCommandsWithOptions;
    }

    @Generated
    public boolean isFailFast() {
        return this.failFast;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public AbstractLogConsumer getLogConsumer() {
        return this.logConsumer;
    }

    @Generated
    public RunnerType getRunnerType() {
        return this.runnerType;
    }

    @Generated
    public String getContainerImage() {
        return this.containerImage;
    }

    @Generated
    public DockerOptions getDockerOptions() {
        return this.dockerOptions;
    }

    @Deprecated
    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public NamespaceFiles getNamespaceFiles() {
        return this.namespaceFiles;
    }

    @Generated
    public Object getInputFiles() {
        return this.inputFiles;
    }

    @Generated
    public List<String> getOutputFiles() {
        return this.outputFiles;
    }

    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    @Generated
    public TargetOS getTargetOS() {
        return this.targetOS;
    }

    @Generated
    public CommandsWrapper withInterpreter(Property<List<String>> interpreter) {
        return this.interpreter == interpreter ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withBeforeCommands(Property<List<String>> beforeCommands) {
        return this.beforeCommands == beforeCommands ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withCommands(Property<List<String>> commands) {
        return this.commands == commands ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withBeforeCommandsWithOptions(boolean beforeCommandsWithOptions) {
        return this.beforeCommandsWithOptions == beforeCommandsWithOptions ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withFailFast(boolean failFast) {
        return this.failFast == failFast ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withLogConsumer(AbstractLogConsumer logConsumer) {
        return this.logConsumer == logConsumer ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withRunnerType(RunnerType runnerType) {
        return this.runnerType == runnerType ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withContainerImage(String containerImage) {
        return this.containerImage == containerImage ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withTaskRunner(TaskRunner<?> taskRunner) {
        return this.taskRunner == taskRunner ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withDockerOptions(DockerOptions dockerOptions) {
        return this.dockerOptions == dockerOptions ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Deprecated
    @Generated
    public CommandsWrapper withWarningOnStdErr(Boolean warningOnStdErr) {
        return this.warningOnStdErr == warningOnStdErr ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withNamespaceFiles(NamespaceFiles namespaceFiles) {
        return this.namespaceFiles == namespaceFiles ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withInputFiles(Object inputFiles) {
        return this.inputFiles == inputFiles ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withOutputFiles(List<String> outputFiles) {
        return this.outputFiles == outputFiles ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, outputFiles, this.enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withEnableOutputDirectory(Boolean enableOutputDirectory) {
        return this.enableOutputDirectory == enableOutputDirectory ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, enableOutputDirectory, this.timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withTimeout(Duration timeout) {
        return this.timeout == timeout ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, timeout, this.targetOS);
    }

    @Generated
    public CommandsWrapper withTargetOS(TargetOS targetOS) {
        return this.targetOS == targetOS ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.interpreter, this.beforeCommands, this.commands, this.beforeCommandsWithOptions, this.failFast, this.env, this.logConsumer, this.runnerType, this.containerImage, this.taskRunner, this.dockerOptions, this.warningOnStdErr, this.namespaceFiles, this.inputFiles, this.outputFiles, this.enableOutputDirectory, this.timeout, targetOS);
    }
}

