/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.runner.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.MapUtils;
import io.kestra.plugin.scripts.runner.docker.Credentials;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;

public class DockerService {
    public static DockerClient client(DockerClientConfig dockerClientConfig) {
        ApacheDockerHttpClient dockerHttpClient = new ApacheDockerHttpClient.Builder().dockerHost(dockerClientConfig.getDockerHost()).build();
        return DockerClientBuilder.getInstance((DockerClientConfig)dockerClientConfig).withDockerHttpClient((DockerHttpClient)dockerHttpClient).build();
    }

    public static String findHost(RunContext runContext, String host) throws IllegalVariableEvaluationException {
        if (host != null) {
            return runContext.render(host);
        }
        if (Files.exists(Path.of("/var/run/docker.sock", new String[0]), new LinkOption[0])) {
            return "unix:///var/run/docker.sock";
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return "npipe:////./pipe/docker_engine";
        }
        return "unix:///dind/docker.sock";
    }

    public static DockerClient client(RunContext runContext, @Nullable String host, @Nullable Object config, @Nullable Credentials credentials, @Nullable String image) throws IOException, IllegalVariableEvaluationException {
        DefaultDockerClientConfig.Builder dockerClientConfigBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(DockerService.findHost(runContext, host));
        if (config != null || credentials != null) {
            Path configPath = DockerService.createConfig(runContext, config, credentials != null ? List.of(credentials) : null, image);
            dockerClientConfigBuilder.withDockerConfig(configPath.toFile().getAbsolutePath());
        }
        DefaultDockerClientConfig dockerClientConfig = dockerClientConfigBuilder.build();
        return DockerService.client((DockerClientConfig)dockerClientConfig);
    }

    public static Path createConfig(RunContext runContext, @Nullable Object config, @Nullable List<Credentials> credentials, @Nullable String image) throws IllegalVariableEvaluationException, IOException {
        File docker;
        Map finalConfig = new HashMap();
        if (config != null) {
            if (config instanceof String) {
                String configString = (String)config;
                finalConfig = JacksonMapper.toMap((String)runContext.render(configString));
            } else {
                finalConfig = runContext.render((Map)config);
            }
        }
        if (credentials != null) {
            HashMap<String, Object> auths = new HashMap<String, Object>();
            String registry = "https://index.docker.io/v1/";
            for (Credentials c : credentials) {
                String renderedImage;
                String detectedRegistry;
                if (c.getUsername() != null) {
                    auths.put("username", runContext.render(c.getUsername()).as(String.class).orElse(null));
                }
                if (c.getPassword() != null) {
                    auths.put("password", runContext.render(c.getPassword()).as(String.class).orElse(null));
                }
                if (c.getRegistryToken() != null) {
                    auths.put("registrytoken", runContext.render(c.getRegistryToken()).as(String.class).orElse(null));
                }
                if (c.getIdentityToken() != null) {
                    auths.put("identitytoken", runContext.render(c.getIdentityToken()).as(String.class).orElse(null));
                }
                if (c.getAuth() != null) {
                    auths.put("auth", runContext.render(c.getAuth()).as(String.class).orElse(null));
                }
                if (c.getRegistry() != null) {
                    registry = runContext.render(c.getRegistry()).as(String.class).orElse(null);
                    continue;
                }
                if (image == null || (detectedRegistry = DockerService.registryUrlFromImage(renderedImage = runContext.render(image))).startsWith(renderedImage)) continue;
                registry = detectedRegistry;
            }
            finalConfig = MapUtils.merge(finalConfig, Map.of("auths", Map.of(registry, auths)));
        }
        if ((docker = runContext.workingDir().path(true).resolve("config.json").toFile()).exists()) {
            docker.delete();
        } else {
            Files.createFile(docker.toPath(), new FileAttribute[0]);
        }
        Files.write(docker.toPath(), runContext.render(JacksonMapper.ofJson().writeValueAsString(finalConfig)).getBytes(), new OpenOption[0]);
        return docker.toPath().getParent();
    }

    public static String registryUrlFromImage(String image) {
        NameParser.ReposTag imageParse = NameParser.parseRepositoryTag((String)image);
        return URI.create((String)(imageParse.repos.startsWith("http") ? imageParse.repos : "https://" + imageParse.repos)).getHost();
    }
}

