/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.InputFilesInterface;
import io.kestra.core.models.tasks.NamespaceFiles;
import io.kestra.core.models.tasks.NamespaceFilesInterface;
import io.kestra.core.models.tasks.OutputFilesInterface;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.runners.TargetOS;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.core.runner.Process;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.RunnerType;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.kestra.plugin.scripts.runner.docker.Docker;
import io.kestra.plugin.scripts.runner.docker.PullPolicy;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;

public abstract class AbstractExecScript
extends Task
implements NamespaceFilesInterface,
InputFilesInterface,
OutputFilesInterface {
    @Schema(title="Deprecated - use the 'taskRunner' property instead.", description="Only used if the `taskRunner` property is not set", deprecated=true)
    @PluginProperty
    @Deprecated
    protected RunnerType runner;
    @Schema(title="The task runner to use.", description="Task runners are provided by plugins, each have their own properties.")
    @PluginProperty
    @Valid
    protected TaskRunner<?> taskRunner;
    @Schema(title="A list of commands that will run before the `commands`, allowing to set up the environment e.g. `pip install -r requirements.txt`.")
    protected Property<List<String>> beforeCommands;
    @Schema(title="Additional environment variables for the current process.")
    protected Property<Map<String, String>> env;
    @Schema(title="Not used anymore, will be removed soon")
    @Deprecated
    protected Property<Boolean> warningOnStdErr;
    @Schema(title="Which interpreter to use.")
    @PluginProperty(dynamic=true)
    @NotNull
    protected Property<List<String>> interpreter;
    @Schema(title="Fail the task on the first command with a non-zero status.", description="If set to `false` all commands will be executed one after the other. The final state of task execution is determined by the last command. Note that this property maybe be ignored if a non compatible interpreter is specified.\nYou can also disable it if your interpreter does not support the `set -e`option.")
    protected Property<Boolean> failFast;
    private NamespaceFiles namespaceFiles;
    private Object inputFiles;
    private Property<List<String>> outputFiles;
    @Schema(title="Whether to setup the output directory mechanism.", description="Required to use the {{ outputDir }} expression. Note that it could increase the starting time. Deprecated, use the `outputFiles` property instead.", defaultValue="false", deprecated=true)
    @Deprecated
    private Property<Boolean> outputDirectory;
    @Schema(title="The target operating system where the script will run.")
    @NotNull
    protected Property<TargetOS> targetOS;
    @Schema(title="Deprecated - use the 'taskRunner' property instead.", description="Only used if the `taskRunner` property is not set", deprecated=true)
    @Deprecated
    protected DockerOptions docker;

    @Schema(title="The task runner container image, only used if the task runner is container-based.")
    public abstract Property<String> getContainerImage();

    @Deprecated(forRemoval=true, since="0.21")
    protected DockerOptions injectDefaults(@NotNull DockerOptions original) {
        return original;
    }

    protected DockerOptions injectDefaults(RunContext runContext, @NotNull DockerOptions original) throws IllegalVariableEvaluationException {
        return this.injectDefaults(original);
    }

    protected CommandsWrapper commands(RunContext runContext) throws IllegalVariableEvaluationException {
        if (this.getRunner() == null) {
            runContext.logger().debug("Using task runner '{}'", (Object)this.getTaskRunner().getType());
        }
        Map renderedEnv = (Map)runContext.render(this.getEnv()).asMap(String.class, String.class);
        return new CommandsWrapper(runContext).withEnv(renderedEnv.isEmpty() ? new HashMap() : renderedEnv).withRunnerType(this.getRunner()).withContainerImage(runContext.render(this.getContainerImage()).as(String.class).orElse(null)).withTaskRunner(this.getTaskRunner()).withDockerOptions(this.getDocker() != null ? this.injectDefaults(runContext, this.getDocker()) : null).withNamespaceFiles(this.getNamespaceFiles()).withInputFiles(this.getInputFiles()).withOutputFiles((List)runContext.render(this.getOutputFiles()).asList(String.class)).withEnableOutputDirectory(runContext.render(this.getOutputDirectory()).as(Boolean.class).orElse(null)).withTimeout(runContext.render(this.getTimeout()).as(Duration.class).orElse(null)).withTargetOS((TargetOS)runContext.render(this.getTargetOS()).as(TargetOS.class).orElseThrow()).withFailFast(runContext.render(this.getFailFast()).as(Boolean.class).orElse(false));
    }

    @Deprecated(since="0.22")
    protected List<String> getBeforeCommandsWithOptions(RunContext runContext) throws IllegalVariableEvaluationException {
        return this.mayAddExitOnErrorCommands((List)runContext.render(this.getBeforeCommands()).asList(String.class), runContext);
    }

    protected List<String> mayAddExitOnErrorCommands(List<String> commands, RunContext runContext) throws IllegalVariableEvaluationException {
        if (!((Boolean)runContext.render(this.getFailFast()).as(Boolean.class).orElseThrow()).booleanValue()) {
            return commands;
        }
        if (commands == null || commands.isEmpty()) {
            return this.getExitOnErrorCommands(runContext);
        }
        ArrayList<String> newCommands = new ArrayList<String>(commands.size() + 1);
        newCommands.addAll(this.getExitOnErrorCommands(runContext));
        newCommands.addAll(commands);
        return newCommands;
    }

    protected List<String> getExitOnErrorCommands(RunContext runContext) throws IllegalVariableEvaluationException {
        TargetOS rendered = (TargetOS)runContext.render(this.getTargetOS()).as(TargetOS.class).orElseThrow();
        if (rendered == TargetOS.WINDOWS || rendered == TargetOS.AUTO && SystemUtils.IS_OS_WINDOWS && this.getTaskRunner() instanceof Process) {
            return List.of("");
        }
        return List.of("set -e");
    }

    public void kill() {
        if (this.getTaskRunner() != null) {
            this.getTaskRunner().kill();
        }
    }

    @Generated
    private static TaskRunner<?> $default$taskRunner() {
        return ((Docker.DockerBuilder)((Object)((Docker.DockerBuilder)Docker.builder().type(Docker.class.getName())).pullPolicy((Property<PullPolicy>)Property.ofValue((Object)((Object)PullPolicy.IF_NOT_PRESENT))))).build();
    }

    @Generated
    private static Property<List<String>> $default$interpreter() {
        return Property.ofValue(List.of("/bin/sh", "-c"));
    }

    @Generated
    private static Property<Boolean> $default$failFast() {
        return Property.ofValue((Object)true);
    }

    @Generated
    private static Property<TargetOS> $default$targetOS() {
        return Property.ofValue((Object)TargetOS.AUTO);
    }

    @Generated
    protected AbstractExecScript(AbstractExecScriptBuilder<?, ?> b) {
        super(b);
        this.runner = b.runner;
        this.taskRunner = b.taskRunner$set ? b.taskRunner$value : AbstractExecScript.$default$taskRunner();
        this.beforeCommands = b.beforeCommands;
        this.env = b.env;
        this.warningOnStdErr = b.warningOnStdErr;
        this.interpreter = b.interpreter$set ? b.interpreter$value : AbstractExecScript.$default$interpreter();
        this.failFast = b.failFast$set ? b.failFast$value : AbstractExecScript.$default$failFast();
        this.namespaceFiles = b.namespaceFiles;
        this.inputFiles = b.inputFiles;
        this.outputFiles = b.outputFiles;
        this.outputDirectory = b.outputDirectory;
        this.targetOS = b.targetOS$set ? b.targetOS$value : AbstractExecScript.$default$targetOS();
        this.docker = b.docker;
    }

    @Generated
    public String toString() {
        return "AbstractExecScript(super=" + super.toString() + ", runner=" + String.valueOf((Object)this.getRunner()) + ", taskRunner=" + String.valueOf(this.getTaskRunner()) + ", beforeCommands=" + String.valueOf(this.getBeforeCommands()) + ", env=" + String.valueOf(this.getEnv()) + ", warningOnStdErr=" + String.valueOf(this.getWarningOnStdErr()) + ", interpreter=" + String.valueOf(this.getInterpreter()) + ", failFast=" + String.valueOf(this.getFailFast()) + ", namespaceFiles=" + String.valueOf(this.getNamespaceFiles()) + ", inputFiles=" + String.valueOf(this.getInputFiles()) + ", outputFiles=" + String.valueOf(this.getOutputFiles()) + ", outputDirectory=" + String.valueOf(this.getOutputDirectory()) + ", targetOS=" + String.valueOf(this.getTargetOS()) + ", docker=" + String.valueOf(this.getDocker()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractExecScript)) {
            return false;
        }
        AbstractExecScript other = (AbstractExecScript)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunnerType this$runner = this.getRunner();
        RunnerType other$runner = other.getRunner();
        if (this$runner == null ? other$runner != null : !((Object)((Object)this$runner)).equals((Object)other$runner)) {
            return false;
        }
        TaskRunner<?> this$taskRunner = this.getTaskRunner();
        TaskRunner<?> other$taskRunner = other.getTaskRunner();
        if (this$taskRunner == null ? other$taskRunner != null : !this$taskRunner.equals(other$taskRunner)) {
            return false;
        }
        Property<List<String>> this$beforeCommands = this.getBeforeCommands();
        Property<List<String>> other$beforeCommands = other.getBeforeCommands();
        if (this$beforeCommands == null ? other$beforeCommands != null : !this$beforeCommands.equals(other$beforeCommands)) {
            return false;
        }
        Property<Map<String, String>> this$env = this.getEnv();
        Property<Map<String, String>> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        Property<Boolean> this$warningOnStdErr = this.getWarningOnStdErr();
        Property<Boolean> other$warningOnStdErr = other.getWarningOnStdErr();
        if (this$warningOnStdErr == null ? other$warningOnStdErr != null : !this$warningOnStdErr.equals(other$warningOnStdErr)) {
            return false;
        }
        Property<List<String>> this$interpreter = this.getInterpreter();
        Property<List<String>> other$interpreter = other.getInterpreter();
        if (this$interpreter == null ? other$interpreter != null : !this$interpreter.equals(other$interpreter)) {
            return false;
        }
        Property<Boolean> this$failFast = this.getFailFast();
        Property<Boolean> other$failFast = other.getFailFast();
        if (this$failFast == null ? other$failFast != null : !this$failFast.equals(other$failFast)) {
            return false;
        }
        NamespaceFiles this$namespaceFiles = this.getNamespaceFiles();
        NamespaceFiles other$namespaceFiles = other.getNamespaceFiles();
        if (this$namespaceFiles == null ? other$namespaceFiles != null : !this$namespaceFiles.equals(other$namespaceFiles)) {
            return false;
        }
        Object this$inputFiles = this.getInputFiles();
        Object other$inputFiles = other.getInputFiles();
        if (this$inputFiles == null ? other$inputFiles != null : !this$inputFiles.equals(other$inputFiles)) {
            return false;
        }
        Property<List<String>> this$outputFiles = this.getOutputFiles();
        Property<List<String>> other$outputFiles = other.getOutputFiles();
        if (this$outputFiles == null ? other$outputFiles != null : !this$outputFiles.equals(other$outputFiles)) {
            return false;
        }
        Property<Boolean> this$outputDirectory = this.getOutputDirectory();
        Property<Boolean> other$outputDirectory = other.getOutputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !this$outputDirectory.equals(other$outputDirectory)) {
            return false;
        }
        Property<TargetOS> this$targetOS = this.getTargetOS();
        Property<TargetOS> other$targetOS = other.getTargetOS();
        if (this$targetOS == null ? other$targetOS != null : !this$targetOS.equals(other$targetOS)) {
            return false;
        }
        DockerOptions this$docker = this.getDocker();
        DockerOptions other$docker = other.getDocker();
        return !(this$docker == null ? other$docker != null : !this$docker.equals(other$docker));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractExecScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RunnerType $runner = this.getRunner();
        result = result * 59 + ($runner == null ? 43 : ((Object)((Object)$runner)).hashCode());
        TaskRunner<?> $taskRunner = this.getTaskRunner();
        result = result * 59 + ($taskRunner == null ? 43 : $taskRunner.hashCode());
        Property<List<String>> $beforeCommands = this.getBeforeCommands();
        result = result * 59 + ($beforeCommands == null ? 43 : $beforeCommands.hashCode());
        Property<Map<String, String>> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        Property<Boolean> $warningOnStdErr = this.getWarningOnStdErr();
        result = result * 59 + ($warningOnStdErr == null ? 43 : $warningOnStdErr.hashCode());
        Property<List<String>> $interpreter = this.getInterpreter();
        result = result * 59 + ($interpreter == null ? 43 : $interpreter.hashCode());
        Property<Boolean> $failFast = this.getFailFast();
        result = result * 59 + ($failFast == null ? 43 : $failFast.hashCode());
        NamespaceFiles $namespaceFiles = this.getNamespaceFiles();
        result = result * 59 + ($namespaceFiles == null ? 43 : $namespaceFiles.hashCode());
        Object $inputFiles = this.getInputFiles();
        result = result * 59 + ($inputFiles == null ? 43 : $inputFiles.hashCode());
        Property<List<String>> $outputFiles = this.getOutputFiles();
        result = result * 59 + ($outputFiles == null ? 43 : $outputFiles.hashCode());
        Property<Boolean> $outputDirectory = this.getOutputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : $outputDirectory.hashCode());
        Property<TargetOS> $targetOS = this.getTargetOS();
        result = result * 59 + ($targetOS == null ? 43 : $targetOS.hashCode());
        DockerOptions $docker = this.getDocker();
        result = result * 59 + ($docker == null ? 43 : $docker.hashCode());
        return result;
    }

    @Deprecated
    @Generated
    public RunnerType getRunner() {
        return this.runner;
    }

    @Generated
    public TaskRunner<?> getTaskRunner() {
        return this.taskRunner;
    }

    @Generated
    public Property<List<String>> getBeforeCommands() {
        return this.beforeCommands;
    }

    @Generated
    public Property<Map<String, String>> getEnv() {
        return this.env;
    }

    @Deprecated
    @Generated
    public Property<Boolean> getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public Property<List<String>> getInterpreter() {
        return this.interpreter;
    }

    @Generated
    public Property<Boolean> getFailFast() {
        return this.failFast;
    }

    @Generated
    public NamespaceFiles getNamespaceFiles() {
        return this.namespaceFiles;
    }

    @Generated
    public Object getInputFiles() {
        return this.inputFiles;
    }

    @Generated
    public Property<List<String>> getOutputFiles() {
        return this.outputFiles;
    }

    @Deprecated
    @Generated
    public Property<Boolean> getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public Property<TargetOS> getTargetOS() {
        return this.targetOS;
    }

    @Deprecated
    @Generated
    public DockerOptions getDocker() {
        return this.docker;
    }

    @Generated
    public AbstractExecScript() {
        this.taskRunner = AbstractExecScript.$default$taskRunner();
        this.interpreter = AbstractExecScript.$default$interpreter();
        this.failFast = AbstractExecScript.$default$failFast();
        this.targetOS = AbstractExecScript.$default$targetOS();
    }

    @Generated
    public static abstract class AbstractExecScriptBuilder<C extends AbstractExecScript, B extends AbstractExecScriptBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private RunnerType runner;
        @Generated
        private boolean taskRunner$set;
        @Generated
        private TaskRunner<?> taskRunner$value;
        @Generated
        private Property<List<String>> beforeCommands;
        @Generated
        private Property<Map<String, String>> env;
        @Generated
        private Property<Boolean> warningOnStdErr;
        @Generated
        private boolean interpreter$set;
        @Generated
        private Property<List<String>> interpreter$value;
        @Generated
        private boolean failFast$set;
        @Generated
        private Property<Boolean> failFast$value;
        @Generated
        private NamespaceFiles namespaceFiles;
        @Generated
        private Object inputFiles;
        @Generated
        private Property<List<String>> outputFiles;
        @Generated
        private Property<Boolean> outputDirectory;
        @Generated
        private boolean targetOS$set;
        @Generated
        private Property<TargetOS> targetOS$value;
        @Generated
        private DockerOptions docker;

        @Deprecated
        @Generated
        public B runner(RunnerType runner) {
            this.runner = runner;
            return (B)this.self();
        }

        @Generated
        public B taskRunner(TaskRunner<?> taskRunner) {
            this.taskRunner$value = taskRunner;
            this.taskRunner$set = true;
            return (B)this.self();
        }

        @Generated
        public B beforeCommands(Property<List<String>> beforeCommands) {
            this.beforeCommands = beforeCommands;
            return (B)this.self();
        }

        @Generated
        public B env(Property<Map<String, String>> env) {
            this.env = env;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B warningOnStdErr(Property<Boolean> warningOnStdErr) {
            this.warningOnStdErr = warningOnStdErr;
            return (B)this.self();
        }

        @Generated
        public B interpreter(Property<List<String>> interpreter) {
            this.interpreter$value = interpreter;
            this.interpreter$set = true;
            return (B)this.self();
        }

        @Generated
        public B failFast(Property<Boolean> failFast) {
            this.failFast$value = failFast;
            this.failFast$set = true;
            return (B)this.self();
        }

        @Generated
        public B namespaceFiles(NamespaceFiles namespaceFiles) {
            this.namespaceFiles = namespaceFiles;
            return (B)this.self();
        }

        @Generated
        public B inputFiles(Object inputFiles) {
            this.inputFiles = inputFiles;
            return (B)this.self();
        }

        @Generated
        public B outputFiles(Property<List<String>> outputFiles) {
            this.outputFiles = outputFiles;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B outputDirectory(Property<Boolean> outputDirectory) {
            this.outputDirectory = outputDirectory;
            return (B)this.self();
        }

        @Generated
        public B targetOS(Property<TargetOS> targetOS) {
            this.targetOS$value = targetOS;
            this.targetOS$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B docker(DockerOptions docker) {
            this.docker = docker;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractExecScript.AbstractExecScriptBuilder(super=" + super.toString() + ", runner=" + String.valueOf((Object)this.runner) + ", taskRunner$value=" + String.valueOf(this.taskRunner$value) + ", beforeCommands=" + String.valueOf(this.beforeCommands) + ", env=" + String.valueOf(this.env) + ", warningOnStdErr=" + String.valueOf(this.warningOnStdErr) + ", interpreter$value=" + String.valueOf(this.interpreter$value) + ", failFast$value=" + String.valueOf(this.failFast$value) + ", namespaceFiles=" + String.valueOf(this.namespaceFiles) + ", inputFiles=" + String.valueOf(this.inputFiles) + ", outputFiles=" + String.valueOf(this.outputFiles) + ", outputDirectory=" + String.valueOf(this.outputDirectory) + ", targetOS$value=" + String.valueOf(this.targetOS$value) + ", docker=" + String.valueOf(this.docker) + ")";
        }
    }
}

