/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.runner.docker;

import io.kestra.core.models.property.Property;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

public class Memory {
    @Schema(title="The maximum amount of memory resources the container can use.", description="Make sure to use the format `number` + `unit` (regardless of the case) without any spaces.\nThe unit can be KB (kilobytes), MB (megabytes), GB (gigabytes), etc.\n\nGiven that it's case-insensitive, the following values are equivalent:\n- `\"512MB\"`\n- `\"512Mb\"`\n- `\"512mb\"`\n- `\"512000KB\"`\n- `\"0.5GB\"`\n\nIt is recommended that you allocate at least `6MB`.")
    private Property<String> memory;
    @Schema(title="The total amount of `memory` and `swap` that can be used by a container.", description="If `memory` and `memorySwap` are set to the same value, this prevents containers from using any swap. This is because `memorySwap` includes both the physical memory and swap space, while `memory` is only the amount of physical memory that can be used.")
    private Property<String> memorySwap;
    @Schema(title="A setting which controls the likelihood of the kernel to swap memory pages.", description="By default, the host kernel can swap out a percentage of anonymous pages used by a container. You can set `memorySwappiness` to a value between 0 and 100 to tune this percentage.")
    private Property<String> memorySwappiness;
    @Schema(title="Allows you to specify a soft limit smaller than `memory` which is activated when Docker detects contention or low memory on the host machine.", description="If you use `memoryReservation`, it must be set lower than `memory` for it to take precedence. Because it is a soft limit, it does not guarantee that the container doesn\u2019t exceed the limit.")
    private Property<String> memoryReservation;
    @Schema(title="The maximum amount of kernel memory the container can use.", description="The minimum allowed value is `4MB`. Because kernel memory cannot be swapped out, a container which is starved of kernel memory may block host machine resources, which can have side effects on the host machine and on other containers. See the [kernel-memory docs](https://docs.docker.com/config/containers/resource_constraints/#--kernel-memory-details) for more details.")
    private Property<String> kernelMemory;
    @Schema(title="By default, if an out-of-memory (OOM) error occurs, the kernel kills processes in a container.", description="To change this behavior, use the `oomKillDisable` option. Only disable the OOM killer on containers where you have also set the `memory` option. If the `memory` flag is not set, the host can run out of memory, and the kernel may need to kill the host system\u2019s processes to free the memory.")
    private Property<Boolean> oomKillDisable;

    @Generated
    protected Memory(MemoryBuilder<?, ?> b) {
        this.memory = b.memory;
        this.memorySwap = b.memorySwap;
        this.memorySwappiness = b.memorySwappiness;
        this.memoryReservation = b.memoryReservation;
        this.kernelMemory = b.kernelMemory;
        this.oomKillDisable = b.oomKillDisable;
    }

    @Generated
    public static MemoryBuilder<?, ?> builder() {
        return new MemoryBuilderImpl();
    }

    @Generated
    public Memory() {
    }

    @Generated
    public Property<String> getMemory() {
        return this.memory;
    }

    @Generated
    public Property<String> getMemorySwap() {
        return this.memorySwap;
    }

    @Generated
    public Property<String> getMemorySwappiness() {
        return this.memorySwappiness;
    }

    @Generated
    public Property<String> getMemoryReservation() {
        return this.memoryReservation;
    }

    @Generated
    public Property<String> getKernelMemory() {
        return this.kernelMemory;
    }

    @Generated
    public Property<Boolean> getOomKillDisable() {
        return this.oomKillDisable;
    }

    @Generated
    public static abstract class MemoryBuilder<C extends Memory, B extends MemoryBuilder<C, B>> {
        @Generated
        private Property<String> memory;
        @Generated
        private Property<String> memorySwap;
        @Generated
        private Property<String> memorySwappiness;
        @Generated
        private Property<String> memoryReservation;
        @Generated
        private Property<String> kernelMemory;
        @Generated
        private Property<Boolean> oomKillDisable;

        @Generated
        public B memory(Property<String> memory) {
            this.memory = memory;
            return this.self();
        }

        @Generated
        public B memorySwap(Property<String> memorySwap) {
            this.memorySwap = memorySwap;
            return this.self();
        }

        @Generated
        public B memorySwappiness(Property<String> memorySwappiness) {
            this.memorySwappiness = memorySwappiness;
            return this.self();
        }

        @Generated
        public B memoryReservation(Property<String> memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this.self();
        }

        @Generated
        public B kernelMemory(Property<String> kernelMemory) {
            this.kernelMemory = kernelMemory;
            return this.self();
        }

        @Generated
        public B oomKillDisable(Property<Boolean> oomKillDisable) {
            this.oomKillDisable = oomKillDisable;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Memory.MemoryBuilder(memory=" + String.valueOf(this.memory) + ", memorySwap=" + String.valueOf(this.memorySwap) + ", memorySwappiness=" + String.valueOf(this.memorySwappiness) + ", memoryReservation=" + String.valueOf(this.memoryReservation) + ", kernelMemory=" + String.valueOf(this.kernelMemory) + ", oomKillDisable=" + String.valueOf(this.oomKillDisable) + ")";
        }
    }

    @Generated
    private static final class MemoryBuilderImpl
    extends MemoryBuilder<Memory, MemoryBuilderImpl> {
        @Generated
        private MemoryBuilderImpl() {
        }

        @Override
        @Generated
        protected MemoryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Memory build() {
            return new Memory(this);
        }
    }
}

