/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core;

import io.kestra.core.plugins.DefaultPluginRegistry;
import io.micronaut.context.ApplicationContext;
import io.micronaut.runtime.server.EmbeddedServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class Helpers {
    public static final long FLOWS_COUNT = Helpers.countFlows();
    private static final Path plugins;

    public static void loadExternalPluginsFromClasspath() {
        DefaultPluginRegistry.getOrCreate().registerIfAbsent(plugins);
    }

    private static int countFlows() {
        int count = 0;
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("flows/valids/");
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            while (br.readLine() != null) {
                ++count;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return count;
    }

    public static ApplicationContext applicationContext() throws URISyntaxException {
        return Helpers.applicationContext(null, new String[]{"test"});
    }

    public static ApplicationContext applicationContext(Map<String, Object> properties) throws URISyntaxException {
        return Helpers.applicationContext(properties, new String[]{"test"});
    }

    private static ApplicationContext applicationContext(Map<String, Object> properties, String[] envs) {
        return ApplicationContext.builder(Helpers.class, (String[])new String[0]).environments(envs).properties(properties).build();
    }

    public static void runApplicationContext(Consumer<ApplicationContext> consumer) throws URISyntaxException {
        try (ApplicationContext applicationContext = Helpers.applicationContext().start();){
            consumer.accept(applicationContext);
        }
    }

    public static void runApplicationContext(BiConsumer<ApplicationContext, EmbeddedServer> consumer) throws URISyntaxException {
        try (ApplicationContext applicationContext = Helpers.applicationContext().start();){
            EmbeddedServer embeddedServer = (EmbeddedServer)applicationContext.getBean(EmbeddedServer.class);
            embeddedServer.start();
            consumer.accept(applicationContext, embeddedServer);
        }
    }

    public static void runApplicationContext(String[] env, Map<String, Object> properties, BiConsumer<ApplicationContext, EmbeddedServer> consumer) throws URISyntaxException {
        try (ApplicationContext applicationContext = Helpers.applicationContext(properties, env).start();){
            EmbeddedServer embeddedServer = (EmbeddedServer)applicationContext.getBean(EmbeddedServer.class);
            embeddedServer.start();
            consumer.accept(applicationContext, embeddedServer);
        }
    }

    public static void runApplicationContext(String[] env, BiConsumer<ApplicationContext, EmbeddedServer> consumer) throws URISyntaxException {
        Helpers.runApplicationContext(env, null, consumer);
    }

    static {
        try {
            plugins = Paths.get(Objects.requireNonNull(Helpers.class.getClassLoader().getResource("plugins")).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

