/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.context;

import com.google.common.annotations.VisibleForTesting;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class TestRunContextFactory
extends RunContextFactory {
    @VisibleForTesting
    public RunContext of() {
        return this.of("id", "namespace");
    }

    @VisibleForTesting
    public RunContext of(String namespace) {
        return this.of("id", namespace);
    }

    @VisibleForTesting
    public RunContext of(String id, String namespace) {
        return this.of(Map.of("flow", Map.of("id", id, "namespace", namespace, "tenantId", "main")));
    }

    @VisibleForTesting
    public RunContext of(String namespace, Map<String, Object> inputs) {
        HashMap<String, Map<String, String>> variables = new HashMap<String, Map<String, String>>(Map.of("flow", Map.of("id", "id", "namespace", namespace, "tenantId", "main")));
        variables.putAll(inputs);
        return this.of(variables);
    }
}

