/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.junit.extensions;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.extensions.ExtensionUtils;
import io.kestra.core.junit.extensions.KestraTestExtension;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.repositories.LocalFlowRepositoryLoader;
import io.kestra.core.runners.RunnerUtils;
import io.kestra.core.serializers.YamlParser;
import io.kestra.core.utils.TestsUtils;
import io.micronaut.context.ApplicationContext;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Objects;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class FlowExecutorExtension
implements AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{KestraTestExtension.class});
    private ApplicationContext context;

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == Execution.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.context == null) {
            this.context = (ApplicationContext)extensionContext.getRoot().getStore(NAMESPACE).get(ApplicationContext.class, ApplicationContext.class);
            if (this.context == null) {
                throw new IllegalStateException("No application context, to use '@LoadFlows' annotation, you need to add '@KestraTest'");
            }
        }
        ExecuteFlow executeFlow = FlowExecutorExtension.getExecuteFlow(extensionContext);
        String tenantId = executeFlow.tenantId();
        String path = executeFlow.value();
        URL url = this.getClass().getClassLoader().getResource(path);
        if (url == null) {
            throw new IllegalArgumentException("Unable to load flow: " + path);
        }
        LocalFlowRepositoryLoader repositoryLoader = (LocalFlowRepositoryLoader)this.context.getBean(LocalFlowRepositoryLoader.class);
        TestsUtils.loads(tenantId, repositoryLoader, Objects.requireNonNull(url));
        Flow flow = (Flow)YamlParser.parse((File)Paths.get(url.toURI()).toFile(), Flow.class);
        RunnerUtils runnerUtils = (RunnerUtils)this.context.getBean(RunnerUtils.class);
        return runnerUtils.runOne(tenantId, flow.getNamespace(), flow.getId(), Duration.parse(executeFlow.timeout()));
    }

    public void afterEach(ExtensionContext extensionContext) throws URISyntaxException {
        ExecuteFlow executeFlow = FlowExecutorExtension.getExecuteFlow(extensionContext);
        FlowRepositoryInterface flowRepository = (FlowRepositoryInterface)this.context.getBean(FlowRepositoryInterface.class);
        String path = executeFlow.value();
        URL resource = ExtensionUtils.loadFile(path);
        Flow loadedFlow = (Flow)YamlParser.parse((File)Paths.get(resource.toURI()).toFile(), Flow.class);
        flowRepository.findAllForAllTenants().stream().filter(flow -> Objects.equals(flow.getId(), loadedFlow.getId())).forEach(flow -> flowRepository.delete((FlowInterface)FlowWithSource.of((Flow)flow, (String)"unused")));
    }

    private static ExecuteFlow getExecuteFlow(ExtensionContext extensionContext) {
        ExecuteFlow executeFlow = ((Method)extensionContext.getTestMethod().orElseThrow()).getAnnotation(ExecuteFlow.class);
        return executeFlow;
    }
}

