/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.junit.extensions;

import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.junit.extensions.ExtensionUtils;
import io.kestra.core.junit.extensions.KestraTestExtension;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.repositories.LocalFlowRepositoryLoader;
import io.kestra.core.serializers.YamlParser;
import io.kestra.core.utils.TestsUtils;
import io.micronaut.context.ApplicationContext;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashSet;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class FlowLoaderExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{KestraTestExtension.class});
    private ApplicationContext applicationContext;

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        if (this.applicationContext == null) {
            extensionContext.getRoot().getStore(NAMESPACE).put((Object)"test", (Object)"bla");
            this.applicationContext = (ApplicationContext)extensionContext.getRoot().getStore(NAMESPACE).get(ApplicationContext.class, ApplicationContext.class);
            if (this.applicationContext == null) {
                throw new IllegalStateException("No application context, to use '@LoadFlows' annotation, you need to add '@KestraTest'");
            }
        }
        LocalFlowRepositoryLoader repositoryLoader = (LocalFlowRepositoryLoader)this.applicationContext.getBean(LocalFlowRepositoryLoader.class);
        LoadFlows loadFlows = FlowLoaderExtension.getLoadFlows(extensionContext);
        for (String path : loadFlows.value()) {
            URL resource = ExtensionUtils.loadFile(path);
            TestsUtils.loads(loadFlows.tenantId(), repositoryLoader, resource);
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws URISyntaxException {
        LoadFlows loadFlows = FlowLoaderExtension.getLoadFlows(extensionContext);
        FlowRepositoryInterface flowRepository = (FlowRepositoryInterface)this.applicationContext.getBean(FlowRepositoryInterface.class);
        HashSet<String> flowIds = new HashSet<String>();
        for (String path : loadFlows.value()) {
            URL resource = ExtensionUtils.loadFile(path);
            Flow flow2 = (Flow)YamlParser.parse((File)Paths.get(resource.toURI()).toFile(), Flow.class);
            flowIds.add(flow2.getId());
        }
        flowRepository.findAllForAllTenants().stream().filter(flow -> flowIds.contains(flow.getId())).forEach(flow -> flowRepository.delete((FlowInterface)FlowWithSource.of((Flow)flow, (String)"unused")));
    }

    private static LoadFlows getLoadFlows(ExtensionContext extensionContext) {
        return ((Method)extensionContext.getTestMethod().orElseThrow()).getAnnotation(LoadFlows.class);
    }
}

