/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.junit.extensions;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.runners.TestRunner;
import io.kestra.core.utils.TestsUtils;
import io.micronaut.test.annotation.MicronautTestValue;
import io.micronaut.test.extensions.junit5.MicronautJunit5Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class KestraTestExtension
extends MicronautJunit5Extension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{KestraTestExtension.class});

    protected MicronautTestValue buildMicronautTestValue(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, KestraTest.class).map(kestraTestAnnotation -> new MicronautTestValue(kestraTestAnnotation.application(), kestraTestAnnotation.environments(), kestraTestAnnotation.packages(), kestraTestAnnotation.propertySources(), kestraTestAnnotation.rollback(), kestraTestAnnotation.transactional(), kestraTestAnnotation.rebuildContext(), (Class[])kestraTestAnnotation.contextBuilder(), kestraTestAnnotation.transactionMode(), kestraTestAnnotation.startApplication(), kestraTestAnnotation.resolveParameters())).orElse(null);
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    protected boolean hasExpectedAnnotations(Class<?> testClass) {
        return AnnotationSupport.isAnnotated(testClass, KestraTest.class);
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        TestRunner runner;
        super.beforeAll(extensionContext);
        KestraTest kestraTest = ((Class)extensionContext.getTestClass().orElseThrow()).getAnnotation(KestraTest.class);
        if (kestraTest.startRunner() && !(runner = (TestRunner)this.applicationContext.getBean(TestRunner.class)).isRunning()) {
            runner.setSchedulerEnabled(kestraTest.startScheduler());
            runner.setWorkerEnabled(kestraTest.startWorker());
            runner.run();
        }
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        super.afterTestExecution(context);
        TestsUtils.queueConsumersCleanup();
    }
}

