/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.runners;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.runners.AbstractLogConsumer;
import io.kestra.core.models.tasks.runners.DefaultLogConsumer;
import io.kestra.core.models.tasks.runners.RemoteRunnerInterface;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.models.tasks.runners.TaskException;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.tasks.runners.TaskRunnerResult;
import io.kestra.core.runners.FilesService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@KestraTest
public abstract class AbstractTaskRunnerTest {
    @Inject
    protected TestRunContextFactory runContextFactory;
    @Inject
    private StorageInterface storage;

    @Test
    protected void run() throws Exception {
        RunContext runContext = this.runContext(this.runContextFactory);
        TaskCommands commands = this.initScriptCommands(runContext);
        Mockito.when((Object)commands.getCommands()).thenReturn((Object)Property.ofValue((Object)ScriptService.scriptCommands(List.of("/bin/sh", "-c"), Collections.emptyList(), List.of("echo 'Hello World'"))));
        TaskRunner<?> taskRunner = this.taskRunner();
        TaskRunnerResult result = taskRunner.run(runContext, commands, Collections.emptyList());
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getExitCode()).isZero();
    }

    @Test
    protected void outputDirDisabled() throws Exception {
        RunContext runContext = this.runContext(this.runContextFactory);
        TaskCommands commands = this.initScriptCommands(runContext);
        Mockito.when((Object)commands.getEnableOutputDirectory()).thenReturn((Object)false);
        Mockito.when((Object)commands.outputDirectoryEnabled()).thenReturn((Object)false);
        Mockito.when((Object)commands.getCommands()).thenReturn((Object)Property.ofValue((Object)ScriptService.scriptCommands(List.of("/bin/sh", "-c"), Collections.emptyList(), List.of("echo 'Hello World'"))));
        TaskRunner<?> taskRunner = this.taskRunner();
        Assertions.assertThat((boolean)taskRunner.additionalVars(runContext, commands).containsKey("outputDir")).isFalse();
        Assertions.assertThat((boolean)taskRunner.env(runContext, commands).containsKey("OUTPUT_DIR")).isFalse();
        TaskRunnerResult result = taskRunner.run(runContext, commands, Collections.emptyList());
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getExitCode()).isZero();
    }

    @Test
    protected void fail() throws IOException {
        RunContext runContext = this.runContext(this.runContextFactory);
        TaskCommands commands = this.initScriptCommands(runContext);
        Mockito.when((Object)commands.getCommands()).thenReturn((Object)Property.ofValue((Object)ScriptService.scriptCommands(List.of("/bin/sh", "-c"), Collections.emptyList(), List.of("return 1"))));
        TaskRunner<?> taskRunner = this.taskRunner();
        org.junit.jupiter.api.Assertions.assertThrows(TaskException.class, () -> taskRunner.run(runContext, commands, Collections.emptyList()));
    }

    @Test
    protected void inputAndOutputFiles() throws Exception {
        RunContext runContext = this.runContext(this.runContextFactory, Map.of("internalStorageFile", "kestra:///internalStorage.txt"));
        TaskCommands commands = this.initScriptCommands(runContext);
        Mockito.when((Object)commands.relativeWorkingDirectoryFilesPaths()).thenCallRealMethod();
        Mockito.when((Object)commands.relativeWorkingDirectoryFilesPaths(false)).thenCallRealMethod();
        FileUtils.writeStringToFile((File)Path.of("/tmp/unittest/main/internalStorage.txt", new String[0]).toFile(), (String)"Hello from internal storage", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)runContext.workingDir().resolve(Path.of("hello.txt", new String[0])).toFile(), (String)"Hello World", (Charset)StandardCharsets.UTF_8);
        final DefaultLogConsumer defaultLogConsumer = new DefaultLogConsumer(runContext);
        final HashMap logsWithIsStdErr = new HashMap();
        TaskRunner<?> taskRunner = this.taskRunner();
        Mockito.when((Object)commands.getLogConsumer()).thenReturn((Object)new AbstractLogConsumer(this){

            public void accept(String line, Boolean isStdErr, Instant instant) {
                logsWithIsStdErr.put(line, isStdErr);
                defaultLogConsumer.accept(line, isStdErr);
            }

            public void accept(String log, Boolean isStdErr) {
                logsWithIsStdErr.put(log, isStdErr);
                defaultLogConsumer.accept(log, isStdErr);
            }
        });
        String wdir = this.needsToSpecifyWorkingDirectory() ? "{{ workingDir }}/" : "";
        List renderedCommands = ScriptService.replaceInternalStorage((RunContext)runContext, (Map)taskRunner.additionalVars(runContext, commands), (List)ScriptService.scriptCommands(List.of("/bin/sh", "-c"), null, List.of("cat " + wdir + "{{internalStorageFile}} && echo", "cat " + wdir + "hello.txt && echo", "cat " + wdir + "hello.txt > " + wdir + "output.txt", "echo -n 'file from output dir' > {{outputDir}}/file.txt", "mkdir {{outputDir}}/nested", "echo -n 'nested file from output dir' > {{outputDir}}/nested/file.txt", "echo '::{\"outputs\":{\"logOutput\":\"Hello World\"}}::'")), (boolean)(taskRunner instanceof RemoteRunnerInterface));
        Mockito.when((Object)commands.getCommands()).thenReturn((Object)Property.ofValue((Object)renderedCommands));
        List<String> filesToDownload = List.of("output.txt");
        TaskRunnerResult run = taskRunner.run(runContext, commands, filesToDownload);
        Map outputFiles = ScriptService.uploadOutputFiles((RunContext)runContext, (Path)commands.getOutputDirectory());
        outputFiles.putAll(FilesService.outputFiles((RunContext)runContext, filesToDownload));
        Assertions.assertThat((int)run.getExitCode()).isZero();
        Set logEntries = logsWithIsStdErr.entrySet();
        Assertions.assertThat((Boolean)((Boolean)logEntries.stream().filter(e -> ((String)e.getKey()).contains("Hello from internal storage")).findFirst().orElseThrow().getValue())).isFalse();
        Assertions.assertThat((Boolean)((Boolean)logEntries.stream().filter(e -> ((String)e.getKey()).contains("Hello World")).findFirst().orElseThrow().getValue())).isFalse();
        Assertions.assertThat((String)IOUtils.toString((InputStream)this.storage.get("main", "unittest", (URI)outputFiles.get("output.txt")), (Charset)StandardCharsets.UTF_8)).isEqualTo("Hello World");
        Assertions.assertThat((String)IOUtils.toString((InputStream)this.storage.get("main", "unittest", (URI)outputFiles.get("file.txt")), (Charset)StandardCharsets.UTF_8)).isEqualTo("file from output dir");
        Assertions.assertThat((String)IOUtils.toString((InputStream)this.storage.get("main", "unittest", (URI)outputFiles.get("nested/file.txt")), (Charset)StandardCharsets.UTF_8)).isEqualTo("nested file from output dir");
        Assertions.assertThat(defaultLogConsumer.getOutputs().get("logOutput")).isEqualTo((Object)"Hello World");
    }

    @Test
    protected void failWithInput() throws IOException {
        RunContext runContext = this.runContext(this.runContextFactory);
        TaskCommands commands = this.initScriptCommands(runContext);
        Mockito.when((Object)commands.getCommands()).thenReturn((Object)Property.ofValue((Object)ScriptService.scriptCommands(List.of("/bin/sh", "-c"), Collections.emptyList(), List.of("echo '::{\"outputs\":{\"logOutput\":\"Hello World\"}}::'", "return 1"))));
        TaskRunner<?> taskRunner = this.taskRunner();
        TaskException taskException = (TaskException)org.junit.jupiter.api.Assertions.assertThrows(TaskException.class, () -> taskRunner.run(runContext, commands, Collections.emptyList()));
        Assertions.assertThat(taskException.getLogConsumer().getOutputs().get("logOutput")).isEqualTo((Object)"Hello World");
    }

    @Test
    protected void canWorkMultipleTimeInSameWdir() throws Exception {
        RunContext runContext = this.runContext(this.runContextFactory);
        TaskCommands commands = this.initScriptCommands(runContext);
        Mockito.when((Object)commands.getEnableOutputDirectory()).thenReturn((Object)false);
        Mockito.when((Object)commands.outputDirectoryEnabled()).thenReturn((Object)false);
        Mockito.when((Object)commands.relativeWorkingDirectoryFilesPaths()).thenCallRealMethod();
        Mockito.when((Object)commands.relativeWorkingDirectoryFilesPaths(false)).thenCallRealMethod();
        TaskRunner<?> taskRunner = this.taskRunner();
        Property renderedCommands = Property.ofValue((Object)ScriptService.replaceInternalStorage((RunContext)runContext, (Map)taskRunner.additionalVars(runContext, commands), (List)ScriptService.scriptCommands(List.of("/bin/sh", "-c"), Collections.emptyList(), List.of("echo 'Hello World' > " + (this.needsToSpecifyWorkingDirectory() ? "{{workingDir}}/" : "") + "file.txt")), (boolean)(taskRunner instanceof RemoteRunnerInterface)));
        Mockito.when((Object)commands.getCommands()).thenReturn((Object)renderedCommands);
        TaskRunnerResult result = taskRunner.run(runContext, commands, Collections.emptyList());
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getExitCode()).isZero();
        renderedCommands = Property.ofValue((Object)ScriptService.replaceInternalStorage((RunContext)runContext, (Map)taskRunner.additionalVars(runContext, commands), (List)ScriptService.scriptCommands(List.of("/bin/sh", "-c"), Collections.emptyList(), List.of("cat " + (this.needsToSpecifyWorkingDirectory() ? "{{workingDir}}/" : "") + "file.txt")), (boolean)(taskRunner instanceof RemoteRunnerInterface)));
        Mockito.when((Object)commands.getCommands()).thenReturn((Object)renderedCommands);
        result = taskRunner.run(runContext, commands, Collections.emptyList());
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getExitCode()).isZero();
    }

    protected RunContext runContext(RunContextFactory runContextFactory) {
        return this.runContext(runContextFactory, null);
    }

    protected RunContext runContext(RunContextFactory runContextFactory, Map<String, Object> additionalVars) {
        Task task = new Task(this){

            public String getId() {
                return "task";
            }

            public String getType() {
                return "Task";
            }
        };
        TaskRun taskRun = TaskRun.builder().id(IdUtils.create()).taskId("task").flowId("flow").namespace("namespace").executionId("execution").state(new State().withState(State.Type.RUNNING)).build();
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("flow")).namespace("namespace")).revision(Integer.valueOf(1))).tasks(List.of(task)).build();
        Execution execution = Execution.builder().flowId("flow").namespace("namespace").id("execution").taskRunList(List.of(taskRun)).state(new State().withState(State.Type.RUNNING)).build();
        RunContext runContext = runContextFactory.of((FlowInterface)flow, task, execution, taskRun);
        if (additionalVars == null) {
            return runContext;
        }
        HashMap<String, Object> mergedVars = new HashMap<String, Object>(runContext.getVariables());
        mergedVars.putAll(additionalVars);
        return runContextFactory.of(mergedVars);
    }

    protected abstract TaskRunner<?> taskRunner();

    protected String defaultImage() {
        return "ubuntu";
    }

    protected TaskCommands initScriptCommands(RunContext runContext) throws IOException {
        TaskCommands commands = (TaskCommands)Mockito.mock(TaskCommands.class);
        Mockito.when((Object)commands.getContainerImage()).thenReturn((Object)this.defaultImage());
        Mockito.when((Object)commands.getLogConsumer()).thenReturn((Object)new DefaultLogConsumer(runContext));
        Path workingDirectory = runContext.workingDir().path();
        Mockito.when((Object)commands.getWorkingDirectory()).thenReturn((Object)workingDirectory);
        Path outputDirectory = workingDirectory.resolve(IdUtils.create());
        outputDirectory.toFile().mkdirs();
        Mockito.when((Object)commands.getOutputDirectory()).thenReturn((Object)outputDirectory);
        Mockito.when((Object)commands.outputDirectoryName()).thenCallRealMethod();
        Mockito.when((Object)commands.getAdditionalVars()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)commands.getEnableOutputDirectory()).thenReturn((Object)true);
        Mockito.when((Object)commands.outputDirectoryEnabled()).thenReturn((Object)true);
        Mockito.when((Object)commands.getTimeout()).thenReturn(null);
        Mockito.when((Object)commands.relativeWorkingDirectoryFilesPaths(true)).thenCallRealMethod();
        return commands;
    }

    protected boolean needsToSpecifyWorkingDirectory() {
        return false;
    }
}

