/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.runners.ExecutorInterface;
import io.kestra.core.runners.Indexer;
import io.kestra.core.runners.Scheduler;
import io.kestra.core.runners.Worker;
import io.kestra.core.server.Service;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.ExecutorsUtils;
import io.kestra.worker.DefaultWorker;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Value;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TestRunner
implements Runnable,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestRunner.class);
    private int workerThread = Math.max(3, Runtime.getRuntime().availableProcessors());
    private boolean schedulerEnabled = true;
    private boolean workerEnabled = true;
    @Inject
    private ExecutorsUtils executorsUtils;
    @Inject
    private ApplicationContext applicationContext;
    @Value(value="${kestra.server.standalone.running.timeout:PT1M}")
    private Duration runningTimeout;
    private final List<Service> servers = new ArrayList<Service>();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ExecutorService poolExecutor;

    @Override
    public void run() {
        this.running.set(true);
        this.poolExecutor = this.executorsUtils.cachedThreadPool("standalone-runner");
        this.poolExecutor.execute((Runnable)this.applicationContext.getBean(ExecutorInterface.class));
        if (this.workerEnabled) {
            String workerID = UUID.randomUUID().toString();
            Worker worker = (Worker)this.applicationContext.createBean(DefaultWorker.class, new Object[]{workerID, this.workerThread, null});
            this.applicationContext.registerSingleton((Object)worker);
            this.poolExecutor.execute((Runnable)worker);
            this.servers.add((Service)worker);
        }
        if (this.schedulerEnabled) {
            Scheduler scheduler = (Scheduler)this.applicationContext.getBean(Scheduler.class);
            this.poolExecutor.execute((Runnable)scheduler);
            this.servers.add((Service)scheduler);
        }
        Indexer indexer = (Indexer)this.applicationContext.getBean(Indexer.class);
        this.poolExecutor.execute((Runnable)indexer);
        this.servers.add((Service)indexer);
        try {
            Await.until(() -> this.servers.stream().allMatch(s -> Optional.ofNullable(s.getState()).orElse(Service.ServiceState.RUNNING).isRunning()), null, (Duration)this.runningTimeout);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(String.valueOf(this.servers.stream().filter(s -> !Optional.ofNullable(s.getState()).orElse(Service.ServiceState.RUNNING).isRunning()).map(Service::getClass).toList()) + " not started in time");
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    @PreDestroy
    public void close() throws Exception {
        if (this.poolExecutor != null) {
            this.poolExecutor.shutdown();
        }
    }

    @Generated
    public void setWorkerThread(int workerThread) {
        this.workerThread = workerThread;
    }

    @Generated
    public void setSchedulerEnabled(boolean schedulerEnabled) {
        this.schedulerEnabled = schedulerEnabled;
    }

    @Generated
    public void setWorkerEnabled(boolean workerEnabled) {
        this.workerEnabled = workerEnabled;
    }
}

