/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.worker;

import io.kestra.core.models.flows.State;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Exceptions;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class AbstractWorkerCallable
implements Callable<State.Type> {
    @Generated
    private final Object $lock = new Object[0];
    volatile boolean killed = false;
    Logger logger;
    RunContext runContext;
    String type;
    String uid;
    Throwable exception;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final ClassLoader classLoader;
    private Thread currentThread;

    AbstractWorkerCallable(RunContext runContext, String type, String uid, ClassLoader classLoader) {
        this.logger = runContext.logger();
        this.runContext = runContext;
        this.type = type;
        this.uid = uid;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Object object = this.$lock;
        synchronized (object) {
            this.kill(true);
        }
    }

    @Override
    public State.Type call() {
        this.currentThread = Thread.currentThread();
        this.currentThread.setContextClassLoader(this.classLoader);
        try {
            State.Type type = this.doCall();
            return type;
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            State.Type type = this.exceptionHandler(e);
            return type;
        }
        finally {
            this.shutdownLatch.countDown();
        }
    }

    protected abstract State.Type doCall() throws Exception;

    protected abstract void signalStop();

    public boolean awaitStop(Duration timeout) {
        try {
            return this.shutdownLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void kill(boolean markAsKilled) {
        this.killed = markAsKilled;
        if (this.shutdownLatch.getCount() > 0L) {
            this.interrupt();
        }
    }

    protected State.Type exceptionHandler(Throwable e) {
        this.exception = e;
        Span.current().recordException(e).setStatus(StatusCode.ERROR);
        if (this.killed) {
            return State.Type.KILLED;
        }
        this.logger.error(e.getMessage(), e);
        return State.Type.FAILED;
    }

    public void interrupt() {
        if (this.currentThread != null && this.currentThread.isAlive()) {
            this.currentThread.interrupt();
        }
    }

    @Generated
    public RunContext getRunContext() {
        return this.runContext;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public Throwable getException() {
        return this.exception;
    }
}

