/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.worker;

import io.kestra.core.models.triggers.WorkerTriggerInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.WorkerTrigger;
import io.kestra.worker.AbstractWorkerCallable;
import java.time.Duration;
import lombok.Generated;

abstract class AbstractWorkerTriggerCallable
extends AbstractWorkerCallable {
    private static final Duration AWAIT_ON_KILL = Duration.ofMillis(50L);
    WorkerTrigger workerTrigger;

    AbstractWorkerTriggerCallable(RunContext runContext, String type, WorkerTrigger workerTrigger) {
        super(runContext, type, workerTrigger.uid(), workerTrigger.getTrigger().getClass().getClassLoader());
        this.workerTrigger = workerTrigger;
    }

    @Override
    public void signalStop() {
        try {
            ((WorkerTriggerInterface)this.workerTrigger.getTrigger()).stop();
        }
        catch (Exception e) {
            this.logger.warn("Error while stopping trigger: '{}'", (Object)this.getType(), (Object)e);
        }
    }

    @Override
    protected void kill(boolean markAsKilled) {
        try {
            ((WorkerTriggerInterface)this.workerTrigger.getTrigger()).kill();
            if (markAsKilled) {
                this.awaitStop(AWAIT_ON_KILL);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error while killing trigger: '{}'", (Object)this.getType(), (Object)e);
        }
        finally {
            super.kill(markAsKilled);
        }
    }

    @Generated
    public WorkerTrigger getWorkerTrigger() {
        return this.workerTrigger;
    }
}

