/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.worker;

import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.Timeout;
import dev.failsafe.TimeoutExceededException;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.RunnableTaskException;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.WorkerTask;
import io.kestra.worker.AbstractWorkerCallable;
import java.time.Duration;
import lombok.Generated;

public class WorkerTaskCallable
extends AbstractWorkerCallable {
    RunnableTask<?> task;
    MetricRegistry metricRegistry;
    WorkerTask workerTask;
    Output taskOutput;

    WorkerTaskCallable(WorkerTask workerTask, RunnableTask<?> task, RunContext runContext, MetricRegistry metricRegistry) {
        super(runContext, task.getClass().getName(), workerTask.uid(), task.getClass().getClassLoader());
        this.workerTask = workerTask;
        this.task = task;
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void signalStop() {
        try {
            this.task.stop();
        }
        catch (Exception e) {
            this.logger.warn("Error while stopping task: '{}'", (Object)this.getType(), (Object)e);
        }
    }

    @Override
    protected void kill(boolean markAsKilled) {
        try {
            this.task.kill();
        }
        catch (Exception e) {
            this.logger.warn("Error while killing task: '{}'", (Object)this.getType(), (Object)e);
        }
        finally {
            super.kill(markAsKilled);
        }
    }

    @Override
    public State.Type doCall() throws Exception {
        Duration workerTaskTimeout = this.workerTask.getRunContext().render(this.workerTask.getTask().getTimeout()).as(Duration.class).orElse(null);
        try {
            if (workerTaskTimeout != null) {
                Timeout taskTimeout = Timeout.builder((Duration)workerTaskTimeout).withInterrupt().build();
                Failsafe.with((Policy)taskTimeout, (Policy[])new Timeout[0]).onFailure(event -> this.metricRegistry.counter("worker.timeout.count", "The total number of tasks that timeout inside the Worker", this.metricRegistry.tags(this.workerTask, "attempt_count", new String[]{String.valueOf(event.getAttemptCount())})).increment()).run(() -> {
                    this.taskOutput = this.task.run(this.runContext);
                });
            } else {
                this.taskOutput = this.task.run(this.runContext);
            }
            if (this.taskOutput != null && this.taskOutput.finalState().isPresent()) {
                return (State.Type)this.taskOutput.finalState().get();
            }
            return State.Type.SUCCESS;
        }
        catch (TimeoutExceededException e) {
            this.kill(false);
            return this.exceptionHandler((Throwable)new io.kestra.core.exceptions.TimeoutExceededException(workerTaskTimeout));
        }
        catch (RunnableTaskException e) {
            this.taskOutput = e.getOutput();
            return this.exceptionHandler(e);
        }
    }

    @Generated
    public WorkerTask getWorkerTask() {
        return this.workerTask;
    }

    @Generated
    public Output getTaskOutput() {
        return this.taskOutput;
    }
}

