/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.worker.endpoint;

import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTrigger;
import io.kestra.worker.DefaultWorker;
import io.micronaut.context.annotation.Requires;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import jakarta.inject.Inject;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

@Endpoint(id="worker", defaultSensitive=false)
@Requires(property="kestra.server-type", pattern="(WORKER|STANDALONE)")
public class WorkerEndpoint {
    @Inject
    DefaultWorker worker;

    @Read
    public WorkerEndpointResult running() throws Exception {
        return WorkerEndpointResult.builder().runningCount(this.worker.getMetricRunningCount().values().stream().mapToInt(AtomicInteger::get).sum()).runnings(this.worker.getWorkerThreadTasks().stream().map(workerTask -> {
            AbstractTrigger abstractTrigger;
            Task task;
            TaskRun taskRun;
            WorkerTask wt;
            String string = workerTask.getType();
            if (workerTask instanceof WorkerTask) {
                wt = (WorkerTask)workerTask;
                taskRun = wt.getTaskRun();
            } else {
                taskRun = null;
            }
            if (workerTask instanceof WorkerTask) {
                wt = (WorkerTask)workerTask;
                task = wt.getTask();
            } else {
                task = null;
            }
            if (workerTask instanceof WorkerTrigger) {
                wt = (WorkerTrigger)workerTask;
                abstractTrigger = wt.getTrigger();
            } else {
                abstractTrigger = null;
            }
            return new WorkerEndpointWorkerTask(string, taskRun, task, abstractTrigger);
        }).toList()).build();
    }

    public static class WorkerEndpointResult {
        private final int runningCount;
        private final List<WorkerEndpointWorkerTask> runnings;

        @ConstructorProperties(value={"runningCount", "runnings"})
        @Generated
        WorkerEndpointResult(int runningCount, List<WorkerEndpointWorkerTask> runnings) {
            this.runningCount = runningCount;
            this.runnings = runnings;
        }

        @Generated
        public static WorkerEndpointResultBuilder builder() {
            return new WorkerEndpointResultBuilder();
        }

        @Generated
        public int getRunningCount() {
            return this.runningCount;
        }

        @Generated
        public List<WorkerEndpointWorkerTask> getRunnings() {
            return this.runnings;
        }

        @Generated
        public static class WorkerEndpointResultBuilder {
            @Generated
            private int runningCount;
            @Generated
            private List<WorkerEndpointWorkerTask> runnings;

            @Generated
            WorkerEndpointResultBuilder() {
            }

            @Generated
            public WorkerEndpointResultBuilder runningCount(int runningCount) {
                this.runningCount = runningCount;
                return this;
            }

            @Generated
            public WorkerEndpointResultBuilder runnings(List<WorkerEndpointWorkerTask> runnings) {
                this.runnings = runnings;
                return this;
            }

            @Generated
            public WorkerEndpointResult build() {
                return new WorkerEndpointResult(this.runningCount, this.runnings);
            }

            @Generated
            public String toString() {
                return "WorkerEndpoint.WorkerEndpointResult.WorkerEndpointResultBuilder(runningCount=" + this.runningCount + ", runnings=" + String.valueOf(this.runnings) + ")";
            }
        }
    }

    public static class WorkerEndpointWorkerTask {
        private final String type;
        private final TaskRun taskRun;
        private final Task task;
        private final AbstractTrigger trigger;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public TaskRun getTaskRun() {
            return this.taskRun;
        }

        @Generated
        public Task getTask() {
            return this.task;
        }

        @Generated
        public AbstractTrigger getTrigger() {
            return this.trigger;
        }

        @ConstructorProperties(value={"type", "taskRun", "task", "trigger"})
        @Generated
        public WorkerEndpointWorkerTask(String type, TaskRun taskRun, Task task, AbstractTrigger trigger) {
            this.type = type;
            this.taskRun = taskRun;
            this.task = task;
            this.trigger = trigger;
        }
    }
}

