/*
 * Decompiled with CFR 0.152.
 */
package io.kgraph.rest.server.curator;

import io.kgraph.rest.server.KafkaGraphsProperties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KafkaGraphsProperties.class})
public class CuratorConfiguration {
    private final KafkaGraphsProperties props;

    public CuratorConfiguration(KafkaGraphsProperties props) {
        this.props = props;
    }

    @Bean(initMethod="start", destroyMethod="close")
    public CuratorFramework curatorFramework(RetryPolicy retryPolicy) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        builder.connectString(this.props.getZookeeperConnect()).retryPolicy(retryPolicy);
        return builder.build();
    }

    @Bean
    public RetryPolicy retryPolicy() {
        return new ExponentialBackoffRetry(1000, 3);
    }
}

