/*
 * Decompiled with CFR 0.152.
 */
package io.kgraph.tools.importer;

import io.kgraph.rest.server.utils.EdgeLongIdLongValueParser;
import io.kgraph.rest.server.utils.VertexLongIdLongValueParser;
import io.kgraph.utils.ClientUtils;
import io.kgraph.utils.GraphUtils;
import io.kgraph.utils.Parser;
import io.kgraph.utils.Parsers;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import picocli.CommandLine;

@CommandLine.Command(description={"Imports a Kafka graph."}, name="graph-import", mixinStandardHelpOptions=true, version={"graph-import 1.0"})
public class GraphImporter<K, VV, EV>
implements Callable<Void> {
    @CommandLine.Parameters(index="0", description={"List of Kafka servers."})
    private String bootstrapServers;
    @CommandLine.Option(names={"-vt", "--verticesTopic"}, description={"The vertices topic."})
    private String verticesTopic;
    @CommandLine.Option(names={"-et", "--edgesTopic"}, description={"The edges topic."})
    private String edgesTopic;
    @CommandLine.Option(names={"-vf", "--verticesFile"}, description={"The vertices file."})
    private File verticesFile;
    @CommandLine.Option(names={"-ef", "--edgesFile"}, description={"The edges file."})
    private File edgesFile;
    @CommandLine.Option(names={"-vp", "--vertexParser"}, description={"The vertex parser."})
    private String vertexParser = VertexLongIdLongValueParser.class.getName();
    @CommandLine.Option(names={"-ep", "--edgeParser"}, description={"The edge parser."})
    private String edgeParser = EdgeLongIdLongValueParser.class.getName();
    @CommandLine.Option(names={"-k", "--keySerializer"}, description={"The key serializer."})
    private String keySerializer = LongSerializer.class.getName();
    @CommandLine.Option(names={"-vs", "--vertexValueSerializer"}, description={"The vertex value serializer."})
    private String vertexValueSerializer = LongSerializer.class.getName();
    @CommandLine.Option(names={"-es", "--edgeValueSerializer"}, description={"The edge value serializer."})
    private String edgeValueSerializer = LongSerializer.class.getName();
    @CommandLine.Option(names={"-np", "--numPartitions"}, description={"The number of partitions for topics."})
    private int numPartitions = 50;
    @CommandLine.Option(names={"-rf", "--replicationFactor"}, description={"The replication factor for topics."})
    private short replicationFactor = 1;

    public GraphImporter() {
    }

    public GraphImporter(String bootstrapServers, String verticesTopic, String edgesTopic, File verticesFile, File edgesFile, String vertexParser, String edgeParser, String keySerializer, String vertexValueSerializer, String edgeValueSerializer, int numPartitions, short replicationFactor) {
        this.bootstrapServers = bootstrapServers;
        this.verticesTopic = verticesTopic;
        this.edgesTopic = edgesTopic;
        this.verticesFile = verticesFile;
        this.edgesFile = edgesFile;
        this.vertexParser = vertexParser;
        this.edgeParser = edgeParser;
        this.keySerializer = keySerializer;
        this.vertexValueSerializer = vertexValueSerializer;
        this.edgeValueSerializer = edgeValueSerializer;
        this.numPartitions = numPartitions;
        this.replicationFactor = replicationFactor;
    }

    @Override
    public Void call() throws Exception {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", this.bootstrapServers);
        if (this.verticesFile != null) {
            if (this.verticesTopic == null) {
                throw new IllegalArgumentException("Missing vertices topic.");
            }
            Parsers.VertexParser vertexReader = (Parsers.VertexParser)ClientUtils.getConfiguredInstance(Class.forName(this.vertexParser), null);
            Serializer keyWriter = (Serializer)ClientUtils.getConfiguredInstance(Class.forName(this.keySerializer), null);
            Serializer vertexValueWriter = (Serializer)ClientUtils.getConfiguredInstance(Class.forName(this.vertexValueSerializer), null);
            GraphUtils.verticesToTopic((InputStream)new BufferedInputStream(new FileInputStream(this.verticesFile)), (Parser)vertexReader, (Serializer)keyWriter, (Serializer)vertexValueWriter, (Properties)props, (String)this.verticesTopic, (int)this.numPartitions, (short)this.replicationFactor);
        }
        if (this.edgesFile != null) {
            if (this.edgesTopic == null) {
                throw new IllegalArgumentException("Missing edges topic.");
            }
            Parsers.EdgeParser edgeReader = (Parsers.EdgeParser)ClientUtils.getConfiguredInstance(Class.forName(this.edgeParser), null);
            Serializer edgeValueWriter = (Serializer)ClientUtils.getConfiguredInstance(Class.forName(this.edgeValueSerializer), null);
            GraphUtils.edgesToTopic((InputStream)new BufferedInputStream(new FileInputStream(this.edgesFile)), (Parser)edgeReader, (Serializer)edgeValueWriter, (Properties)props, (String)this.edgesTopic, (int)this.numPartitions, (short)this.replicationFactor);
        }
        return null;
    }

    public static void main(String[] args) {
        CommandLine.call((Callable)new GraphImporter(), (String[])args);
    }
}

