/*
 * Decompiled with CFR 0.152.
 */
package io.kgraph.tools.library;

import io.kgraph.library.cf.CfLongId;
import io.kgraph.rest.server.graph.GraphAlgorithmResultRequest;
import io.kgraph.rest.server.graph.GraphAlgorithmStatus;
import io.kgraph.rest.server.graph.KeyValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.jblas.FloatMatrix;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import picocli.CommandLine;
import reactor.core.publisher.Mono;

@CommandLine.Command(description={"Predicts a rating for a given user and item."}, name="svdpp-predict", mixinStandardHelpOptions=true, version={"svdpp-predict 1.0"})
public class SvdppPredictor
implements Callable<Void> {
    private static final Logger log = LoggerFactory.getLogger(SvdppPredictor.class);
    @CommandLine.Parameters(index="0", description={"Rest app server."})
    private String restAppServer;
    @CommandLine.Parameters(index="1", description={"Pregel graph ID."})
    private String id;
    @CommandLine.Option(names={"-u", "--user"}, description={"The user id."})
    private Long user;
    @CommandLine.Option(names={"-i", "--item"}, description={"The item id."})
    private Long item;

    public SvdppPredictor() {
    }

    public SvdppPredictor(String restAppServer, Long user, Long item) {
        this.restAppServer = restAppServer;
        this.user = user;
        this.item = item;
    }

    @Override
    public Void call() {
        try {
            String baseUrl = this.restAppServer;
            if (!baseUrl.startsWith("http://")) {
                baseUrl = "http://" + baseUrl;
            }
            WebClient client = WebClient.create((String)baseUrl);
            GraphAlgorithmStatus status = (GraphAlgorithmStatus)client.get().uri("/pregel/{id}", new Object[]{this.id}).retrieve().bodyToMono(GraphAlgorithmStatus.class).block();
            if (status == null) {
                log.error("Error: no status found");
                return null;
            }
            Map configs = (Map)client.get().uri("/pregel/{id}/configs", new Object[]{this.id}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
            if (configs == null) {
                log.error("Error: no configs found");
                return null;
            }
            double overallRating = Double.parseDouble((String)status.getAggregates().get("svd.overall.rating.aggregator"));
            long numEdges = Long.parseLong((String)status.getAggregates().get("edge.count.aggregator"));
            float meanRating = (float)(overallRating / (double)(numEdges * 2L));
            float minRating = ((Number)configs.getOrDefault("min.rating", Float.valueOf(0.0f))).floatValue();
            float maxRating = ((Number)configs.getOrDefault("max.rating", Float.valueOf(5.0f))).floatValue();
            List userFloats = this.getFloats(client, (byte)0, this.user.longValue());
            Float userBaseline = (Float)userFloats.remove(0);
            FloatMatrix userFactors = new FloatMatrix(userFloats);
            List itemFloats = this.getFloats(client, (byte)1, this.item.longValue());
            Float itemBaseline = (Float)itemFloats.remove(0);
            FloatMatrix itemFactors = new FloatMatrix(itemFloats);
            float predicted = meanRating + userBaseline.floatValue() + itemBaseline.floatValue() + itemFactors.dot(userFactors);
            log.info("Raw rating: " + predicted);
            predicted = Math.min(predicted, maxRating);
            predicted = Math.max(predicted, minRating);
            log.info("Predicted rating: " + predicted);
            System.out.println("Predicted rating: " + predicted);
        }
        catch (WebClientResponseException e) {
            log.error("Error: " + e.getMessage());
        }
        return null;
    }

    private List<Float> getFloats(WebClient client, byte type, long id) {
        GraphAlgorithmResultRequest key = new GraphAlgorithmResultRequest();
        key.setKey(new CfLongId(type, id).toString());
        KeyValue result = (KeyValue)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)client.post().uri("/pregel/{id}/result", new Object[]{this.id})).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM})).body((Publisher)Mono.just((Object)key), GraphAlgorithmResultRequest.class).retrieve().bodyToFlux(KeyValue.class).next().block();
        if (result == null) {
            return Collections.emptyList();
        }
        String[] values = result.getValue().split("(\\(|\\)|\\[|\\]|,\\s)");
        return Arrays.stream(values).filter(s -> !s.isEmpty()).map(Float::parseFloat).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        CommandLine.call((Callable)new SvdppPredictor(), (String[])args);
    }
}

