/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.http.jdk;

import com.microsoft.kiota.RequestHeaders;
import com.microsoft.kiota.ResponseHeaders;
import jakarta.annotation.Nonnull;
import java.net.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class HeadersCompatibility {
    private HeadersCompatibility() {
    }

    @Nonnull
    public static ResponseHeaders getResponseHeaders(@Nonnull HttpHeaders headers) {
        Objects.requireNonNull(headers);
        ResponseHeaders responseHeaders = new ResponseHeaders();
        headers.map().forEach((name, value) -> {
            Objects.requireNonNull(name);
            responseHeaders.put(name, new HashSet(value));
        });
        return responseHeaders;
    }

    @Nonnull
    public static HttpHeaders getHttpHeaders(@Nonnull RequestHeaders headers) {
        Map<String, List<String>> map = headers.entrySet().stream().map(elem -> Map.entry((String)elem.getKey(), new ArrayList((Collection)elem.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (List)e.getValue()));
        return HttpHeaders.of(map, (x, y) -> true);
    }
}

