/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.maven.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class KiotaMojo
extends AbstractMojo {
    private final Log log = new SystemStreamLog();
    @Parameter(defaultValue="false", property="kiota.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="kiota.system")
    private boolean useSystemKiota;
    @Parameter(required=true, defaultValue="${project.build.directory}/kiota/")
    private File targetBinaryFolder;
    @Parameter(defaultValue="${os.name}")
    private String osName;
    private String osArch = "x64";
    @Parameter(defaultValue="https://github.com/microsoft/kiota/releases/download")
    private String baseURL;
    @Parameter(defaultValue="1.9.1")
    private String kiotaVersion;
    @Parameter
    private File file;
    @Parameter
    URL url;
    @Parameter(defaultValue="${basedir}/target/openapi-spec")
    File downloadTarget;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/kiota")
    private File targetDirectory;
    @Parameter(defaultValue="io.kiota.serialization.json.JsonSerializationWriterFactory,com.microsoft.kiota.serialization.TextSerializationWriterFactory,com.microsoft.kiota.serialization.FormSerializationWriterFactory,com.microsoft.kiota.serialization.MultipartSerializationWriterFactory")
    private List<String> serializers;
    @Parameter(defaultValue="io.kiota.serialization.json.JsonParseNodeFactory,com.microsoft.kiota.serialization.TextParseNodeFactory,com.microsoft.kiota.serialization.FormParseNodeFactory")
    private List<String> deserializers;
    @Parameter(defaultValue="Java")
    private String language;
    @Parameter(defaultValue="ApiClient")
    private String clientClass;
    @Parameter(defaultValue="com.apisdk")
    private String namespace;
    @Parameter(defaultValue="false")
    private String cleanOutput;
    @Parameter(defaultValue="false")
    private String clearCache;
    @Parameter(defaultValue="30")
    private int kiotaTimeout;
    @Parameter(defaultValue="Warning")
    private String kiotaLogLevel;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    private static final String NEW_LINE = "\n";
    private final String infoMatchPrefix = "com.microsoft.kiota:microsoft-kiota-abstractions:";

    private File finalTargetDirectory() {
        Path namespaceResolver = this.targetDirectory.toPath();
        for (String part : this.namespace.split("\\.")) {
            namespaceResolver = namespaceResolver.resolve(part);
        }
        return namespaceResolver.toFile();
    }

    public void execute() {
        if (this.skip) {
            return;
        }
        KiotaParams kp = new KiotaParams(this.osName, this.osArch);
        String executable = "kiota";
        if (!this.useSystemKiota) {
            String executablePath = Path.of(this.targetBinaryFolder.getAbsolutePath(), this.kiotaVersion).toFile().getAbsolutePath();
            this.downloadAndExtract(this.baseURL + "/v" + this.kiotaVersion + "/" + kp.downloadArtifact() + ".zip", executablePath, kp);
            executable = Paths.get(executablePath, kp.binary()).toFile().getAbsolutePath();
        }
        File openApiSpec = null;
        if (this.file == null && this.url == null) {
            throw new IllegalArgumentException("Please provide one of a file or a url.");
        }
        if (this.file != null && this.url != null) {
            throw new IllegalArgumentException("Please provide ONLY one of a file or a url.");
        }
        if (this.file != null) {
            openApiSpec = new File(this.file.getAbsolutePath());
        } else if (this.url != null) {
            openApiSpec = this.downloadSpec(this.url);
        }
        this.executeKiota(executable, openApiSpec);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private File downloadSpec(URL url) {
        this.downloadTarget.mkdirs();
        File finalDestination = new File(this.downloadTarget, new File(url.getFile()).getName());
        if (finalDestination.exists()) {
            this.log.warn((CharSequence)("Skipping download of " + url + " because it already exists at " + finalDestination));
            return finalDestination;
        }
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());){
            File file;
            try (FileOutputStream fileOutputStream = new FileOutputStream(finalDestination);){
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                file = finalDestination;
            }
            return file;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error downloading OpenAPI from URL: " + url, e);
        }
    }

    private String runProcess(List<String> cmd, boolean returnOutput) {
        this.log.info((CharSequence)("Going to execute the command: " + cmd.stream().collect(Collectors.joining(" "))));
        Process ps = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(new File("."));
            if (!returnOutput) {
                pb.inheritIO();
            }
            ps = pb.start();
            ps.waitFor(this.kiotaTimeout, TimeUnit.SECONDS);
            if (ps.exitValue() != 0) {
                throw new RuntimeException("Error executing the Kiota command, exit code is " + ps.exitValue());
            }
            File kiotaLockFile = new File(this.finalTargetDirectory(), "kiota-lock.json");
            if (!kiotaLockFile.exists()) {
                throw new RuntimeException("Error executing the Kiota command, no output found, cannot find the generated lock file.");
            }
            if (returnOutput) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(ps.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line + NEW_LINE);
                }
                String result = sb.toString();
                this.log.info((CharSequence)("Returned output is:\n" + result));
                String string = result;
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to execute kiota", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to execute kiota", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.getOutputStream().close();
                }
                catch (IOException iOException) {}
                try {
                    ps.getErrorStream().close();
                }
                catch (IOException iOException) {}
                try {
                    ps.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void executeKiota(String binary, File openApiSpec) {
        if (!openApiSpec.exists()) {
            throw new IllegalArgumentException("Spec file not found on the path: " + openApiSpec.getAbsolutePath());
        }
        ArrayList<String> cmd = new ArrayList<String>();
        this.finalTargetDirectory().mkdirs();
        String finalTargetDirectory = this.finalTargetDirectory().getAbsolutePath();
        cmd.add(binary);
        cmd.add("generate");
        cmd.add("--openapi");
        cmd.add(openApiSpec.getAbsolutePath());
        cmd.add("--output");
        cmd.add(finalTargetDirectory);
        cmd.add("--language");
        cmd.add(this.language);
        cmd.add("--class-name");
        cmd.add(this.clientClass);
        cmd.add("--namespace-name");
        cmd.add(this.namespace);
        for (String serializer : this.serializers) {
            cmd.add("--serializer");
            cmd.add(serializer);
        }
        for (String deserializer : this.deserializers) {
            cmd.add("--deserializer");
            cmd.add(deserializer);
        }
        cmd.add("--clean-output");
        cmd.add(this.cleanOutput);
        cmd.add("--clear-cache");
        cmd.add(this.clearCache);
        cmd.add("--log-level");
        cmd.add(this.kiotaLogLevel);
        this.runProcess(cmd, false);
        this.project.addCompileSourceRoot(this.targetDirectory.getAbsolutePath());
    }

    private void downloadAndExtract(String url, String dest, KiotaParams kp) {
        block13: {
            try {
                URL s = new URL(url);
                File zipFile = Paths.get(dest, "kiota.zip").toFile();
                File finalDestination = Paths.get(dest, kp.binary()).toFile();
                if (finalDestination.exists()) break block13;
                new File(dest).mkdirs();
                ReadableByteChannel readableByteChannel = Channels.newChannel(s.openStream());
                try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);){
                    fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                }
                try (FileSystem fileSystem = FileSystems.newFileSystem(zipFile.toPath(), ((Object)((Object)this)).getClass().getClassLoader());){
                    Path fileToExtract = fileSystem.getPath("/" + kp.binary(), new String[0]);
                    Files.copy(fileToExtract, finalDestination.toPath(), new CopyOption[0]);
                }
                finalDestination.setExecutable(true, false);
                zipFile.delete();
            }
            catch (IOException e) {
                throw new IllegalStateException("Error downloading the Kiota release: " + url, e);
            }
        }
    }

    private static class KiotaParams {
        final String osName;
        final String osArch;

        public KiotaParams(String osName, String osArch) {
            this.osName = osName.toLowerCase(Locale.ROOT);
            this.osArch = osArch;
        }

        public String downloadArtifact() {
            if (this.osName.startsWith("mac") || this.osName.startsWith("osx")) {
                return "osx-x64";
            }
            if (this.osName.startsWith("windows")) {
                return "win-x64";
            }
            if (this.osName.startsWith("linux")) {
                return "linux-x64";
            }
            throw new IllegalArgumentException("Detected OS is not supported: " + this.osName);
        }

        public String binary() {
            if (this.osName.startsWith("windows")) {
                return "kiota.exe";
            }
            return "kiota";
        }
    }
}

