/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.serialization.json;

import com.fasterxml.jackson.databind.ObjectReader;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import io.kiota.serialization.json.JsonMapper;
import io.kiota.serialization.json.JsonParseNode;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class JsonParseNodeFactory
implements ParseNodeFactory {
    private static final String validContentType = "application/json";

    @Nonnull
    public String getValidContentType() {
        return validContentType;
    }

    protected ObjectReader getObjectReader() {
        return JsonMapper.mapper.reader();
    }

    @Nonnull
    public ParseNode getParseNode(@Nonnull String contentType, @Nonnull InputStream rawResponse) {
        JsonParseNode jsonParseNode;
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        Objects.requireNonNull(rawResponse, "parameter rawResponse cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        if (!contentType.equals(validContentType)) {
            throw new IllegalArgumentException("expected a application/json content type");
        }
        InputStreamReader reader = new InputStreamReader(rawResponse, StandardCharsets.UTF_8);
        try {
            jsonParseNode = new JsonParseNode(this.getObjectReader().readTree((Reader)reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("could not close the reader", ex);
            }
        }
        reader.close();
        return jsonParseNode;
    }
}

