/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.serialization.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ValuedEnumParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class JsonParseNode
implements ParseNode {
    private final JsonNode currentNode;
    private Consumer<Parsable> onBeforeAssignFieldValues;
    private Consumer<Parsable> onAfterAssignFieldValues;

    public JsonParseNode(@Nonnull JsonNode node) {
        this.currentNode = Objects.requireNonNull(node, "parameter node cannot be null");
    }

    @Nullable
    public ParseNode getChildNode(@Nonnull String identifier) {
        Objects.requireNonNull(identifier, "identifier parameter is required");
        if (this.currentNode.isObject()) {
            final Consumer<Parsable> onBefore = this.onBeforeAssignFieldValues;
            final Consumer<Parsable> onAfter = this.onAfterAssignFieldValues;
            return new JsonParseNode(this.currentNode.get(identifier)){
                {
                    super(node);
                    this.setOnBeforeAssignFieldValues(onBefore);
                    this.setOnAfterAssignFieldValues(onAfter);
                }
            };
        }
        return null;
    }

    @Nullable
    public String getStringValue() {
        return this.currentNode.isTextual() ? this.currentNode.textValue() : null;
    }

    @Nullable
    public Boolean getBooleanValue() {
        return this.currentNode.isBoolean() ? Boolean.valueOf(this.currentNode.booleanValue()) : null;
    }

    @Nullable
    public Byte getByteValue() {
        int intValue;
        if (this.currentNode.isInt() && (intValue = this.currentNode.intValue()) >= -128 && intValue <= 127) {
            return Integer.valueOf(intValue).byteValue();
        }
        return null;
    }

    @Nullable
    public Short getShortValue() {
        return this.currentNode.canConvertToInt() ? Short.valueOf(this.currentNode.shortValue()) : null;
    }

    @Nullable
    public BigDecimal getBigDecimalValue() {
        return this.currentNode.isNumber() ? this.currentNode.decimalValue() : null;
    }

    @Nullable
    public Integer getIntegerValue() {
        return this.currentNode.canConvertToInt() ? Integer.valueOf(this.currentNode.intValue()) : null;
    }

    @Nullable
    public Float getFloatValue() {
        double doubleValue;
        if (this.currentNode.isNumber() && (doubleValue = this.currentNode.doubleValue()) >= (double)1.4E-45f && doubleValue <= 3.4028234663852886E38) {
            return Float.valueOf(Double.valueOf(doubleValue).floatValue());
        }
        return null;
    }

    @Nullable
    public Double getDoubleValue() {
        return this.currentNode.isNumber() ? Double.valueOf(this.currentNode.doubleValue()) : null;
    }

    @Nullable
    public Long getLongValue() {
        return this.currentNode.canConvertToLong() ? Long.valueOf(this.currentNode.longValue()) : null;
    }

    @Nullable
    public UUID getUUIDValue() {
        if (this.currentNode.isTextual() && !this.currentNode.isNull()) {
            return UUID.fromString(this.currentNode.textValue());
        }
        return null;
    }

    @Nullable
    public OffsetDateTime getOffsetDateTimeValue() {
        if (this.currentNode.isTextual() && !this.currentNode.isNull()) {
            return OffsetDateTime.parse(this.currentNode.textValue());
        }
        return null;
    }

    @Nullable
    public LocalDate getLocalDateValue() {
        if (this.currentNode.isTextual() && !this.currentNode.isNull()) {
            return LocalDate.parse(this.currentNode.textValue());
        }
        return null;
    }

    @Nullable
    public LocalTime getLocalTimeValue() {
        if (this.currentNode.isTextual() && !this.currentNode.isNull()) {
            return LocalTime.parse(this.currentNode.textValue());
        }
        return null;
    }

    @Nullable
    public PeriodAndDuration getPeriodAndDurationValue() {
        if (this.currentNode.isTextual() && !this.currentNode.isNull()) {
            return PeriodAndDuration.parse((String)this.currentNode.textValue());
        }
        return null;
    }

    @Nullable
    private <T> T getPrimitiveElement(@Nonnull Class<T> targetClass, @Nonnull JsonParseNode itemNode) {
        if (targetClass == Boolean.class) {
            return (T)itemNode.getBooleanValue();
        }
        if (targetClass == Short.class) {
            return (T)itemNode.getShortValue();
        }
        if (targetClass == Byte.class) {
            return (T)itemNode.getByteValue();
        }
        if (targetClass == BigDecimal.class) {
            return (T)itemNode.getBigDecimalValue();
        }
        if (targetClass == String.class) {
            return (T)itemNode.getStringValue();
        }
        if (targetClass == Integer.class) {
            return (T)itemNode.getIntegerValue();
        }
        if (targetClass == Float.class) {
            return (T)itemNode.getFloatValue();
        }
        if (targetClass == Long.class) {
            return (T)itemNode.getLongValue();
        }
        if (targetClass == UUID.class) {
            return (T)itemNode.getUUIDValue();
        }
        if (targetClass == OffsetDateTime.class) {
            return (T)itemNode.getOffsetDateTimeValue();
        }
        if (targetClass == LocalDate.class) {
            return (T)itemNode.getLocalDateValue();
        }
        if (targetClass == LocalTime.class) {
            return (T)itemNode.getLocalTimeValue();
        }
        if (targetClass == PeriodAndDuration.class) {
            return (T)itemNode.getPeriodAndDurationValue();
        }
        throw new RuntimeException("unknown type to deserialize " + targetClass.getName());
    }

    @Nullable
    public <T> List<T> getCollectionOfPrimitiveValues(@Nonnull Class<T> targetClass) {
        Objects.requireNonNull(targetClass, "parameter targetClass cannot be null");
        if (this.currentNode.isNull()) {
            return null;
        }
        if (this.currentNode.isArray()) {
            Iterator iter = this.currentNode.elements();
            ArrayList<T> result = new ArrayList<T>();
            while (iter.hasNext()) {
                JsonNode item = (JsonNode)iter.next();
                JsonParseNode itemNode = new JsonParseNode(item);
                itemNode.setOnBeforeAssignFieldValues(this.getOnBeforeAssignFieldValues());
                itemNode.setOnAfterAssignFieldValues(this.getOnAfterAssignFieldValues());
                result.add(this.getPrimitiveElement(targetClass, itemNode));
            }
            return result;
        }
        throw new RuntimeException("invalid state expected to have an array node");
    }

    @Nullable
    public <T extends Parsable> List<T> getCollectionOfObjectValues(@Nonnull ParsableFactory<T> factory) {
        Objects.requireNonNull(factory, "parameter factory cannot be null");
        if (this.currentNode.isNull()) {
            return null;
        }
        if (this.currentNode.isArray()) {
            Iterator iter = this.currentNode.elements();
            ArrayList<T> result = new ArrayList<T>();
            while (iter.hasNext()) {
                JsonNode item = (JsonNode)iter.next();
                JsonParseNode itemNode = new JsonParseNode(item);
                itemNode.setOnBeforeAssignFieldValues(this.getOnBeforeAssignFieldValues());
                itemNode.setOnAfterAssignFieldValues(this.getOnAfterAssignFieldValues());
                result.add(itemNode.getObjectValue(factory));
            }
            return result;
        }
        return null;
    }

    @Nullable
    public <T extends Enum<T>> List<T> getCollectionOfEnumValues(@Nonnull ValuedEnumParser<T> enumParser) {
        Objects.requireNonNull(enumParser, "parameter enumParser cannot be null");
        if (this.currentNode.isNull()) {
            return null;
        }
        if (this.currentNode.isArray()) {
            Iterator iter = this.currentNode.elements();
            ArrayList<T> result = new ArrayList<T>();
            while (iter.hasNext()) {
                JsonNode item = (JsonNode)iter.next();
                JsonParseNode itemNode = new JsonParseNode(item);
                itemNode.setOnBeforeAssignFieldValues(this.getOnBeforeAssignFieldValues());
                itemNode.setOnAfterAssignFieldValues(this.getOnAfterAssignFieldValues());
                result.add(itemNode.getEnumValue(enumParser));
            }
            return result;
        }
        throw new RuntimeException("invalid state expected to have an array node");
    }

    @Nonnull
    public <T extends Parsable> T getObjectValue(@Nonnull ParsableFactory<T> factory) {
        Objects.requireNonNull(factory, "parameter factory cannot be null");
        Parsable item = factory.create((ParseNode)this);
        this.assignFieldValues(item, item.getFieldDeserializers());
        return (T)item;
    }

    @Nullable
    public <T extends Enum<T>> T getEnumValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        return (T)enumParser.forValue(rawValue);
    }

    @Nullable
    public <T extends Enum<T>> EnumSet<T> getEnumSetValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String[] rawValues;
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        ArrayList<Enum> result = new ArrayList<Enum>();
        for (String rawValueItem : rawValues = rawValue.split(",")) {
            Enum value = enumParser.forValue(rawValueItem);
            if (value == null) continue;
            result.add(value);
        }
        return EnumSet.copyOf(result);
    }

    private <T extends Parsable> void assignFieldValues(T item, Map<String, Consumer<ParseNode>> fieldDeserializers) {
        if (this.currentNode.isObject()) {
            if (this.onBeforeAssignFieldValues != null) {
                this.onBeforeAssignFieldValues.accept(item);
            }
            Map itemAdditionalData = null;
            if (item instanceof AdditionalDataHolder) {
                itemAdditionalData = ((AdditionalDataHolder)item).getAdditionalData();
            }
            Iterator iter = this.currentNode.fields();
            while (iter.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)iter.next();
                String fieldKey = (String)fieldEntry.getKey();
                Consumer<ParseNode> fieldDeserializer = fieldDeserializers.get(fieldKey);
                JsonNode fieldValue = (JsonNode)fieldEntry.getValue();
                if (fieldValue.isNull()) continue;
                if (fieldDeserializer != null) {
                    JsonParseNode itemNode = new JsonParseNode(fieldValue);
                    itemNode.setOnBeforeAssignFieldValues(this.onBeforeAssignFieldValues);
                    itemNode.setOnAfterAssignFieldValues(this.onAfterAssignFieldValues);
                    fieldDeserializer.accept(itemNode);
                    continue;
                }
                if (itemAdditionalData == null) continue;
                itemAdditionalData.put(fieldKey, this.tryGetAnything(fieldValue));
            }
            if (this.onAfterAssignFieldValues != null) {
                this.onAfterAssignFieldValues.accept(item);
            }
        }
    }

    private Object tryGetAnything(JsonNode element) {
        if (element.isNull()) {
            return null;
        }
        if (element.isValueNode()) {
            if (element.isBoolean()) {
                return element.booleanValue();
            }
            if (element.isTextual()) {
                return element.textValue();
            }
            if (element.isInt()) {
                return element.intValue();
            }
            if (element.isLong()) {
                return element.longValue();
            }
            if (element.isFloatingPointNumber() && element.isFloat()) {
                return Float.valueOf(element.floatValue());
            }
            if (element.isFloatingPointNumber() && element.isDouble()) {
                return element.doubleValue();
            }
            throw new RuntimeException("Could not get the value during deserialization, unknown primitive type");
        }
        if (element.isObject() || element.isArray()) {
            return element;
        }
        throw new RuntimeException("Could not get the value during deserialization, unknown primitive type");
    }

    @Nullable
    public Consumer<Parsable> getOnBeforeAssignFieldValues() {
        return this.onBeforeAssignFieldValues;
    }

    @Nullable
    public Consumer<Parsable> getOnAfterAssignFieldValues() {
        return this.onAfterAssignFieldValues;
    }

    public void setOnBeforeAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onBeforeAssignFieldValues = value;
    }

    public void setOnAfterAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onAfterAssignFieldValues = value;
    }

    @Nullable
    public byte[] getByteArrayValue() {
        String base64 = this.getStringValue();
        if (base64 == null || base64.isEmpty()) {
            return null;
        }
        return Base64.getDecoder().decode(base64);
    }
}

