/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.serialization.json;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import io.kiota.serialization.json.JsonMapper;
import io.kiota.serialization.json.JsonSerializationWriter;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class JsonSerializationWriterFactory
implements SerializationWriterFactory {
    private static final String validContentType = "application/json";

    @Nonnull
    public String getValidContentType() {
        return validContentType;
    }

    protected ObjectWriter getObjectWriter() {
        return JsonMapper.mapper.writer();
    }

    @Nonnull
    public SerializationWriter getSerializationWriter(@Nonnull String contentType) {
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        if (!contentType.equals(validContentType)) {
            throw new IllegalArgumentException("expected a application/json content type");
        }
        return new JsonSerializationWriter(this.getObjectWriter());
    }
}

