package io.kiw.speedy;

import io.kiw.speedy.channel.PublisherSequenceState;
import io.kiw.speedy.subscriber.SubscriberChannelState;

import java.nio.ByteBuffer;
import java.util.Set;

public class PublisherBucket {
    private final PublisherSequenceState packetPublisherSequenceState;
    private final Set<String> keysToPublishTo;
    private final SubscriberChannelState subscriberChannelState;
    private final SpeedyConnection[] speedyConnections;

    public PublisherBucket(Set<String> keysToPublishTo, int windowSize, int localhostIdentifier, int channelIdentifier, SubscriberChannelState subscriberChannelState, SpeedyConnection[] speedyConnections) {
        this.speedyConnections = speedyConnections;
        this.keysToPublishTo = keysToPublishTo;
        packetPublisherSequenceState = PublisherSequenceState.initialise(windowSize,localhostIdentifier, channelIdentifier);
        this.subscriberChannelState = subscriberChannelState;
    }

    public SpeedyConnection[] getRemoteConnections() {
        return speedyConnections;
    }

    public boolean hasKey(String key) {
        return keysToPublishTo.contains(key);
    }

    public ByteBuffer getPacketBuffer() {
        return packetPublisherSequenceState.getCurrentPublisherBuffer();
    }

    public PublisherSequenceState getChannelState() {
        return packetPublisherSequenceState;
    }

    public SubscriberChannelState getSubscriberChannelState() {
        return subscriberChannelState;
    }
}
