package io.kiw.speedy;

import io.kiw.speedy.subscriber.SpeedyMessageHandler;
import io.kiw.speedy.subscriber.SpeedyMessageReplyHandler;

import java.io.IOException;

public interface SpeedyMessaging {
    void subscribe(String key, SpeedyMessageHandler messageHandler);

    void subscribe(String key, SpeedyMessageReplyHandler messageHandler);
    void publish(String key, byte[] bytes);
    void publish(String key, byte[] bytes, int dataLength);

    void request(String key, byte[] bytes, SpeedyMessageHandler responseHandler);

    void close() throws IOException;
}
