package io.kiw.speedy.builder;

import io.kiw.speedy.SpeedyHost;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class KeysBuilder {
    public static final String RESPONSE_SUFFIX = "-RESPONSE-KEY-SPM";


    public static Set<String> buildAllKeysIncludingResponseKeysToPublishers(SpeedyChannel speedyChannel, String channelName) {
        Set<String> allKeysIncludingResponseKeys = new HashSet<>(speedyChannel.keys);
        for (SpeedyHost subscriberHost : speedyChannel.publisherHosts) {
            final String remoteHostKey = buildResponseKey(subscriberHost, channelName);
            allKeysIncludingResponseKeys.add(remoteHostKey);
        }
        return allKeysIncludingResponseKeys;
    }

    public static String buildResponseKey(SpeedyHost host, String channelName) {
        return channelName.hashCode() + "-" + host.hashCode() + RESPONSE_SUFFIX;
    }

    public static Set<String> buildAllKeysAndMyResponseKeyForSubscribing(SpeedyChannel speedyChannel, String channelName, SpeedyHost perspectiveHost) {
        Set<String> keysWithLocalResponseKey = new HashSet<>(speedyChannel.keys);
        keysWithLocalResponseKey.add(buildResponseKey(perspectiveHost, channelName));
        return keysWithLocalResponseKey;
    }

    public static Collection<String> buildKeysForOnlyResponseForSubscribing(SpeedyHost perspectiveHost, String channelName) {
        Set<String> onlyResponse = new HashSet<>();
        onlyResponse.add(buildResponseKey(perspectiveHost, channelName));
        return onlyResponse;
    }

    public static Set<String> buildResponseKeysToPublishers(SpeedyChannel speedyChannel, String channelName) {
        HashSet<String> remoteHostResponseKeys = new HashSet<>();
        for (SpeedyHost publisherHost : speedyChannel.publisherHosts) {
            final String remoteHostKey = buildResponseKey(publisherHost, channelName);
            remoteHostResponseKeys.add(remoteHostKey);
        }
        return remoteHostResponseKeys;
    }
}
