package io.kiw.speedy.channel;

import io.kiw.speedy.subscriber.SpeedyMessageHandler;

import java.nio.ByteBuffer;

public class MultiResponseHandler {
    private final SpeedyMessageHandler responseHandler;
    private int expectedResponses;

    public MultiResponseHandler(SpeedyMessageHandler responseHandler, int expectedResponses) {
        this.responseHandler = responseHandler;
        this.expectedResponses = expectedResponses;
    }


    public boolean handleMessageAndGetRemainingExpectedResponseCount(ByteBuffer message) {
        responseHandler.handleMessage(message);
        return --expectedResponses == 0;
    }
}
