package io.kiw.speedy.channel;

import io.kiw.speedy.subscriber.SpeedyMessageHandler;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TemporaryResponseHandlerImpl implements TemporaryResponseHandler {
    private final ConcurrentMap<Long, MultiResponseHandler> responseHandlers = new ConcurrentHashMap<>();
    private final String responseKey;

    public TemporaryResponseHandlerImpl(String responseKey) {
        this.responseKey = responseKey;
    }

    @Override
    public void add(long sequenceNumber, SpeedyMessageHandler responseHandler, int expectedResponses) {
        responseHandlers.putIfAbsent(sequenceNumber, new MultiResponseHandler(responseHandler, expectedResponses));
    }

    @Override
    public void handle(final ByteBuffer message) {
        long originalRequestSequence = message.getLong();
        MultiResponseHandler multiResponseHandler = responseHandlers.get(originalRequestSequence);
        if(multiResponseHandler.handleMessageAndGetRemainingExpectedResponseCount(message))
        {
            responseHandlers.remove(originalRequestSequence);
        }
    }

    @Override
    public String getResponseKey() {
        return responseKey;
    }
}
