package io.kiw.speedy.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class ImmutableLongMap<T> {
    private final T[] underlyingArray;
    private final int mask;
    private final int size;
    private final Set<Long> keySet;
    private final Collection<T> values;

    ImmutableLongMap(T[] underlyingArray, Set<Long> keySet, Collection<T> values) {

        this.mask = underlyingArray.length - 1;
        this.underlyingArray = underlyingArray;
        this.keySet = Collections.unmodifiableSet(keySet);
        this.values = Collections.unmodifiableCollection(values);
        this.size = values.size();
    }

    public T get(long index)
    {
        return underlyingArray[(int)(index & mask)];
    }

    public Collection<T> values()
    {
        return values;
    }

    public boolean containsKey(long index) {
        return get(index) == null;
    }

    public int size() {
        return size;
    }

    public Set<Long> keySet() {
        return keySet;
    }
}
